/**
* animo is a powerful little tool that makes managing CSS animations extremely easy. Stack animations, set callbacks, make magic.
* Modern browsers and almost all mobile browsers support CSS animations (http://caniuse.com/css-animation).
*
* @author Daniel Raftery : twitter/ThrivingKings
* @version 1.0.3
*/

(function($,window,document,undefined){function animo(element,options,callback,other_cb){var defaults={duration:1,animation:null,iterate:1,delay:0,timing:"linear",keep:false};this.prefixes=["","-moz-","-o-animation-","-webkit-"];this.element=$(element);this.bare=element;this.queue=[];this.listening=false;var cb=(typeof callback=="function"?callback:other_cb);switch(options){case"blur":defaults={amount:3,duration:0.5,focusAfter:null};this.options=$.extend(defaults,callback);this._blur(cb);break;case"focus":this._focus();break;case"rotate":defaults={degrees:15,duration:0.5};this.options=$.extend(defaults,callback);this._rotate(cb);break;case"cleanse":this.cleanse();break;default:this.options=$.extend(defaults,options);this.init(cb);break}}animo.prototype={init:function(callback){var $me=this;if(Object.prototype.toString.call($me.options.animation)==="[object Array]"){$.merge($me.queue,$me.options.animation)}else{$me.queue.push($me.options.animation)}$me.cleanse();$me.animate(callback)},animate:function(callback){this.element.addClass("animated");this.element.addClass(this.queue[0]);this.element.data("animo",this.queue[0]);var ai=this.prefixes.length;while(ai--){this.element.css(this.prefixes[ai]+"animation-duration",this.options.duration+"s");this.element.css(this.prefixes[ai]+"animation-delay",this.options.delay+"s");this.element.css(this.prefixes[ai]+"animation-iteration-count",this.options.iterate);this.element.css(this.prefixes[ai]+"animation-timing-function",this.options.timing)}var $me=this,_cb=callback;if($me.queue.length>1){_cb=null}this._end("AnimationEnd",function(){if($me.element.hasClass($me.queue[0])){if(!$me.options.keep){$me.cleanse()}$me.queue.shift();if($me.queue.length){$me.animate(callback)}}},_cb)},cleanse:function(){this.element.removeClass("animated");this.element.removeClass(this.queue[0]);this.element.removeClass(this.element.data("animo"));var ai=this.prefixes.length;while(ai--){this.element.css(this.prefixes[ai]+"animation-duration","");this.element.css(this.prefixes[ai]+"animation-delay","");this.element.css(this.prefixes[ai]+"animation-iteration-count","");this.element.css(this.prefixes[ai]+"animation-timing-function","");this.element.css(this.prefixes[ai]+"transition","");this.element.css(this.prefixes[ai]+"transform","");this.element.css(this.prefixes[ai]+"filter","")}},_blur:function(callback){if(this.element.is("img")){var svg_id="svg_"+(((1+Math.random())*16777216)|0).toString(16).substring(1);var filter_id="filter_"+(((1+Math.random())*16777216)|0).toString(16).substring(1);$("body").append('<svg version="1.1" xmlns="http://www.w3.org/2000/svg" id="'+svg_id+'" style="height:0;position:absolute;top:-1000px;"><filter id="'+filter_id+'"><feGaussianBlur stdDeviation="'+this.options.amount+'" /></filter></svg>');var ai=this.prefixes.length;while(ai--){this.element.css(this.prefixes[ai]+"filter","blur("+this.options.amount+"px)");this.element.css(this.prefixes[ai]+"transition",this.options.duration+"s all linear")}this.element.css("filter","url(#"+filter_id+")");this.element.data("svgid",svg_id)}else{var color=this.element.css("color");var ai=this.prefixes.length;while(ai--){this.element.css(this.prefixes[ai]+"transition","all "+this.options.duration+"s linear")}this.element.css("text-shadow","0 0 "+this.options.amount+"px "+color);this.element.css("color","transparent")}this._end("TransitionEnd",null,callback);var $me=this;if(this.options.focusAfter){var focus_wait=window.setTimeout(function(){$me._focus();focus_wait=window.clearTimeout(focus_wait)},(this.options.focusAfter*1000))}},_focus:function(){var ai=this.prefixes.length;if(this.element.is("img")){while(ai--){this.element.css(this.prefixes[ai]+"filter","");this.element.css(this.prefixes[ai]+"transition","")}var $svg=$("#"+this.element.data("svgid"));$svg.remove()}else{while(ai--){this.element.css(this.prefixes[ai]+"transition","")}this.element.css("text-shadow","");this.element.css("color","")}},_rotate:function(callback){var ai=this.prefixes.length;while(ai--){this.element.css(this.prefixes[ai]+"transition","all "+this.options.duration+"s linear");this.element.css(this.prefixes[ai]+"transform","rotate("+this.options.degrees+"deg)")}this._end("TransitionEnd",null,callback)},_end:function(type,todo,callback){var $me=this;var binding=type.toLowerCase()+" webkit"+type+" o"+type+" MS"+type;this.element.bind(binding,function(){$me.element.unbind(binding);if(typeof todo=="function"){todo()}if(typeof callback=="function"){callback($me)}})}};$.fn.animo=function(options,callback,other_cb){return this.each(function(){new animo(this,options,callback,other_cb)})}})(jQuery,window,document);


/*
 *  jQuery carouFredSel 6.2.1
 *  Demo's and documentation:
 *  caroufredsel.dev7studios.com
 *
 *  Copyright (c) 2013 Fred Heusschen
 *  www.frebsite.nl
 *
 *  Dual licensed under the MIT and GPL licenses.
 *  http://en.wikipedia.org/wiki/MIT_License
 *  http://en.wikipedia.org/wiki/GNU_General_Public_License
 */

!function($){function sc_setScroll(t,e,s){return"transition"==s.transition&&"swing"==e&&(e="ease"),{anims:[],duration:t,orgDuration:t,easing:e,startTime:getTime()}}function sc_startScroll(t,e){for(var s=0,i=t.anims.length;i>s;s++){var o=t.anims[s];o&&o[0][e.transition](o[1],t.duration,t.easing,o[2])}}function sc_stopScroll(t,e){is_boolean(e)||(e=!0),is_object(t.pre)&&sc_stopScroll(t.pre,e);for(var s=0,i=t.anims.length;i>s;s++){var o=t.anims[s];o[0].stop(!0),e&&(o[0].css(o[1]),is_function(o[2])&&o[2]())}is_object(t.post)&&sc_stopScroll(t.post,e)}function sc_afterScroll(t,e,s){switch(e&&e.remove(),s.fx){case"fade":case"crossfade":case"cover-fade":case"uncover-fade":t.css("opacity",1),t.css("filter","")}}function sc_fireCallbacks(t,e,s,i,o){if(e[s]&&e[s].call(t,i),o[s].length)for(var n=0,r=o[s].length;r>n;n++)o[s][n].call(t,i);return[]}function sc_fireQueue(t,e,s){return e.length&&(t.trigger(cf_e(e[0][0],s),e[0][1]),e.shift()),e}function sc_hideHiddenItems(t){t.each(function(){var t=$(this);t.data("_cfs_isHidden",t.is(":hidden")).hide()})}function sc_showHiddenItems(t){t&&t.each(function(){var t=$(this);t.data("_cfs_isHidden")||t.show()})}function sc_clearTimers(t){return t.auto&&clearTimeout(t.auto),t.progress&&clearInterval(t.progress),t}function sc_mapCallbackArguments(t,e,s,i,o,n,r){return{width:r.width,height:r.height,items:{old:t,skipped:e,visible:s},scroll:{items:i,direction:o,duration:n}}}function sc_getDuration(t,e,s,i){var o=t.duration;return"none"==t.fx?0:("auto"==o?o=e.scroll.duration/e.scroll.items*s:10>o&&(o=i/o),1>o?0:("fade"==t.fx&&(o/=2),Math.round(o)))}function nv_showNavi(t,e,s){var i=is_number(t.items.minimum)?t.items.minimum:t.items.visible+1;if("show"==e||"hide"==e)var o=e;else if(i>e){debug(s,"Not enough items ("+e+" total, "+i+" needed): Hiding navigation.");var o="hide"}else var o="show";var n="show"==o?"removeClass":"addClass",r=cf_c("hidden",s);t.auto.button&&t.auto.button[o]()[n](r),t.prev.button&&t.prev.button[o]()[n](r),t.next.button&&t.next.button[o]()[n](r),t.pagination.container&&t.pagination.container[o]()[n](r)}function nv_enableNavi(t,e,s){if(!t.circular&&!t.infinite){var i="removeClass"==e||"addClass"==e?e:!1,o=cf_c("disabled",s);if(t.auto.button&&i&&t.auto.button[i](o),t.prev.button){var n=i||0==e?"addClass":"removeClass";t.prev.button[n](o)}if(t.next.button){var n=i||e==t.items.visible?"addClass":"removeClass";t.next.button[n](o)}}}function go_getObject(t,e){return is_function(e)?e=e.call(t):is_undefined(e)&&(e={}),e}function go_getItemsObject(t,e){return e=go_getObject(t,e),is_number(e)?e={visible:e}:"variable"==e?e={visible:e,width:e,height:e}:is_object(e)||(e={}),e}function go_getScrollObject(t,e){return e=go_getObject(t,e),is_number(e)?e=50>=e?{items:e}:{duration:e}:is_string(e)?e={easing:e}:is_object(e)||(e={}),e}function go_getNaviObject(t,e){if(e=go_getObject(t,e),is_string(e)){var s=cf_getKeyCode(e);e=-1==s?$(e):s}return e}function go_getAutoObject(t,e){return e=go_getNaviObject(t,e),is_jquery(e)?e={button:e}:is_boolean(e)?e={play:e}:is_number(e)&&(e={timeoutDuration:e}),e.progress&&(is_string(e.progress)||is_jquery(e.progress))&&(e.progress={bar:e.progress}),e}function go_complementAutoObject(t,e){return is_function(e.button)&&(e.button=e.button.call(t)),is_string(e.button)&&(e.button=$(e.button)),is_boolean(e.play)||(e.play=!0),is_number(e.delay)||(e.delay=0),is_undefined(e.pauseOnEvent)&&(e.pauseOnEvent=!0),is_boolean(e.pauseOnResize)||(e.pauseOnResize=!0),is_number(e.timeoutDuration)||(e.timeoutDuration=e.duration<10?2500:5*e.duration),e.progress&&(is_function(e.progress.bar)&&(e.progress.bar=e.progress.bar.call(t)),is_string(e.progress.bar)&&(e.progress.bar=$(e.progress.bar)),e.progress.bar?(is_function(e.progress.updater)||(e.progress.updater=$.fn.carouFredSel.progressbarUpdater),is_number(e.progress.interval)||(e.progress.interval=50)):e.progress=!1),e}function go_getPrevNextObject(t,e){return e=go_getNaviObject(t,e),is_jquery(e)?e={button:e}:is_number(e)&&(e={key:e}),e}function go_complementPrevNextObject(t,e){return is_function(e.button)&&(e.button=e.button.call(t)),is_string(e.button)&&(e.button=$(e.button)),is_string(e.key)&&(e.key=cf_getKeyCode(e.key)),e}function go_getPaginationObject(t,e){return e=go_getNaviObject(t,e),is_jquery(e)?e={container:e}:is_boolean(e)&&(e={keys:e}),e}function go_complementPaginationObject(t,e){return is_function(e.container)&&(e.container=e.container.call(t)),is_string(e.container)&&(e.container=$(e.container)),is_number(e.items)||(e.items=!1),is_boolean(e.keys)||(e.keys=!1),is_function(e.anchorBuilder)||is_false(e.anchorBuilder)||(e.anchorBuilder=$.fn.carouFredSel.pageAnchorBuilder),is_number(e.deviation)||(e.deviation=0),e}function go_getSwipeObject(t,e){return is_function(e)&&(e=e.call(t)),is_undefined(e)&&(e={onTouch:!1}),is_true(e)?e={onTouch:e}:is_number(e)&&(e={items:e}),e}function go_complementSwipeObject(t,e){return is_boolean(e.onTouch)||(e.onTouch=!0),is_boolean(e.onMouse)||(e.onMouse=!1),is_object(e.options)||(e.options={}),is_boolean(e.options.triggerOnTouchEnd)||(e.options.triggerOnTouchEnd=!1),e}function go_getMousewheelObject(t,e){return is_function(e)&&(e=e.call(t)),is_true(e)?e={}:is_number(e)?e={items:e}:is_undefined(e)&&(e=!1),e}function go_complementMousewheelObject(t,e){return e}function gn_getItemIndex(t,e,s,i,o){if(is_string(t)&&(t=$(t,o)),is_object(t)&&(t=$(t,o)),is_jquery(t)?(t=o.children().index(t),is_boolean(s)||(s=!1)):is_boolean(s)||(s=!0),is_number(t)||(t=0),is_number(e)||(e=0),s&&(t+=i.first),t+=e,i.total>0){for(;t>=i.total;)t-=i.total;for(;0>t;)t+=i.total}return t}function gn_getVisibleItemsPrev(t,e,s){for(var i=0,o=0,n=s;n>=0;n--){var r=t.eq(n);if(i+=r.is(":visible")?r[e.d.outerWidth](!0):0,i>e.maxDimension)return o;0==n&&(n=t.length),o++}}function gn_getVisibleItemsPrevFilter(t,e,s){return gn_getItemsPrevFilter(t,e.items.filter,e.items.visibleConf.org,s)}function gn_getScrollItemsPrevFilter(t,e,s,i){return gn_getItemsPrevFilter(t,e.items.filter,i,s)}function gn_getItemsPrevFilter(t,e,s,i){for(var o=0,n=0,r=i,c=t.length;r>=0;r--){if(n++,n==c)return n;var a=t.eq(r);if(a.is(e)&&(o++,o==s))return n;0==r&&(r=c)}}function gn_getVisibleOrg(t,e){return e.items.visibleConf.org||t.children().slice(0,e.items.visible).filter(e.items.filter).length}function gn_getVisibleItemsNext(t,e,s){for(var i=0,o=0,n=s,r=t.length-1;r>=n;n++){var c=t.eq(n);if(i+=c.is(":visible")?c[e.d.outerWidth](!0):0,i>e.maxDimension)return o;if(o++,o==r+1)return o;n==r&&(n=-1)}}function gn_getVisibleItemsNextTestCircular(t,e,s,i){var o=gn_getVisibleItemsNext(t,e,s);return e.circular||s+o>i&&(o=i-s),o}function gn_getVisibleItemsNextFilter(t,e,s){return gn_getItemsNextFilter(t,e.items.filter,e.items.visibleConf.org,s,e.circular)}function gn_getScrollItemsNextFilter(t,e,s,i){return gn_getItemsNextFilter(t,e.items.filter,i+1,s,e.circular)-1}function gn_getItemsNextFilter(t,e,s,i){for(var o=0,n=0,r=i,c=t.length-1;c>=r;r++){if(n++,n>=c)return n;var a=t.eq(r);if(a.is(e)&&(o++,o==s))return n;r==c&&(r=-1)}}function gi_getCurrentItems(t,e){return t.slice(0,e.items.visible)}function gi_getOldItemsPrev(t,e,s){return t.slice(s,e.items.visibleConf.old+s)}function gi_getNewItemsPrev(t,e){return t.slice(0,e.items.visible)}function gi_getOldItemsNext(t,e){return t.slice(0,e.items.visibleConf.old)}function gi_getNewItemsNext(t,e,s){return t.slice(s,e.items.visible+s)}function sz_storeMargin(t,e,s){e.usePadding&&(is_string(s)||(s="_cfs_origCssMargin"),t.each(function(){var t=$(this),i=parseInt(t.css(e.d.marginRight),10);is_number(i)||(i=0),t.data(s,i)}))}function sz_resetMargin(t,e,s){if(e.usePadding){var i=is_boolean(s)?s:!1;is_number(s)||(s=0),sz_storeMargin(t,e,"_cfs_tempCssMargin"),t.each(function(){var t=$(this);t.css(e.d.marginRight,i?t.data("_cfs_tempCssMargin"):s+t.data("_cfs_origCssMargin"))})}}function sz_storeOrigCss(t){t.each(function(){var t=$(this);t.data("_cfs_origCss",t.attr("style")||"")})}function sz_restoreOrigCss(t){t.each(function(){var t=$(this);t.attr("style",t.data("_cfs_origCss")||"")})}function sz_setResponsiveSizes(t,e){var s=(t.items.visible,t.items[t.d.width]),i=t[t.d.height],o=is_percentage(i);e.each(function(){var e=$(this),n=s-ms_getPaddingBorderMargin(e,t,"Width");e[t.d.width](n),o&&e[t.d.height](ms_getPercentage(n,i))})}function sz_setSizes(t,e){var s=t.parent(),i=t.children(),o=gi_getCurrentItems(i,e),n=cf_mapWrapperSizes(ms_getSizes(o,e,!0),e,!1);if(s.css(n),e.usePadding){var r=e.padding,c=r[e.d[1]];e.align&&0>c&&(c=0);var a=o.last();a.css(e.d.marginRight,a.data("_cfs_origCssMargin")+c),t.css(e.d.top,r[e.d[0]]),t.css(e.d.left,r[e.d[3]])}return t.css(e.d.width,n[e.d.width]+2*ms_getTotalSize(i,e,"width")),t.css(e.d.height,ms_getLargestSize(i,e,"height")),n}function ms_getSizes(t,e,s){return[ms_getTotalSize(t,e,"width",s),ms_getLargestSize(t,e,"height",s)]}function ms_getLargestSize(t,e,s,i){return is_boolean(i)||(i=!1),is_number(e[e.d[s]])&&i?e[e.d[s]]:is_number(e.items[e.d[s]])?e.items[e.d[s]]:(s=s.toLowerCase().indexOf("width")>-1?"outerWidth":"outerHeight",ms_getTrueLargestSize(t,e,s))}function ms_getTrueLargestSize(t,e,s){for(var i=0,o=0,n=t.length;n>o;o++){var r=t.eq(o),c=r.is(":visible")?r[e.d[s]](!0):0;c>i&&(i=c)}return i}function ms_getTotalSize(t,e,s,i){if(is_boolean(i)||(i=!1),is_number(e[e.d[s]])&&i)return e[e.d[s]];if(is_number(e.items[e.d[s]]))return e.items[e.d[s]]*t.length;for(var o=s.toLowerCase().indexOf("width")>-1?"outerWidth":"outerHeight",n=0,r=0,c=t.length;c>r;r++){var a=t.eq(r);n+=a.is(":visible")?a[e.d[o]](!0):0}return n}function ms_getParentSize(t,e,s){var i=t.is(":visible");i&&t.hide();var o=t.parent()[e.d[s]]();return i&&t.show(),o}function ms_getMaxDimension(t,e){return is_number(t[t.d.width])?t[t.d.width]:e}function ms_hasVariableSizes(t,e,s){for(var i=!1,o=!1,n=0,r=t.length;r>n;n++){var c=t.eq(n),a=c.is(":visible")?c[e.d[s]](!0):0;i===!1?i=a:i!=a&&(o=!0),0==i&&(o=!0)}return o}function ms_getPaddingBorderMargin(t,e,s){return t[e.d["outer"+s]](!0)-t[e.d[s.toLowerCase()]]()}function ms_getPercentage(t,e){if(is_percentage(e)){if(e=parseInt(e.slice(0,-1),10),!is_number(e))return t;t*=e/100}return t}function cf_e(t,e,s,i,o){return is_boolean(s)||(s=!0),is_boolean(i)||(i=!0),is_boolean(o)||(o=!1),s&&(t=e.events.prefix+t),i&&(t=t+"."+e.events.namespace),i&&o&&(t+=e.serialNumber),t}function cf_c(t,e){return is_string(e.classnames[t])?e.classnames[t]:t}function cf_mapWrapperSizes(t,e,s){is_boolean(s)||(s=!0);var i=e.usePadding&&s?e.padding:[0,0,0,0],o={};return o[e.d.width]=t[0]+i[1]+i[3],o[e.d.height]=t[1]+i[0]+i[2],o}function cf_sortParams(t,e){for(var s=[],i=0,o=t.length;o>i;i++)for(var n=0,r=e.length;r>n;n++)if(e[n].indexOf(typeof t[i])>-1&&is_undefined(s[n])){s[n]=t[i];break}return s}function cf_getPadding(t){if(is_undefined(t))return[0,0,0,0];if(is_number(t))return[t,t,t,t];if(is_string(t)&&(t=t.split("px").join("").split("em").join("").split(" ")),!is_array(t))return[0,0,0,0];for(var e=0;4>e;e++)t[e]=parseInt(t[e],10);switch(t.length){case 0:return[0,0,0,0];case 1:return[t[0],t[0],t[0],t[0]];case 2:return[t[0],t[1],t[0],t[1]];case 3:return[t[0],t[1],t[2],t[1]];default:return[t[0],t[1],t[2],t[3]]}}function cf_getAlignPadding(t,e){var s=is_number(e[e.d.width])?Math.ceil(e[e.d.width]-ms_getTotalSize(t,e,"width")):0;switch(e.align){case"left":return[0,s];case"right":return[s,0];case"center":default:return[Math.ceil(s/2),Math.floor(s/2)]}}function cf_getDimensions(t){for(var e=[["width","innerWidth","outerWidth","height","innerHeight","outerHeight","left","top","marginRight",0,1,2,3],["height","innerHeight","outerHeight","width","innerWidth","outerWidth","top","left","marginBottom",3,2,1,0]],s=e[0].length,i="right"==t.direction||"left"==t.direction?0:1,o={},n=0;s>n;n++)o[e[0][n]]=e[i][n];return o}function cf_getAdjust(t,e,s,i){var o=t;if(is_function(s))o=s.call(i,o);else if(is_string(s)){var n=s.split("+"),r=s.split("-");if(r.length>n.length)var c=!0,a=r[0],f=r[1];else var c=!1,a=n[0],f=n[1];switch(a){case"even":o=t%2==1?t-1:t;break;case"odd":o=t%2==0?t-1:t;break;default:o=t}f=parseInt(f,10),is_number(f)&&(c&&(f=-f),o+=f)}return(!is_number(o)||1>o)&&(o=1),o}function cf_getItemsAdjust(t,e,s,i){return cf_getItemAdjustMinMax(cf_getAdjust(t,e,s,i),e.items.visibleConf)}function cf_getItemAdjustMinMax(t,e){return is_number(e.min)&&t<e.min&&(t=e.min),is_number(e.max)&&t>e.max&&(t=e.max),1>t&&(t=1),t}function cf_getSynchArr(t){is_array(t)||(t=[[t]]),is_array(t[0])||(t=[t]);for(var e=0,s=t.length;s>e;e++)is_string(t[e][0])&&(t[e][0]=$(t[e][0])),is_boolean(t[e][1])||(t[e][1]=!0),is_boolean(t[e][2])||(t[e][2]=!0),is_number(t[e][3])||(t[e][3]=0);return t}function cf_getKeyCode(t){return"right"==t?39:"left"==t?37:"up"==t?38:"down"==t?40:-1}function cf_setCookie(t,e,s){if(t){var i=e.triggerHandler(cf_e("currentPosition",s));$.fn.carouFredSel.cookie.set(t,i)}}function cf_getCookie(t){var e=$.fn.carouFredSel.cookie.get(t);return""==e?0:e}function in_mapCss(t,e){for(var s={},i=0,o=e.length;o>i;i++)s[e[i]]=t.css(e[i]);return s}function in_complementItems(t,e,s,i){return is_object(t.visibleConf)||(t.visibleConf={}),is_object(t.sizesConf)||(t.sizesConf={}),0==t.start&&is_number(i)&&(t.start=i),is_object(t.visible)?(t.visibleConf.min=t.visible.min,t.visibleConf.max=t.visible.max,t.visible=!1):is_string(t.visible)?("variable"==t.visible?t.visibleConf.variable=!0:t.visibleConf.adjust=t.visible,t.visible=!1):is_function(t.visible)&&(t.visibleConf.adjust=t.visible,t.visible=!1),is_string(t.filter)||(t.filter=s.filter(":hidden").length>0?":visible":"*"),t[e.d.width]||(e.responsive?(debug(!0,"Set a "+e.d.width+" for the items!"),t[e.d.width]=ms_getTrueLargestSize(s,e,"outerWidth")):t[e.d.width]=ms_hasVariableSizes(s,e,"outerWidth")?"variable":s[e.d.outerWidth](!0)),t[e.d.height]||(t[e.d.height]=ms_hasVariableSizes(s,e,"outerHeight")?"variable":s[e.d.outerHeight](!0)),t.sizesConf.width=t.width,t.sizesConf.height=t.height,t}function in_complementVisibleItems(t,e){return"variable"==t.items[t.d.width]&&(t.items.visibleConf.variable=!0),t.items.visibleConf.variable||(is_number(t[t.d.width])?t.items.visible=Math.floor(t[t.d.width]/t.items[t.d.width]):(t.items.visible=Math.floor(e/t.items[t.d.width]),t[t.d.width]=t.items.visible*t.items[t.d.width],t.items.visibleConf.adjust||(t.align=!1)),("Infinity"==t.items.visible||t.items.visible<1)&&(debug(!0,'Not a valid number of visible items: Set to "variable".'),t.items.visibleConf.variable=!0)),t}function in_complementPrimarySize(t,e,s){return"auto"==t&&(t=ms_getTrueLargestSize(s,e,"outerWidth")),t}function in_complementSecondarySize(t,e,s){return"auto"==t&&(t=ms_getTrueLargestSize(s,e,"outerHeight")),t||(t=e.items[e.d.height]),t}function in_getAlignPadding(t,e){var s=cf_getAlignPadding(gi_getCurrentItems(e,t),t);return t.padding[t.d[1]]=s[1],t.padding[t.d[3]]=s[0],t}function in_getResponsiveValues(t,e){var s=cf_getItemAdjustMinMax(Math.ceil(t[t.d.width]/t.items[t.d.width]),t.items.visibleConf);s>e.length&&(s=e.length);var i=Math.floor(t[t.d.width]/s);return t.items.visible=s,t.items[t.d.width]=i,t[t.d.width]=s*i,t}function bt_pauseOnHoverConfig(t){if(is_string(t))var e=t.indexOf("immediate")>-1?!0:!1,s=t.indexOf("resume")>-1?!0:!1;else var e=s=!1;return[e,s]}function bt_mousesheelNumber(t){return is_number(t)?t:null}function is_null(t){return null===t}function is_undefined(t){return is_null(t)||"undefined"==typeof t||""===t||"undefined"===t}function is_array(t){return t instanceof Array}function is_jquery(t){return t instanceof jQuery}function is_object(t){return(t instanceof Object||"object"==typeof t)&&!is_null(t)&&!is_jquery(t)&&!is_array(t)&&!is_function(t)}function is_number(t){return(t instanceof Number||"number"==typeof t)&&!isNaN(t)}function is_string(t){return(t instanceof String||"string"==typeof t)&&!is_undefined(t)&&!is_true(t)&&!is_false(t)}function is_function(t){return t instanceof Function||"function"==typeof t}function is_boolean(t){return t instanceof Boolean||"boolean"==typeof t||is_true(t)||is_false(t)}function is_true(t){return t===!0||"true"===t}function is_false(t){return t===!1||"false"===t}function is_percentage(t){return is_string(t)&&"%"==t.slice(-1)}function getTime(){return(new Date).getTime()}function deprecated(t,e){debug(!0,t+" is DEPRECATED, support for it will be removed. Use "+e+" instead.")}function debug(t,e){if(!is_undefined(window.console)&&!is_undefined(window.console.log)){if(is_object(t)){var s=" ("+t.selector+")";t=t.debug}else var s="";if(!t)return!1;e=is_string(e)?"carouFredSel"+s+": "+e:["carouFredSel"+s+":",e]}return!1}$.fn.carouFredSel||($.fn.caroufredsel=$.fn.carouFredSel=function(options,configs){if(0==this.length)return this;if(this.length>1)return this.each(function(){$(this).carouFredSel(options,configs)});var $cfs=this,$tt0=this[0],starting_position=!1;$cfs.data("_cfs_isCarousel")&&(starting_position=$cfs.triggerHandler("_cfs_triggerEvent","currentPosition"),$cfs.trigger("_cfs_triggerEvent",["destroy",!0]));var FN={};FN._init=function(t,e,s){t=go_getObject($tt0,t),t.items=go_getItemsObject($tt0,t.items),t.scroll=go_getScrollObject($tt0,t.scroll),t.auto=go_getAutoObject($tt0,t.auto),t.prev=go_getPrevNextObject($tt0,t.prev),t.next=go_getPrevNextObject($tt0,t.next),t.pagination=go_getPaginationObject($tt0,t.pagination),t.swipe=go_getSwipeObject($tt0,t.swipe),t.mousewheel=go_getMousewheelObject($tt0,t.mousewheel),e&&(opts_orig=$.extend(!0,{},$.fn.carouFredSel.defaults,t)),opts=$.extend(!0,{},$.fn.carouFredSel.defaults,t),opts.d=cf_getDimensions(opts),crsl.direction="up"==opts.direction||"left"==opts.direction?"next":"prev";var i=$cfs.children(),o=ms_getParentSize($wrp,opts,"width");if(is_true(opts.cookie)&&(opts.cookie="caroufredsel_cookie_"+conf.serialNumber),opts.maxDimension=ms_getMaxDimension(opts,o),opts.items=in_complementItems(opts.items,opts,i,s),opts[opts.d.width]=in_complementPrimarySize(opts[opts.d.width],opts,i),opts[opts.d.height]=in_complementSecondarySize(opts[opts.d.height],opts,i),opts.responsive&&(is_percentage(opts[opts.d.width])||(opts[opts.d.width]="100%")),is_percentage(opts[opts.d.width])&&(crsl.upDateOnWindowResize=!0,crsl.primarySizePercentage=opts[opts.d.width],opts[opts.d.width]=ms_getPercentage(o,crsl.primarySizePercentage),opts.items.visible||(opts.items.visibleConf.variable=!0)),opts.responsive?(opts.usePadding=!1,opts.padding=[0,0,0,0],opts.align=!1,opts.items.visibleConf.variable=!1):(opts.items.visible||(opts=in_complementVisibleItems(opts,o)),opts[opts.d.width]||(!opts.items.visibleConf.variable&&is_number(opts.items[opts.d.width])&&"*"==opts.items.filter?(opts[opts.d.width]=opts.items.visible*opts.items[opts.d.width],opts.align=!1):opts[opts.d.width]="variable"),is_undefined(opts.align)&&(opts.align=is_number(opts[opts.d.width])?"center":!1),opts.items.visibleConf.variable&&(opts.items.visible=gn_getVisibleItemsNext(i,opts,0))),"*"==opts.items.filter||opts.items.visibleConf.variable||(opts.items.visibleConf.org=opts.items.visible,opts.items.visible=gn_getVisibleItemsNextFilter(i,opts,0)),opts.items.visible=cf_getItemsAdjust(opts.items.visible,opts,opts.items.visibleConf.adjust,$tt0),opts.items.visibleConf.old=opts.items.visible,opts.responsive)opts.items.visibleConf.min||(opts.items.visibleConf.min=opts.items.visible),opts.items.visibleConf.max||(opts.items.visibleConf.max=opts.items.visible),opts=in_getResponsiveValues(opts,i,o);else switch(opts.padding=cf_getPadding(opts.padding),"top"==opts.align?opts.align="left":"bottom"==opts.align&&(opts.align="right"),opts.align){case"center":case"left":case"right":"variable"!=opts[opts.d.width]&&(opts=in_getAlignPadding(opts,i),opts.usePadding=!0);break;default:opts.align=!1,opts.usePadding=0==opts.padding[0]&&0==opts.padding[1]&&0==opts.padding[2]&&0==opts.padding[3]?!1:!0}is_number(opts.scroll.duration)||(opts.scroll.duration=500),is_undefined(opts.scroll.items)&&(opts.scroll.items=opts.responsive||opts.items.visibleConf.variable||"*"!=opts.items.filter?"visible":opts.items.visible),opts.auto=$.extend(!0,{},opts.scroll,opts.auto),opts.prev=$.extend(!0,{},opts.scroll,opts.prev),opts.next=$.extend(!0,{},opts.scroll,opts.next),opts.pagination=$.extend(!0,{},opts.scroll,opts.pagination),opts.auto=go_complementAutoObject($tt0,opts.auto),opts.prev=go_complementPrevNextObject($tt0,opts.prev),opts.next=go_complementPrevNextObject($tt0,opts.next),opts.pagination=go_complementPaginationObject($tt0,opts.pagination),opts.swipe=go_complementSwipeObject($tt0,opts.swipe),opts.mousewheel=go_complementMousewheelObject($tt0,opts.mousewheel),opts.synchronise&&(opts.synchronise=cf_getSynchArr(opts.synchronise)),opts.auto.onPauseStart&&(opts.auto.onTimeoutStart=opts.auto.onPauseStart,deprecated("auto.onPauseStart","auto.onTimeoutStart")),opts.auto.onPausePause&&(opts.auto.onTimeoutPause=opts.auto.onPausePause,deprecated("auto.onPausePause","auto.onTimeoutPause")),opts.auto.onPauseEnd&&(opts.auto.onTimeoutEnd=opts.auto.onPauseEnd,deprecated("auto.onPauseEnd","auto.onTimeoutEnd")),opts.auto.pauseDuration&&(opts.auto.timeoutDuration=opts.auto.pauseDuration,deprecated("auto.pauseDuration","auto.timeoutDuration"))},FN._build=function(){$cfs.data("_cfs_isCarousel",!0);var t=$cfs.children(),e=in_mapCss($cfs,["textAlign","float","position","top","right","bottom","left","zIndex","width","height","marginTop","marginRight","marginBottom","marginLeft"]),s="relative";switch(e.position){case"absolute":case"fixed":s=e.position}"parent"==conf.wrapper?sz_storeOrigCss($wrp):$wrp.css(e),$wrp.css({overflow:"hidden",position:s}),sz_storeOrigCss($cfs),$cfs.data("_cfs_origCssZindex",e.zIndex),$cfs.css({textAlign:"left","float":"none",position:"absolute",top:0,right:"auto",bottom:"auto",left:0,marginTop:0,marginRight:0,marginBottom:0,marginLeft:0}),sz_storeMargin(t,opts),sz_storeOrigCss(t),opts.responsive&&sz_setResponsiveSizes(opts,t)},FN._bind_events=function(){FN._unbind_events(),$cfs.bind(cf_e("stop",conf),function(t,e){return t.stopPropagation(),crsl.isStopped||opts.auto.button&&opts.auto.button.addClass(cf_c("stopped",conf)),crsl.isStopped=!0,opts.auto.play&&(opts.auto.play=!1,$cfs.trigger(cf_e("pause",conf),e)),!0}),$cfs.bind(cf_e("finish",conf),function(t){return t.stopPropagation(),crsl.isScrolling&&sc_stopScroll(scrl),!0}),$cfs.bind(cf_e("pause",conf),function(t,e,s){if(t.stopPropagation(),tmrs=sc_clearTimers(tmrs),e&&crsl.isScrolling){scrl.isStopped=!0;var i=getTime()-scrl.startTime;scrl.duration-=i,scrl.pre&&(scrl.pre.duration-=i),scrl.post&&(scrl.post.duration-=i),sc_stopScroll(scrl,!1)}if(crsl.isPaused||crsl.isScrolling||s&&(tmrs.timePassed+=getTime()-tmrs.startTime),crsl.isPaused||opts.auto.button&&opts.auto.button.addClass(cf_c("paused",conf)),crsl.isPaused=!0,opts.auto.onTimeoutPause){var o=opts.auto.timeoutDuration-tmrs.timePassed,n=100-Math.ceil(100*o/opts.auto.timeoutDuration);opts.auto.onTimeoutPause.call($tt0,n,o)}return!0}),$cfs.bind(cf_e("play",conf),function(t,e,s,i){t.stopPropagation(),tmrs=sc_clearTimers(tmrs);var o=[e,s,i],n=["string","number","boolean"],r=cf_sortParams(o,n);if(e=r[0],s=r[1],i=r[2],"prev"!=e&&"next"!=e&&(e=crsl.direction),is_number(s)||(s=0),is_boolean(i)||(i=!1),i&&(crsl.isStopped=!1,opts.auto.play=!0),!opts.auto.play)return t.stopImmediatePropagation(),debug(conf,"Carousel stopped: Not scrolling.");crsl.isPaused&&opts.auto.button&&(opts.auto.button.removeClass(cf_c("stopped",conf)),opts.auto.button.removeClass(cf_c("paused",conf))),crsl.isPaused=!1,tmrs.startTime=getTime();var c=opts.auto.timeoutDuration+s;return dur2=c-tmrs.timePassed,perc=100-Math.ceil(100*dur2/c),opts.auto.progress&&(tmrs.progress=setInterval(function(){var t=getTime()-tmrs.startTime+tmrs.timePassed,e=Math.ceil(100*t/c);opts.auto.progress.updater.call(opts.auto.progress.bar[0],e)},opts.auto.progress.interval)),tmrs.auto=setTimeout(function(){opts.auto.progress&&opts.auto.progress.updater.call(opts.auto.progress.bar[0],100),opts.auto.onTimeoutEnd&&opts.auto.onTimeoutEnd.call($tt0,perc,dur2),crsl.isScrolling?$cfs.trigger(cf_e("play",conf),e):$cfs.trigger(cf_e(e,conf),opts.auto)},dur2),opts.auto.onTimeoutStart&&opts.auto.onTimeoutStart.call($tt0,perc,dur2),!0}),$cfs.bind(cf_e("resume",conf),function(t){return t.stopPropagation(),scrl.isStopped?(scrl.isStopped=!1,crsl.isPaused=!1,crsl.isScrolling=!0,scrl.startTime=getTime(),sc_startScroll(scrl,conf)):$cfs.trigger(cf_e("play",conf)),!0}),$cfs.bind(cf_e("prev",conf)+" "+cf_e("next",conf),function(t,e,s,i,o){if(t.stopPropagation(),crsl.isStopped||$cfs.is(":hidden"))return t.stopImmediatePropagation(),debug(conf,"Carousel stopped or hidden: Not scrolling.");var n=is_number(opts.items.minimum)?opts.items.minimum:opts.items.visible+1;if(n>itms.total)return t.stopImmediatePropagation(),debug(conf,"Not enough items ("+itms.total+" total, "+n+" needed): Not scrolling.");var r=[e,s,i,o],c=["object","number/string","function","boolean"],a=cf_sortParams(r,c);e=a[0],s=a[1],i=a[2],o=a[3];var f=t.type.slice(conf.events.prefix.length);if(is_object(e)||(e={}),is_function(i)&&(e.onAfter=i),is_boolean(o)&&(e.queue=o),e=$.extend(!0,{},opts[f],e),e.conditions&&!e.conditions.call($tt0,f))return t.stopImmediatePropagation(),debug(conf,'Callback "conditions" returned false.');if(!is_number(s)){if("*"!=opts.items.filter)s="visible";else for(var l=[s,e.items,opts[f].items],a=0,u=l.length;u>a;a++)if(is_number(l[a])||"page"==l[a]||"visible"==l[a]){s=l[a];break}switch(s){case"page":return t.stopImmediatePropagation(),$cfs.triggerHandler(cf_e(f+"Page",conf),[e,i]);case"visible":opts.items.visibleConf.variable||"*"!=opts.items.filter||(s=opts.items.visible)}}if(scrl.isStopped)return $cfs.trigger(cf_e("resume",conf)),$cfs.trigger(cf_e("queue",conf),[f,[e,s,i]]),t.stopImmediatePropagation(),debug(conf,"Carousel resumed scrolling.");if(e.duration>0&&crsl.isScrolling)return e.queue&&("last"==e.queue&&(queu=[]),("first"!=e.queue||0==queu.length)&&$cfs.trigger(cf_e("queue",conf),[f,[e,s,i]])),t.stopImmediatePropagation(),debug(conf,"Carousel currently scrolling.");if(tmrs.timePassed=0,$cfs.trigger(cf_e("slide_"+f,conf),[e,s]),opts.synchronise)for(var p=opts.synchronise,d=[e,s],g=0,u=p.length;u>g;g++){var m=f;p[g][2]||(m="prev"==m?"next":"prev"),p[g][1]||(d[0]=p[g][0].triggerHandler("_cfs_triggerEvent",["configuration",m])),d[1]=s+p[g][3],p[g][0].trigger("_cfs_triggerEvent",["slide_"+m,d])}return!0}),$cfs.bind(cf_e("slide_prev",conf),function(t,e,s){t.stopPropagation();var i=$cfs.children();if(!opts.circular&&0==itms.first)return opts.infinite&&$cfs.trigger(cf_e("next",conf),itms.total-1),t.stopImmediatePropagation();if(sz_resetMargin(i,opts),!is_number(s)){if(opts.items.visibleConf.variable)s=gn_getVisibleItemsPrev(i,opts,itms.total-1);else if("*"!=opts.items.filter){var o=is_number(e.items)?e.items:gn_getVisibleOrg($cfs,opts);s=gn_getScrollItemsPrevFilter(i,opts,itms.total-1,o)}else s=opts.items.visible;s=cf_getAdjust(s,opts,e.items,$tt0)}if(opts.circular||itms.total-s<itms.first&&(s=itms.total-itms.first),opts.items.visibleConf.old=opts.items.visible,opts.items.visibleConf.variable){var n=cf_getItemsAdjust(gn_getVisibleItemsNext(i,opts,itms.total-s),opts,opts.items.visibleConf.adjust,$tt0);opts.items.visible+s<=n&&s<itms.total&&(s++,n=cf_getItemsAdjust(gn_getVisibleItemsNext(i,opts,itms.total-s),opts,opts.items.visibleConf.adjust,$tt0)),opts.items.visible=n}else if("*"!=opts.items.filter){var n=gn_getVisibleItemsNextFilter(i,opts,itms.total-s);opts.items.visible=cf_getItemsAdjust(n,opts,opts.items.visibleConf.adjust,$tt0)}if(sz_resetMargin(i,opts,!0),0==s)return t.stopImmediatePropagation(),debug(conf,"0 items to scroll: Not scrolling.");for(debug(conf,"Scrolling "+s+" items backward."),itms.first+=s;itms.first>=itms.total;)itms.first-=itms.total;opts.circular||(0==itms.first&&e.onEnd&&e.onEnd.call($tt0,"prev"),opts.infinite||nv_enableNavi(opts,itms.first,conf)),$cfs.children().slice(itms.total-s,itms.total).prependTo($cfs),itms.total<opts.items.visible+s&&$cfs.children().slice(0,opts.items.visible+s-itms.total).clone(!0).appendTo($cfs);var i=$cfs.children(),r=gi_getOldItemsPrev(i,opts,s),c=gi_getNewItemsPrev(i,opts),a=i.eq(s-1),f=r.last(),l=c.last();sz_resetMargin(i,opts);var u=0,p=0;if(opts.align){var d=cf_getAlignPadding(c,opts);u=d[0],p=d[1]}var g=0>u?opts.padding[opts.d[3]]:0,m=!1,_=$();if(opts.items.visible<s&&(_=i.slice(opts.items.visibleConf.old,s),"directscroll"==e.fx)){var b=opts.items[opts.d.width];m=_,a=l,sc_hideHiddenItems(m),opts.items[opts.d.width]="variable"}var v=!1,h=ms_getTotalSize(i.slice(0,s),opts,"width"),w=cf_mapWrapperSizes(ms_getSizes(c,opts,!0),opts,!opts.usePadding),P=0,C={},x={},S={},y={},I={},z={},j={},N=sc_getDuration(e,opts,s,h);switch(e.fx){case"cover":case"cover-fade":P=ms_getTotalSize(i.slice(0,opts.items.visible),opts,"width")}m&&(opts.items[opts.d.width]=b),sz_resetMargin(i,opts,!0),p>=0&&sz_resetMargin(f,opts,opts.padding[opts.d[1]]),u>=0&&sz_resetMargin(a,opts,opts.padding[opts.d[3]]),opts.align&&(opts.padding[opts.d[1]]=p,opts.padding[opts.d[3]]=u),z[opts.d.left]=-(h-g),j[opts.d.left]=-(P-g),x[opts.d.left]=w[opts.d.width];var k=function(){},O=function(){},T=function(){},M=function(){},F=function(){},A=function(){},H=function(){},q=function(){},D=function(){},V=function(){},R=function(){};switch(e.fx){case"crossfade":case"cover":case"cover-fade":case"uncover":case"uncover-fade":v=$cfs.clone(!0).appendTo($wrp)}switch(e.fx){case"crossfade":case"uncover":case"uncover-fade":v.children().slice(0,s).remove(),v.children().slice(opts.items.visibleConf.old).remove();break;case"cover":case"cover-fade":v.children().slice(opts.items.visible).remove(),v.css(j)}if($cfs.css(z),scrl=sc_setScroll(N,e.easing,conf),C[opts.d.left]=opts.usePadding?opts.padding[opts.d[3]]:0,("variable"==opts[opts.d.width]||"variable"==opts[opts.d.height])&&(k=function(){$wrp.css(w)},O=function(){scrl.anims.push([$wrp,w])}),opts.usePadding){switch(l.not(a).length&&(S[opts.d.marginRight]=a.data("_cfs_origCssMargin"),0>u?a.css(S):(H=function(){a.css(S)},q=function(){scrl.anims.push([a,S])})),e.fx){case"cover":case"cover-fade":v.children().eq(s-1).css(S)}l.not(f).length&&(y[opts.d.marginRight]=f.data("_cfs_origCssMargin"),T=function(){f.css(y)},M=function(){scrl.anims.push([f,y])}),p>=0&&(I[opts.d.marginRight]=l.data("_cfs_origCssMargin")+opts.padding[opts.d[1]],F=function(){l.css(I)},A=function(){scrl.anims.push([l,I])})}R=function(){$cfs.css(C)};var E=opts.items.visible+s-itms.total;V=function(){if(E>0&&($cfs.children().slice(itms.total).remove(),r=$($cfs.children().slice(itms.total-(opts.items.visible-E)).get().concat($cfs.children().slice(0,E).get()))),sc_showHiddenItems(m),opts.usePadding){var t=$cfs.children().eq(opts.items.visible+s-1);t.css(opts.d.marginRight,t.data("_cfs_origCssMargin"))}};var W=sc_mapCallbackArguments(r,_,c,s,"prev",N,w);switch(D=function(){sc_afterScroll($cfs,v,e),crsl.isScrolling=!1,clbk.onAfter=sc_fireCallbacks($tt0,e,"onAfter",W,clbk),queu=sc_fireQueue($cfs,queu,conf),crsl.isPaused||$cfs.trigger(cf_e("play",conf))},crsl.isScrolling=!0,tmrs=sc_clearTimers(tmrs),clbk.onBefore=sc_fireCallbacks($tt0,e,"onBefore",W,clbk),e.fx){case"none":$cfs.css(C),k(),T(),F(),H(),R(),V(),D();break;case"fade":scrl.anims.push([$cfs,{opacity:0},function(){k(),T(),F(),H(),R(),V(),scrl=sc_setScroll(N,e.easing,conf),scrl.anims.push([$cfs,{opacity:1},D]),sc_startScroll(scrl,conf)}]);break;case"crossfade":$cfs.css({opacity:0}),scrl.anims.push([v,{opacity:0}]),scrl.anims.push([$cfs,{opacity:1},D]),O(),T(),F(),H(),R(),V();break;case"cover":scrl.anims.push([v,C,function(){T(),F(),H(),R(),V(),D()}]),O();break;case"cover-fade":scrl.anims.push([$cfs,{opacity:0}]),scrl.anims.push([v,C,function(){T(),F(),H(),R(),V(),D()}]),O();break;case"uncover":scrl.anims.push([v,x,D]),O(),T(),F(),H(),R(),V();break;case"uncover-fade":$cfs.css({opacity:0}),scrl.anims.push([$cfs,{opacity:1}]),scrl.anims.push([v,x,D]),O(),T(),F(),H(),R(),V();break;default:scrl.anims.push([$cfs,C,function(){V(),D()}]),O(),M(),A(),q()}return sc_startScroll(scrl,conf),cf_setCookie(opts.cookie,$cfs,conf),$cfs.trigger(cf_e("updatePageStatus",conf),[!1,w]),!0}),$cfs.bind(cf_e("slide_next",conf),function(t,e,s){t.stopPropagation();var i=$cfs.children();if(!opts.circular&&itms.first==opts.items.visible)return opts.infinite&&$cfs.trigger(cf_e("prev",conf),itms.total-1),t.stopImmediatePropagation();if(sz_resetMargin(i,opts),!is_number(s)){if("*"!=opts.items.filter){var o=is_number(e.items)?e.items:gn_getVisibleOrg($cfs,opts);s=gn_getScrollItemsNextFilter(i,opts,0,o)}else s=opts.items.visible;s=cf_getAdjust(s,opts,e.items,$tt0)}var n=0==itms.first?itms.total:itms.first;if(!opts.circular){if(opts.items.visibleConf.variable)var r=gn_getVisibleItemsNext(i,opts,s),o=gn_getVisibleItemsPrev(i,opts,n-1);else var r=opts.items.visible,o=opts.items.visible;s+r>n&&(s=n-o)}if(opts.items.visibleConf.old=opts.items.visible,opts.items.visibleConf.variable){for(var r=cf_getItemsAdjust(gn_getVisibleItemsNextTestCircular(i,opts,s,n),opts,opts.items.visibleConf.adjust,$tt0);opts.items.visible-s>=r&&s<itms.total;)s++,r=cf_getItemsAdjust(gn_getVisibleItemsNextTestCircular(i,opts,s,n),opts,opts.items.visibleConf.adjust,$tt0);opts.items.visible=r}else if("*"!=opts.items.filter){var r=gn_getVisibleItemsNextFilter(i,opts,s);opts.items.visible=cf_getItemsAdjust(r,opts,opts.items.visibleConf.adjust,$tt0)}if(sz_resetMargin(i,opts,!0),0==s)return t.stopImmediatePropagation(),debug(conf,"0 items to scroll: Not scrolling.");for(debug(conf,"Scrolling "+s+" items forward."),itms.first-=s;itms.first<0;)itms.first+=itms.total;opts.circular||(itms.first==opts.items.visible&&e.onEnd&&e.onEnd.call($tt0,"next"),opts.infinite||nv_enableNavi(opts,itms.first,conf)),itms.total<opts.items.visible+s&&$cfs.children().slice(0,opts.items.visible+s-itms.total).clone(!0).appendTo($cfs);var i=$cfs.children(),c=gi_getOldItemsNext(i,opts),a=gi_getNewItemsNext(i,opts,s),f=i.eq(s-1),l=c.last(),u=a.last();sz_resetMargin(i,opts);var p=0,d=0;if(opts.align){var g=cf_getAlignPadding(a,opts);p=g[0],d=g[1]}var m=!1,_=$();if(opts.items.visibleConf.old<s&&(_=i.slice(opts.items.visibleConf.old,s),"directscroll"==e.fx)){var b=opts.items[opts.d.width];m=_,f=l,sc_hideHiddenItems(m),opts.items[opts.d.width]="variable"}var v=!1,h=ms_getTotalSize(i.slice(0,s),opts,"width"),w=cf_mapWrapperSizes(ms_getSizes(a,opts,!0),opts,!opts.usePadding),P=0,C={},x={},S={},y={},I={},z=sc_getDuration(e,opts,s,h);switch(e.fx){case"uncover":case"uncover-fade":P=ms_getTotalSize(i.slice(0,opts.items.visibleConf.old),opts,"width")}m&&(opts.items[opts.d.width]=b),opts.align&&opts.padding[opts.d[1]]<0&&(opts.padding[opts.d[1]]=0),sz_resetMargin(i,opts,!0),sz_resetMargin(l,opts,opts.padding[opts.d[1]]),opts.align&&(opts.padding[opts.d[1]]=d,opts.padding[opts.d[3]]=p),I[opts.d.left]=opts.usePadding?opts.padding[opts.d[3]]:0;var j=function(){},N=function(){},k=function(){},O=function(){},T=function(){},M=function(){},F=function(){},A=function(){},H=function(){};switch(e.fx){case"crossfade":case"cover":case"cover-fade":case"uncover":case"uncover-fade":v=$cfs.clone(!0).appendTo($wrp),v.children().slice(opts.items.visibleConf.old).remove()}switch(e.fx){case"crossfade":case"cover":case"cover-fade":$cfs.css("zIndex",1),v.css("zIndex",0)}if(scrl=sc_setScroll(z,e.easing,conf),C[opts.d.left]=-h,x[opts.d.left]=-P,0>p&&(C[opts.d.left]+=p),("variable"==opts[opts.d.width]||"variable"==opts[opts.d.height])&&(j=function(){$wrp.css(w)},N=function(){scrl.anims.push([$wrp,w])}),opts.usePadding){var q=u.data("_cfs_origCssMargin");d>=0&&(q+=opts.padding[opts.d[1]]),u.css(opts.d.marginRight,q),f.not(l).length&&(y[opts.d.marginRight]=l.data("_cfs_origCssMargin")),k=function(){l.css(y)},O=function(){scrl.anims.push([l,y])};var D=f.data("_cfs_origCssMargin");p>0&&(D+=opts.padding[opts.d[3]]),S[opts.d.marginRight]=D,T=function(){f.css(S)},M=function(){scrl.anims.push([f,S])}}H=function(){$cfs.css(I)};var V=opts.items.visible+s-itms.total;A=function(){V>0&&$cfs.children().slice(itms.total).remove();var t=$cfs.children().slice(0,s).appendTo($cfs).last();if(V>0&&(a=gi_getCurrentItems(i,opts)),sc_showHiddenItems(m),opts.usePadding){if(itms.total<opts.items.visible+s){var e=$cfs.children().eq(opts.items.visible-1);e.css(opts.d.marginRight,e.data("_cfs_origCssMargin")+opts.padding[opts.d[1]])}t.css(opts.d.marginRight,t.data("_cfs_origCssMargin"))}};var R=sc_mapCallbackArguments(c,_,a,s,"next",z,w);switch(F=function(){$cfs.css("zIndex",$cfs.data("_cfs_origCssZindex")),sc_afterScroll($cfs,v,e),crsl.isScrolling=!1,clbk.onAfter=sc_fireCallbacks($tt0,e,"onAfter",R,clbk),queu=sc_fireQueue($cfs,queu,conf),crsl.isPaused||$cfs.trigger(cf_e("play",conf))},crsl.isScrolling=!0,tmrs=sc_clearTimers(tmrs),clbk.onBefore=sc_fireCallbacks($tt0,e,"onBefore",R,clbk),e.fx){case"none":$cfs.css(C),j(),k(),T(),H(),A(),F();break;case"fade":scrl.anims.push([$cfs,{opacity:0},function(){j(),k(),T(),H(),A(),scrl=sc_setScroll(z,e.easing,conf),scrl.anims.push([$cfs,{opacity:1},F]),sc_startScroll(scrl,conf)}]);break;case"crossfade":$cfs.css({opacity:0}),scrl.anims.push([v,{opacity:0}]),scrl.anims.push([$cfs,{opacity:1},F]),N(),k(),T(),H(),A();break;case"cover":$cfs.css(opts.d.left,$wrp[opts.d.width]()),scrl.anims.push([$cfs,I,F]),N(),k(),T(),A();break;case"cover-fade":$cfs.css(opts.d.left,$wrp[opts.d.width]()),scrl.anims.push([v,{opacity:0}]),scrl.anims.push([$cfs,I,F]),N(),k(),T(),A();break;case"uncover":scrl.anims.push([v,x,F]),N(),k(),T(),H(),A();break;case"uncover-fade":$cfs.css({opacity:0}),scrl.anims.push([$cfs,{opacity:1}]),scrl.anims.push([v,x,F]),N(),k(),T(),H(),A();break;default:scrl.anims.push([$cfs,C,function(){H(),A(),F()}]),N(),O(),M()}return sc_startScroll(scrl,conf),cf_setCookie(opts.cookie,$cfs,conf),$cfs.trigger(cf_e("updatePageStatus",conf),[!1,w]),!0}),$cfs.bind(cf_e("slideTo",conf),function(t,e,s,i,o,n,r){t.stopPropagation();var c=[e,s,i,o,n,r],a=["string/number/object","number","boolean","object","string","function"],f=cf_sortParams(c,a);return o=f[3],n=f[4],r=f[5],e=gn_getItemIndex(f[0],f[1],f[2],itms,$cfs),0==e?!1:(is_object(o)||(o=!1),"prev"!=n&&"next"!=n&&(n=opts.circular?e<=itms.total/2?"next":"prev":0==itms.first||itms.first>e?"next":"prev"),"prev"==n&&(e=itms.total-e),$cfs.trigger(cf_e(n,conf),[o,e,r]),!0)}),$cfs.bind(cf_e("prevPage",conf),function(t,e,s){t.stopPropagation();var i=$cfs.triggerHandler(cf_e("currentPage",conf));return $cfs.triggerHandler(cf_e("slideToPage",conf),[i-1,e,"prev",s])}),$cfs.bind(cf_e("nextPage",conf),function(t,e,s){t.stopPropagation();var i=$cfs.triggerHandler(cf_e("currentPage",conf));return $cfs.triggerHandler(cf_e("slideToPage",conf),[i+1,e,"next",s])}),$cfs.bind(cf_e("slideToPage",conf),function(t,e,s,i,o){t.stopPropagation(),is_number(e)||(e=$cfs.triggerHandler(cf_e("currentPage",conf)));var n=opts.pagination.items||opts.items.visible,r=Math.ceil(itms.total/n)-1;return 0>e&&(e=r),e>r&&(e=0),$cfs.triggerHandler(cf_e("slideTo",conf),[e*n,0,!0,s,i,o])}),$cfs.bind(cf_e("jumpToStart",conf),function(t,e){if(t.stopPropagation(),e=e?gn_getItemIndex(e,0,!0,itms,$cfs):0,e+=itms.first,0!=e){if(itms.total>0)for(;e>itms.total;)e-=itms.total;$cfs.prepend($cfs.children().slice(e,itms.total))}return!0}),$cfs.bind(cf_e("synchronise",conf),function(t,e){if(t.stopPropagation(),e)e=cf_getSynchArr(e);else{if(!opts.synchronise)return debug(conf,"No carousel to synchronise.");e=opts.synchronise}for(var s=$cfs.triggerHandler(cf_e("currentPosition",conf)),i=!0,o=0,n=e.length;n>o;o++)e[o][0].triggerHandler(cf_e("slideTo",conf),[s,e[o][3],!0])||(i=!1);return i}),$cfs.bind(cf_e("queue",conf),function(t,e,s){return t.stopPropagation(),is_function(e)?e.call($tt0,queu):is_array(e)?queu=e:is_undefined(e)||queu.push([e,s]),queu}),$cfs.bind(cf_e("insertItem",conf),function(t,e,s,i,o){t.stopPropagation();var n=[e,s,i,o],r=["string/object","string/number/object","boolean","number"],c=cf_sortParams(n,r);if(e=c[0],s=c[1],i=c[2],o=c[3],is_object(e)&&!is_jquery(e)?e=$(e):is_string(e)&&(e=$(e)),!is_jquery(e)||0==e.length)return debug(conf,"Not a valid object.");is_undefined(s)&&(s="end"),sz_storeMargin(e,opts),sz_storeOrigCss(e);var a=s,f="before";"end"==s?i?(0==itms.first?(s=itms.total-1,f="after"):(s=itms.first,itms.first+=e.length),0>s&&(s=0)):(s=itms.total-1,f="after"):s=gn_getItemIndex(s,o,i,itms,$cfs);var l=$cfs.children().eq(s);return l.length?l[f](e):(debug(conf,"Correct insert-position not found! Appending item to the end."),$cfs.append(e)),"end"==a||i||s<itms.first&&(itms.first+=e.length),itms.total=$cfs.children().length,itms.first>=itms.total&&(itms.first-=itms.total),$cfs.trigger(cf_e("updateSizes",conf)),$cfs.trigger(cf_e("linkAnchors",conf)),!0}),$cfs.bind(cf_e("removeItem",conf),function(t,e,s,i){t.stopPropagation();var o=[e,s,i],n=["string/number/object","boolean","number"],r=cf_sortParams(o,n);e=r[0],s=r[1],i=r[2];if(e instanceof $&&e.length>1)return c=$(),e.each(function(){var t=$cfs.trigger(cf_e("removeItem",conf),[$(this),s,i]);t&&(c=c.add(t))}),c;if(is_undefined(e)||"end"==e)c=$cfs.children().last();else{e=gn_getItemIndex(e,i,s,itms,$cfs);var c=$cfs.children().eq(e);c.length&&e<itms.first&&(itms.first-=c.length)}return c&&c.length&&(c.detach(),itms.total=$cfs.children().length,$cfs.trigger(cf_e("updateSizes",conf))),c}),$cfs.bind(cf_e("onBefore",conf)+" "+cf_e("onAfter",conf),function(t,e){t.stopPropagation();var s=t.type.slice(conf.events.prefix.length);return is_array(e)&&(clbk[s]=e),is_function(e)&&clbk[s].push(e),clbk[s]}),$cfs.bind(cf_e("currentPosition",conf),function(t,e){if(t.stopPropagation(),0==itms.first)var s=0;else var s=itms.total-itms.first;return is_function(e)&&e.call($tt0,s),s}),$cfs.bind(cf_e("currentPage",conf),function(t,e){t.stopPropagation();var s,i=opts.pagination.items||opts.items.visible,o=Math.ceil(itms.total/i-1);return s=0==itms.first?0:itms.first<itms.total%i?0:itms.first!=i||opts.circular?Math.round((itms.total-itms.first)/i):o,0>s&&(s=0),s>o&&(s=o),is_function(e)&&e.call($tt0,s),s}),$cfs.bind(cf_e("currentVisible",conf),function(t,e){t.stopPropagation();var s=gi_getCurrentItems($cfs.children(),opts);return is_function(e)&&e.call($tt0,s),s}),$cfs.bind(cf_e("slice",conf),function(t,e,s,i){if(t.stopPropagation(),0==itms.total)return!1;var o=[e,s,i],n=["number","number","function"],r=cf_sortParams(o,n);if(e=is_number(r[0])?r[0]:0,s=is_number(r[1])?r[1]:itms.total,i=r[2],e+=itms.first,s+=itms.first,items.total>0){for(;e>itms.total;)e-=itms.total;for(;s>itms.total;)s-=itms.total;for(;0>e;)e+=itms.total;for(;0>s;)s+=itms.total}var c,a=$cfs.children();return c=s>e?a.slice(e,s):$(a.slice(e,itms.total).get().concat(a.slice(0,s).get())),is_function(i)&&i.call($tt0,c),c}),$cfs.bind(cf_e("isPaused",conf)+" "+cf_e("isStopped",conf)+" "+cf_e("isScrolling",conf),function(t,e){t.stopPropagation();var s=t.type.slice(conf.events.prefix.length),i=crsl[s];return is_function(e)&&e.call($tt0,i),i}),$cfs.bind(cf_e("configuration",conf),function(e,a,b,c){e.stopPropagation();var reInit=!1;if(is_function(a))a.call($tt0,opts);else if(is_object(a))opts_orig=$.extend(!0,{},opts_orig,a),b!==!1?reInit=!0:opts=$.extend(!0,{},opts,a);else if(!is_undefined(a))if(is_function(b)){var val=eval("opts."+a);is_undefined(val)&&(val=""),b.call($tt0,val)}else{if(is_undefined(b))return eval("opts."+a);"boolean"!=typeof c&&(c=!0),eval("opts_orig."+a+" = b"),c!==!1?reInit=!0:eval("opts."+a+" = b")}if(reInit){sz_resetMargin($cfs.children(),opts),FN._init(opts_orig),FN._bind_buttons();var sz=sz_setSizes($cfs,opts);$cfs.trigger(cf_e("updatePageStatus",conf),[!0,sz])}return opts}),$cfs.bind(cf_e("linkAnchors",conf),function(t,e,s){return t.stopPropagation(),is_undefined(e)?e=$("body"):is_string(e)&&(e=$(e)),is_jquery(e)&&0!=e.length?(is_string(s)||(s="a.caroufredsel"),e.find(s).each(function(){var t=this.hash||"";t.length>0&&-1!=$cfs.children().index($(t))&&$(this).unbind("click").click(function(e){e.preventDefault(),$cfs.trigger(cf_e("slideTo",conf),t)})}),!0):debug(conf,"Not a valid object.")}),$cfs.bind(cf_e("updatePageStatus",conf),function(t,e){if(t.stopPropagation(),opts.pagination.container){var s=opts.pagination.items||opts.items.visible,i=Math.ceil(itms.total/s);e&&(opts.pagination.anchorBuilder&&(opts.pagination.container.children().remove(),opts.pagination.container.each(function(){for(var t=0;i>t;t++){var e=$cfs.children().eq(gn_getItemIndex(t*s,0,!0,itms,$cfs));$(this).append(opts.pagination.anchorBuilder.call(e[0],t+1))}})),opts.pagination.container.each(function(){$(this).children().unbind(opts.pagination.event).each(function(t){$(this).bind(opts.pagination.event,function(e){e.preventDefault(),$cfs.trigger(cf_e("slideTo",conf),[t*s,-opts.pagination.deviation,!0,opts.pagination])})})}));var o=$cfs.triggerHandler(cf_e("currentPage",conf))+opts.pagination.deviation;return o>=i&&(o=0),0>o&&(o=i-1),opts.pagination.container.each(function(){$(this).children().removeClass(cf_c("selected",conf)).eq(o).addClass(cf_c("selected",conf))}),!0}}),$cfs.bind(cf_e("updateSizes",conf),function(){var t=opts.items.visible,e=$cfs.children(),s=ms_getParentSize($wrp,opts,"width");if(itms.total=e.length,crsl.primarySizePercentage?(opts.maxDimension=s,opts[opts.d.width]=ms_getPercentage(s,crsl.primarySizePercentage)):opts.maxDimension=ms_getMaxDimension(opts,s),opts.responsive?(opts.items.width=opts.items.sizesConf.width,opts.items.height=opts.items.sizesConf.height,opts=in_getResponsiveValues(opts,e,s),t=opts.items.visible,sz_setResponsiveSizes(opts,e)):opts.items.visibleConf.variable?t=gn_getVisibleItemsNext(e,opts,0):"*"!=opts.items.filter&&(t=gn_getVisibleItemsNextFilter(e,opts,0)),!opts.circular&&0!=itms.first&&t>itms.first){if(opts.items.visibleConf.variable)var i=gn_getVisibleItemsPrev(e,opts,itms.first)-itms.first;else if("*"!=opts.items.filter)var i=gn_getVisibleItemsPrevFilter(e,opts,itms.first)-itms.first;else var i=opts.items.visible-itms.first;debug(conf,"Preventing non-circular: sliding "+i+" items backward."),$cfs.trigger(cf_e("prev",conf),i)}opts.items.visible=cf_getItemsAdjust(t,opts,opts.items.visibleConf.adjust,$tt0),opts.items.visibleConf.old=opts.items.visible,opts=in_getAlignPadding(opts,e);var o=sz_setSizes($cfs,opts);return $cfs.trigger(cf_e("updatePageStatus",conf),[!0,o]),nv_showNavi(opts,itms.total,conf),nv_enableNavi(opts,itms.first,conf),o}),$cfs.bind(cf_e("destroy",conf),function(t,e){return t.stopPropagation(),tmrs=sc_clearTimers(tmrs),$cfs.data("_cfs_isCarousel",!1),$cfs.trigger(cf_e("finish",conf)),e&&$cfs.trigger(cf_e("jumpToStart",conf)),sz_restoreOrigCss($cfs.children()),sz_restoreOrigCss($cfs),FN._unbind_events(),FN._unbind_buttons(),"parent"==conf.wrapper?sz_restoreOrigCss($wrp):$wrp.replaceWith($cfs),!0}),$cfs.bind(cf_e("debug",conf),function(){return debug(conf,"Carousel width: "+opts.width),debug(conf,"Carousel height: "+opts.height),debug(conf,"Item widths: "+opts.items.width),debug(conf,"Item heights: "+opts.items.height),debug(conf,"Number of items visible: "+opts.items.visible),opts.auto.play&&debug(conf,"Number of items scrolled automatically: "+opts.auto.items),opts.prev.button&&debug(conf,"Number of items scrolled backward: "+opts.prev.items),opts.next.button&&debug(conf,"Number of items scrolled forward: "+opts.next.items),conf.debug}),$cfs.bind("_cfs_triggerEvent",function(t,e,s){return t.stopPropagation(),$cfs.triggerHandler(cf_e(e,conf),s)})},FN._unbind_events=function(){$cfs.unbind(cf_e("",conf)),$cfs.unbind(cf_e("",conf,!1)),$cfs.unbind("_cfs_triggerEvent")},FN._bind_buttons=function(){if(FN._unbind_buttons(),nv_showNavi(opts,itms.total,conf),nv_enableNavi(opts,itms.first,conf),opts.auto.pauseOnHover){var t=bt_pauseOnHoverConfig(opts.auto.pauseOnHover);$wrp.bind(cf_e("mouseenter",conf,!1),function(){$cfs.trigger(cf_e("pause",conf),t)}).bind(cf_e("mouseleave",conf,!1),function(){$cfs.trigger(cf_e("resume",conf))})}if(opts.auto.button&&opts.auto.button.bind(cf_e(opts.auto.event,conf,!1),function(t){t.preventDefault();var e=!1,s=null;crsl.isPaused?e="play":opts.auto.pauseOnEvent&&(e="pause",s=bt_pauseOnHoverConfig(opts.auto.pauseOnEvent)),e&&$cfs.trigger(cf_e(e,conf),s)}),opts.prev.button&&(opts.prev.button.bind(cf_e(opts.prev.event,conf,!1),function(t){t.preventDefault(),$cfs.trigger(cf_e("prev",conf))}),opts.prev.pauseOnHover)){var t=bt_pauseOnHoverConfig(opts.prev.pauseOnHover);opts.prev.button.bind(cf_e("mouseenter",conf,!1),function(){$cfs.trigger(cf_e("pause",conf),t)}).bind(cf_e("mouseleave",conf,!1),function(){$cfs.trigger(cf_e("resume",conf))})}if(opts.next.button&&(opts.next.button.bind(cf_e(opts.next.event,conf,!1),function(t){t.preventDefault(),$cfs.trigger(cf_e("next",conf))}),opts.next.pauseOnHover)){var t=bt_pauseOnHoverConfig(opts.next.pauseOnHover);opts.next.button.bind(cf_e("mouseenter",conf,!1),function(){$cfs.trigger(cf_e("pause",conf),t)}).bind(cf_e("mouseleave",conf,!1),function(){$cfs.trigger(cf_e("resume",conf))})}if(opts.pagination.container&&opts.pagination.pauseOnHover){var t=bt_pauseOnHoverConfig(opts.pagination.pauseOnHover);opts.pagination.container.bind(cf_e("mouseenter",conf,!1),function(){$cfs.trigger(cf_e("pause",conf),t)}).bind(cf_e("mouseleave",conf,!1),function(){$cfs.trigger(cf_e("resume",conf))})}if((opts.prev.key||opts.next.key)&&$(document).bind(cf_e("keyup",conf,!1,!0,!0),function(t){var e=t.keyCode;e==opts.next.key&&(t.preventDefault(),$cfs.trigger(cf_e("next",conf))),e==opts.prev.key&&(t.preventDefault(),$cfs.trigger(cf_e("prev",conf)))}),opts.pagination.keys&&$(document).bind(cf_e("keyup",conf,!1,!0,!0),function(t){var e=t.keyCode;e>=49&&58>e&&(e=(e-49)*opts.items.visible,e<=itms.total&&(t.preventDefault(),$cfs.trigger(cf_e("slideTo",conf),[e,0,!0,opts.pagination])))}),$.fn.swipe){var e="ontouchstart"in window;if(e&&opts.swipe.onTouch||!e&&opts.swipe.onMouse){var s=$.extend(!0,{},opts.prev,opts.swipe),i=$.extend(!0,{},opts.next,opts.swipe),o=function(){$cfs.trigger(cf_e("prev",conf),[s])},n=function(){$cfs.trigger(cf_e("next",conf),[i])};switch(opts.direction){case"up":case"down":opts.swipe.options.swipeUp=n,opts.swipe.options.swipeDown=o;break;default:opts.swipe.options.swipeLeft=n,opts.swipe.options.swipeRight=o}crsl.swipe&&$cfs.swipe("destroy"),$wrp.swipe(opts.swipe.options),$wrp.css("cursor","move"),crsl.swipe=!0}}if($.fn.mousewheel&&opts.mousewheel){var r=$.extend(!0,{},opts.prev,opts.mousewheel),c=$.extend(!0,{},opts.next,opts.mousewheel);crsl.mousewheel&&$wrp.unbind(cf_e("mousewheel",conf,!1)),$wrp.bind(cf_e("mousewheel",conf,!1),function(t,e){t.preventDefault(),e>0?$cfs.trigger(cf_e("prev",conf),[r]):$cfs.trigger(cf_e("next",conf),[c])}),crsl.mousewheel=!0}if(opts.auto.play&&$cfs.trigger(cf_e("play",conf),opts.auto.delay),crsl.upDateOnWindowResize){var a=function(){$cfs.trigger(cf_e("finish",conf)),opts.auto.pauseOnResize&&!crsl.isPaused&&$cfs.trigger(cf_e("play",conf)),sz_resetMargin($cfs.children(),opts),$cfs.trigger(cf_e("updateSizes",conf))},f=$(window),l=null;if($.debounce&&"debounce"==conf.onWindowResize)l=$.debounce(200,a);else if($.throttle&&"throttle"==conf.onWindowResize)l=$.throttle(300,a);else{var u=0,p=0;l=function(){var t=f.width(),e=f.height();(t!=u||e!=p)&&(a(),u=t,p=e)}}f.bind(cf_e("resize",conf,!1,!0,!0),l)}},FN._unbind_buttons=function(){var t=(cf_e("",conf),cf_e("",conf,!1));ns3=cf_e("",conf,!1,!0,!0),$(document).unbind(ns3),$(window).unbind(ns3),$wrp.unbind(t),opts.auto.button&&opts.auto.button.unbind(t),opts.prev.button&&opts.prev.button.unbind(t),opts.next.button&&opts.next.button.unbind(t),opts.pagination.container&&(opts.pagination.container.unbind(t),opts.pagination.anchorBuilder&&opts.pagination.container.children().remove()),crsl.swipe&&($cfs.swipe("destroy"),$wrp.css("cursor","default"),crsl.swipe=!1),crsl.mousewheel&&(crsl.mousewheel=!1),nv_showNavi(opts,"hide",conf),nv_enableNavi(opts,"removeClass",conf)},is_boolean(configs)&&(configs={debug:configs});var crsl={direction:"next",isPaused:!0,isScrolling:!1,isStopped:!1,mousewheel:!1,swipe:!1},itms={total:$cfs.children().length,first:0},tmrs={auto:null,progress:null,startTime:getTime(),timePassed:0},scrl={isStopped:!1,duration:0,startTime:0,easing:"",anims:[]},clbk={onBefore:[],onAfter:[]},queu=[],conf=$.extend(!0,{},$.fn.carouFredSel.configs,configs),opts={},opts_orig=$.extend(!0,{},options),$wrp="parent"==conf.wrapper?$cfs.parent():$cfs.wrap("<"+conf.wrapper.element+' class="'+conf.wrapper.classname+'" />').parent();if(conf.selector=$cfs.selector,conf.serialNumber=$.fn.carouFredSel.serialNumber++,conf.transition=conf.transition&&$.fn.transition?"transition":"animate",FN._init(opts_orig,!0,starting_position),FN._build(),FN._bind_events(),FN._bind_buttons(),is_array(opts.items.start))var start_arr=opts.items.start;else{var start_arr=[];0!=opts.items.start&&start_arr.push(opts.items.start)}if(opts.cookie&&start_arr.unshift(parseInt(cf_getCookie(opts.cookie),10)),start_arr.length>0)for(var a=0,l=start_arr.length;l>a;a++){var s=start_arr[a];if(0!=s){if(s===!0){if(s=window.location.hash,s.length<1)continue}else"random"===s&&(s=Math.floor(Math.random()*itms.total));if($cfs.triggerHandler(cf_e("slideTo",conf),[s,0,!0,{fx:"none"}]))break}}var siz=sz_setSizes($cfs,opts),itm=gi_getCurrentItems($cfs.children(),opts);return opts.onCreate&&opts.onCreate.call($tt0,{width:siz.width,height:siz.height,items:itm}),$cfs.trigger(cf_e("updatePageStatus",conf),[!0,siz]),$cfs.trigger(cf_e("linkAnchors",conf)),conf.debug&&$cfs.trigger(cf_e("debug",conf)),$cfs},$.fn.carouFredSel.serialNumber=1,$.fn.carouFredSel.defaults={synchronise:!1,infinite:!0,circular:!0,responsive:!1,direction:"left",items:{start:0},scroll:{easing:"swing",duration:500,pauseOnHover:!1,event:"click",queue:!1}},$.fn.carouFredSel.configs={debug:!1,transition:!1,onWindowResize:"throttle",events:{prefix:"",namespace:"cfs"},wrapper:{element:"div",classname:"caroufredsel_wrapper"},classnames:{}},$.fn.carouFredSel.pageAnchorBuilder=function(t){return'<a href="#"><span>'+t+"</span></a>"},$.fn.carouFredSel.progressbarUpdater=function(t){$(this).css("width",t+"%")},$.fn.carouFredSel.cookie={get:function(t){t+="=";for(var e=document.cookie.split(";"),s=0,i=e.length;i>s;s++){for(var o=e[s];" "==o.charAt(0);)o=o.slice(1);if(0==o.indexOf(t))return o.slice(t.length)}return 0},set:function(t,e,s){var i="";if(s){var o=new Date;o.setTime(o.getTime()+24*s*60*60*1e3),i="; expires="+o.toGMTString()}document.cookie=t+"="+e+i+"; path=/"},remove:function(t){$.fn.carouFredSel.cookie.set(t,"",-1)}},$.extend($.easing,{quadratic:function(t){var e=t*t;return t*(-e*t+4*e-6*t+4)},cubic:function(t){return t*(4*t*t-9*t+6)},elastic:function(t){var e=t*t;return t*(33*e*e-106*e*t+126*e-67*t+15)}}))}(jQuery);


/*!
 * The Final Countdown for jQuery v2.0.4 (http://hilios.github.io/jQuery.countdown/)
 * Copyright (c) 2014 Edson Hilios
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

!function(a){"use strict";"function"==typeof define&&define.amd?define(["jquery"],a):a(jQuery)}(function(a){"use strict";function b(a){if(a instanceof Date)return a;if(String(a).match(g))return String(a).match(/^[0-9]*$/)&&(a=Number(a)),String(a).match(/\-/)&&(a=String(a).replace(/\-/g,"/")),new Date(a);throw new Error("Couldn't cast `"+a+"` to a date object.")}function c(a){return function(b){var c=b.match(/%(-|!)?[A-Z]{1}(:[^;]+;)?/gi);if(c)for(var e=0,f=c.length;f>e;++e){var g=c[e].match(/%(-|!)?([a-zA-Z]{1})(:[^;]+;)?/),i=new RegExp(g[0]),j=g[1]||"",k=g[3]||"",l=null;g=g[2],h.hasOwnProperty(g)&&(l=h[g],l=Number(a[l])),null!==l&&("!"===j&&(l=d(k,l)),""===j&&10>l&&(l="0"+l.toString()),b=b.replace(i,l.toString()))}return b=b.replace(/%%/,"%")}}function d(a,b){var c="s",d="";return a&&(a=a.replace(/(:|;|\s)/gi,"").split(/\,/),1===a.length?c=a[0]:(d=a[0],c=a[1])),1===Math.abs(b)?d:c}var e=100,f=[],g=[];g.push(/^[0-9]*$/.source),g.push(/([0-9]{1,2}\/){2}[0-9]{4}( [0-9]{1,2}(:[0-9]{2}){2})?/.source),g.push(/[0-9]{4}([\/\-][0-9]{1,2}){2}( [0-9]{1,2}(:[0-9]{2}){2})?/.source),g=new RegExp(g.join("|"));var h={Y:"years",m:"months",w:"weeks",d:"days",D:"totalDays",H:"hours",M:"minutes",S:"seconds"},i=function(b,c,d){this.el=b,this.$el=a(b),this.interval=null,this.offset={},this.instanceNumber=f.length,f.push(this),this.$el.data("countdown-instance",this.instanceNumber),d&&(this.$el.on("update.countdown",d),this.$el.on("stoped.countdown",d),this.$el.on("finish.countdown",d)),this.setFinalDate(c),this.start()};a.extend(i.prototype,{start:function(){null!==this.interval&&clearInterval(this.interval);var a=this;this.update(),this.interval=setInterval(function(){a.update.call(a)},e)},stop:function(){clearInterval(this.interval),this.interval=null,this.dispatchEvent("stoped")},pause:function(){this.stop.call(this)},resume:function(){this.start.call(this)},remove:function(){this.stop(),f[this.instanceNumber]=null,delete this.$el.data().countdownInstance},setFinalDate:function(a){this.finalDate=b(a)},update:function(){return 0===this.$el.closest("html").length?void this.remove():(this.totalSecsLeft=this.finalDate.getTime()-(new Date).getTime(),this.totalSecsLeft=Math.ceil(this.totalSecsLeft/1e3),this.totalSecsLeft=this.totalSecsLeft<0?0:this.totalSecsLeft,this.offset={seconds:this.totalSecsLeft%60,minutes:Math.floor(this.totalSecsLeft/60)%60,hours:Math.floor(this.totalSecsLeft/60/60)%24,days:Math.floor(this.totalSecsLeft/60/60/24)%7,totalDays:Math.floor(this.totalSecsLeft/60/60/24),weeks:Math.floor(this.totalSecsLeft/60/60/24/7),months:Math.floor(this.totalSecsLeft/60/60/24/30),years:Math.floor(this.totalSecsLeft/60/60/24/365)},void(0===this.totalSecsLeft?(this.stop(),this.dispatchEvent("finish")):this.dispatchEvent("update")))},dispatchEvent:function(b){var d=a.Event(b+".countdown");d.finalDate=this.finalDate,d.offset=a.extend({},this.offset),d.strftime=c(this.offset),this.$el.trigger(d)}}),a.fn.countdown=function(){var b=Array.prototype.slice.call(arguments,0);return this.each(function(){var c=a(this).data("countdown-instance");if(void 0!==c){var d=f[c],e=b[0];i.prototype.hasOwnProperty(e)?d[e].apply(d,b.slice(1)):null===String(e).match(/^[$A-Z_][0-9A-Z_$]*$/i)?(d.setFinalDate.call(d,e),d.start()):a.error("Method %s does not exist on jQuery.countdown".replace(/\%s/gi,e))}else new i(this,b[0],b[1])})}});


/*!
Waypoints - 3.1.1
Copyright © 2011-2015 Caleb Troughton
Licensed under the MIT license.
https://github.com/imakewebthings/waypoints/blog/master/licenses.txt
*/
!function(){"use strict";function t(o){if(!o)throw new Error("No options passed to Waypoint constructor");if(!o.element)throw new Error("No element option passed to Waypoint constructor");if(!o.handler)throw new Error("No handler option passed to Waypoint constructor");this.key="waypoint-"+e,this.options=t.Adapter.extend({},t.defaults,o),this.element=this.options.element,this.adapter=new t.Adapter(this.element),this.callback=o.handler,this.axis=this.options.horizontal?"horizontal":"vertical",this.enabled=this.options.enabled,this.triggerPoint=null,this.group=t.Group.findOrCreate({name:this.options.group,axis:this.axis}),this.context=t.Context.findOrCreateByElement(this.options.context),t.offsetAliases[this.options.offset]&&(this.options.offset=t.offsetAliases[this.options.offset]),this.group.add(this),this.context.add(this),i[this.key]=this,e+=1}var e=0,i={};t.prototype.queueTrigger=function(t){this.group.queueTrigger(this,t)},t.prototype.trigger=function(t){this.enabled&&this.callback&&this.callback.apply(this,t)},t.prototype.destroy=function(){this.context.remove(this),this.group.remove(this),delete i[this.key]},t.prototype.disable=function(){return this.enabled=!1,this},t.prototype.enable=function(){return this.context.refresh(),this.enabled=!0,this},t.prototype.next=function(){return this.group.next(this)},t.prototype.previous=function(){return this.group.previous(this)},t.invokeAll=function(t){var e=[];for(var o in i)e.push(i[o]);for(var n=0,r=e.length;r>n;n++)e[n][t]()},t.destroyAll=function(){t.invokeAll("destroy")},t.disableAll=function(){t.invokeAll("disable")},t.enableAll=function(){t.invokeAll("enable")},t.refreshAll=function(){t.Context.refreshAll()},t.viewportHeight=function(){return window.innerHeight||document.documentElement.clientHeight},t.viewportWidth=function(){return document.documentElement.clientWidth},t.adapters=[],t.defaults={context:window,continuous:!0,enabled:!0,group:"default",horizontal:!1,offset:0},t.offsetAliases={"bottom-in-view":function(){return this.context.innerHeight()-this.adapter.outerHeight()},"right-in-view":function(){return this.context.innerWidth()-this.adapter.outerWidth()}},window.Waypoint=t}(),function(){"use strict";function t(t){window.setTimeout(t,1e3/60)}function e(t){this.element=t,this.Adapter=n.Adapter,this.adapter=new this.Adapter(t),this.key="waypoint-context-"+i,this.didScroll=!1,this.didResize=!1,this.oldScroll={x:this.adapter.scrollLeft(),y:this.adapter.scrollTop()},this.waypoints={vertical:{},horizontal:{}},t.waypointContextKey=this.key,o[t.waypointContextKey]=this,i+=1,this.createThrottledScrollHandler(),this.createThrottledResizeHandler()}var i=0,o={},n=window.Waypoint,r=window.onload;e.prototype.add=function(t){var e=t.options.horizontal?"horizontal":"vertical";this.waypoints[e][t.key]=t,this.refresh()},e.prototype.checkEmpty=function(){var t=this.Adapter.isEmptyObject(this.waypoints.horizontal),e=this.Adapter.isEmptyObject(this.waypoints.vertical);t&&e&&(this.adapter.off(".waypoints"),delete o[this.key])},e.prototype.createThrottledResizeHandler=function(){function t(){e.handleResize(),e.didResize=!1}var e=this;this.adapter.on("resize.waypoints",function(){e.didResize||(e.didResize=!0,n.requestAnimationFrame(t))})},e.prototype.createThrottledScrollHandler=function(){function t(){e.handleScroll(),e.didScroll=!1}var e=this;this.adapter.on("scroll.waypoints",function(){(!e.didScroll||n.isTouch)&&(e.didScroll=!0,n.requestAnimationFrame(t))})},e.prototype.handleResize=function(){n.Context.refreshAll()},e.prototype.handleScroll=function(){var t={},e={horizontal:{newScroll:this.adapter.scrollLeft(),oldScroll:this.oldScroll.x,forward:"right",backward:"left"},vertical:{newScroll:this.adapter.scrollTop(),oldScroll:this.oldScroll.y,forward:"down",backward:"up"}};for(var i in e){var o=e[i],n=o.newScroll>o.oldScroll,r=n?o.forward:o.backward;for(var s in this.waypoints[i]){var a=this.waypoints[i][s],l=o.oldScroll<a.triggerPoint,h=o.newScroll>=a.triggerPoint,p=l&&h,u=!l&&!h;(p||u)&&(a.queueTrigger(r),t[a.group.id]=a.group)}}for(var c in t)t[c].flushTriggers();this.oldScroll={x:e.horizontal.newScroll,y:e.vertical.newScroll}},e.prototype.innerHeight=function(){return this.element==this.element.window?n.viewportHeight():this.adapter.innerHeight()},e.prototype.remove=function(t){delete this.waypoints[t.axis][t.key],this.checkEmpty()},e.prototype.innerWidth=function(){return this.element==this.element.window?n.viewportWidth():this.adapter.innerWidth()},e.prototype.destroy=function(){var t=[];for(var e in this.waypoints)for(var i in this.waypoints[e])t.push(this.waypoints[e][i]);for(var o=0,n=t.length;n>o;o++)t[o].destroy()},e.prototype.refresh=function(){var t,e=this.element==this.element.window,i=this.adapter.offset(),o={};this.handleScroll(),t={horizontal:{contextOffset:e?0:i.left,contextScroll:e?0:this.oldScroll.x,contextDimension:this.innerWidth(),oldScroll:this.oldScroll.x,forward:"right",backward:"left",offsetProp:"left"},vertical:{contextOffset:e?0:i.top,contextScroll:e?0:this.oldScroll.y,contextDimension:this.innerHeight(),oldScroll:this.oldScroll.y,forward:"down",backward:"up",offsetProp:"top"}};for(var n in t){var r=t[n];for(var s in this.waypoints[n]){var a,l,h,p,u,c=this.waypoints[n][s],d=c.options.offset,f=c.triggerPoint,w=0,y=null==f;c.element!==c.element.window&&(w=c.adapter.offset()[r.offsetProp]),"function"==typeof d?d=d.apply(c):"string"==typeof d&&(d=parseFloat(d),c.options.offset.indexOf("%")>-1&&(d=Math.ceil(r.contextDimension*d/100))),a=r.contextScroll-r.contextOffset,c.triggerPoint=w+a-d,l=f<r.oldScroll,h=c.triggerPoint>=r.oldScroll,p=l&&h,u=!l&&!h,!y&&p?(c.queueTrigger(r.backward),o[c.group.id]=c.group):!y&&u?(c.queueTrigger(r.forward),o[c.group.id]=c.group):y&&r.oldScroll>=c.triggerPoint&&(c.queueTrigger(r.forward),o[c.group.id]=c.group)}}for(var g in o)o[g].flushTriggers();return this},e.findOrCreateByElement=function(t){return e.findByElement(t)||new e(t)},e.refreshAll=function(){for(var t in o)o[t].refresh()},e.findByElement=function(t){return o[t.waypointContextKey]},window.onload=function(){r&&r(),e.refreshAll()},n.requestAnimationFrame=function(e){var i=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||t;i.call(window,e)},n.Context=e}(),function(){"use strict";function t(t,e){return t.triggerPoint-e.triggerPoint}function e(t,e){return e.triggerPoint-t.triggerPoint}function i(t){this.name=t.name,this.axis=t.axis,this.id=this.name+"-"+this.axis,this.waypoints=[],this.clearTriggerQueues(),o[this.axis][this.name]=this}var o={vertical:{},horizontal:{}},n=window.Waypoint;i.prototype.add=function(t){this.waypoints.push(t)},i.prototype.clearTriggerQueues=function(){this.triggerQueues={up:[],down:[],left:[],right:[]}},i.prototype.flushTriggers=function(){for(var i in this.triggerQueues){var o=this.triggerQueues[i],n="up"===i||"left"===i;o.sort(n?e:t);for(var r=0,s=o.length;s>r;r+=1){var a=o[r];(a.options.continuous||r===o.length-1)&&a.trigger([i])}}this.clearTriggerQueues()},i.prototype.next=function(e){this.waypoints.sort(t);var i=n.Adapter.inArray(e,this.waypoints),o=i===this.waypoints.length-1;return o?null:this.waypoints[i+1]},i.prototype.previous=function(e){this.waypoints.sort(t);var i=n.Adapter.inArray(e,this.waypoints);return i?this.waypoints[i-1]:null},i.prototype.queueTrigger=function(t,e){this.triggerQueues[e].push(t)},i.prototype.remove=function(t){var e=n.Adapter.inArray(t,this.waypoints);e>-1&&this.waypoints.splice(e,1)},i.prototype.first=function(){return this.waypoints[0]},i.prototype.last=function(){return this.waypoints[this.waypoints.length-1]},i.findOrCreate=function(t){return o[t.axis][t.name]||new i(t)},n.Group=i}(),function(){"use strict";function t(t){this.$element=e(t)}var e=window.jQuery,i=window.Waypoint;e.each(["innerHeight","innerWidth","off","offset","on","outerHeight","outerWidth","scrollLeft","scrollTop"],function(e,i){t.prototype[i]=function(){var t=Array.prototype.slice.call(arguments);return this.$element[i].apply(this.$element,t)}}),e.each(["extend","inArray","isEmptyObject"],function(i,o){t[o]=e[o]}),i.adapters.push({name:"jquery",Adapter:t}),i.Adapter=t}(),function(){"use strict";function t(t){return function(){var i=[],o=arguments[0];return t.isFunction(arguments[0])&&(o=t.extend({},arguments[1]),o.handler=arguments[0]),this.each(function(){var n=t.extend({},o,{element:this});"string"==typeof n.context&&(n.context=t(this).closest(n.context)[0]),i.push(new e(n))}),i}}var e=window.Waypoint;window.jQuery&&(window.jQuery.fn.waypoint=t(window.jQuery)),window.Zepto&&(window.Zepto.fn.waypoint=t(window.Zepto))}();


/*!jQuery Knob*/
/**
 * Downward compatible, touchable dial
 *
 * Version: 1.2.11
 * Requires: jQuery v1.7+
 *
 * Copyright (c) 2012 Anthony Terrien
 * Under MIT License (http://www.opensource.org/licenses/mit-license.php)
 *
 * Thanks to vor, eskimoblood, spiffistan, FabrizioC
 */

(function(e){if(typeof define==="function"&&define.amd){define(["jquery"],e)}else{e(jQuery)}})(function(e){"use strict";var t={},n=Math.max,r=Math.min;t.c={};t.c.d=e(document);t.c.t=function(e){return e.originalEvent.touches.length-1};t.o=function(){var n=this;this.o=null;this.$=null;this.i=null;this.g=null;this.v=null;this.cv=null;this.x=0;this.y=0;this.w=0;this.h=0;this.$c=null;this.c=null;this.t=0;this.isInit=false;this.fgColor=null;this.pColor=null;this.dH=null;this.cH=null;this.eH=null;this.rH=null;this.scale=1;this.relative=false;this.relativeWidth=false;this.relativeHeight=false;this.$div=null;this.run=function(){var t=function(e,t){var r;for(r in t){n.o[r]=t[r]}n._carve().init();n._configure()._draw()};if(this.$.data("kontroled"))return;this.$.data("kontroled",true);this.extend();this.o=e.extend({min:this.$.data("min")!==undefined?this.$.data("min"):0,max:this.$.data("max")!==undefined?this.$.data("max"):100,stopper:true,readOnly:this.$.data("readonly")||this.$.attr("readonly")==="readonly",cursor:this.$.data("cursor")===true&&30||this.$.data("cursor")||0,thickness:this.$.data("thickness")&&Math.max(Math.min(this.$.data("thickness"),1),.01)||.35,lineCap:this.$.data("linecap")||"butt",width:this.$.data("width")||200,height:this.$.data("height")||200,displayInput:this.$.data("displayinput")==null||this.$.data("displayinput"),displayPrevious:this.$.data("displayprevious"),fgColor:this.$.data("fgcolor")||"#87CEEB",inputColor:this.$.data("inputcolor"),font:this.$.data("font")||"Arial",fontWeight:this.$.data("font-weight")||"bold",inline:false,step:this.$.data("step")||1,rotation:this.$.data("rotation"),draw:null,change:null,cancel:null,release:null,format:function(e){return e},parse:function(e){return parseFloat(e)}},this.o);this.o.flip=this.o.rotation==="anticlockwise"||this.o.rotation==="acw";if(!this.o.inputColor){this.o.inputColor=this.o.fgColor}if(this.$.is("fieldset")){this.v={};this.i=this.$.find("input");this.i.each(function(t){var r=e(this);n.i[t]=r;n.v[t]=n.o.parse(r.val());r.bind("change blur",function(){var e={};e[t]=r.val();n.val(n._validate(e))})});this.$.find("legend").remove()}else{this.i=this.$;this.v=this.o.parse(this.$.val());this.v===""&&(this.v=this.o.min);this.$.bind("change blur",function(){n.val(n._validate(n.o.parse(n.$.val())))})}!this.o.displayInput&&this.$.hide();this.$c=e(document.createElement("canvas")).attr({width:this.o.width,height:this.o.height});this.$div=e('<div style="'+(this.o.inline?"display:inline;":"")+"width:"+this.o.width+"px;height:"+this.o.height+"px;"+'"></div>');this.$.wrap(this.$div).before(this.$c);this.$div=this.$.parent();if(typeof G_vmlCanvasManager!=="undefined"){G_vmlCanvasManager.initElement(this.$c[0])}this.c=this.$c[0].getContext?this.$c[0].getContext("2d"):null;if(!this.c){throw{name:"CanvasNotSupportedException",message:"Canvas not supported. Please use excanvas on IE8.0.",toString:function(){return this.name+": "+this.message}}}this.scale=(window.devicePixelRatio||1)/(this.c.webkitBackingStorePixelRatio||this.c.mozBackingStorePixelRatio||this.c.msBackingStorePixelRatio||this.c.oBackingStorePixelRatio||this.c.backingStorePixelRatio||1);this.relativeWidth=this.o.width%1!==0&&this.o.width.indexOf("%");this.relativeHeight=this.o.height%1!==0&&this.o.height.indexOf("%");this.relative=this.relativeWidth||this.relativeHeight;this._carve();if(this.v instanceof Object){this.cv={};this.copy(this.v,this.cv)}else{this.cv=this.v}this.$.bind("configure",t).parent().bind("configure",t);this._listen()._configure()._xy().init();this.isInit=true;this.$.val(this.o.format(this.v));this._draw();return this};this._carve=function(){if(this.relative){var e=this.relativeWidth?this.$div.parent().width()*parseInt(this.o.width)/100:this.$div.parent().width(),t=this.relativeHeight?this.$div.parent().height()*parseInt(this.o.height)/100:this.$div.parent().height();this.w=this.h=Math.min(e,t)}else{this.w=this.o.width;this.h=this.o.height}this.$div.css({width:this.w+"px",height:this.h+"px"});this.$c.attr({width:this.w,height:this.h});if(this.scale!==1){this.$c[0].width=this.$c[0].width*this.scale;this.$c[0].height=this.$c[0].height*this.scale;this.$c.width(this.w);this.$c.height(this.h)}return this};this._draw=function(){var e=true;n.g=n.c;n.clear();n.dH&&(e=n.dH());e!==false&&n.draw()};this._touch=function(e){var r=function(e){var t=n.xy2val(e.originalEvent.touches[n.t].pageX,e.originalEvent.touches[n.t].pageY);if(t==n.cv)return;if(n.cH&&n.cH(t)===false)return;n.change(n._validate(t));n._draw()};this.t=t.c.t(e);r(e);t.c.d.bind("touchmove.k",r).bind("touchend.k",function(){t.c.d.unbind("touchmove.k touchend.k");n.val(n.cv)});return this};this._mouse=function(e){var r=function(e){var t=n.xy2val(e.pageX,e.pageY);if(t==n.cv)return;if(n.cH&&n.cH(t)===false)return;n.change(n._validate(t));n._draw()};r(e);t.c.d.bind("mousemove.k",r).bind("keyup.k",function(e){if(e.keyCode===27){t.c.d.unbind("mouseup.k mousemove.k keyup.k");if(n.eH&&n.eH()===false)return;n.cancel()}}).bind("mouseup.k",function(e){t.c.d.unbind("mousemove.k mouseup.k keyup.k");n.val(n.cv)});return this};this._xy=function(){var e=this.$c.offset();this.x=e.left;this.y=e.top;return this};this._listen=function(){if(!this.o.readOnly){this.$c.bind("mousedown",function(e){e.preventDefault();n._xy()._mouse(e)}).bind("touchstart",function(e){e.preventDefault();n._xy()._touch(e)});this.listen()}else{this.$.attr("readonly","readonly")}if(this.relative){e(window).resize(function(){n._carve().init();n._draw()})}return this};this._configure=function(){if(this.o.draw)this.dH=this.o.draw;if(this.o.change)this.cH=this.o.change;if(this.o.cancel)this.eH=this.o.cancel;if(this.o.release)this.rH=this.o.release;if(this.o.displayPrevious){this.pColor=this.h2rgba(this.o.fgColor,"0.4");this.fgColor=this.h2rgba(this.o.fgColor,"0.6")}else{this.fgColor=this.o.fgColor}return this};this._clear=function(){this.$c[0].width=this.$c[0].width};this._validate=function(e){var t=~~((e<0?-.5:.5)+e/this.o.step)*this.o.step;return Math.round(t*100)/100};this.listen=function(){};this.extend=function(){};this.init=function(){};this.change=function(e){};this.val=function(e){};this.xy2val=function(e,t){};this.draw=function(){};this.clear=function(){this._clear()};this.h2rgba=function(e,t){var n;e=e.substring(1,7);n=[parseInt(e.substring(0,2),16),parseInt(e.substring(2,4),16),parseInt(e.substring(4,6),16)];return"rgba("+n[0]+","+n[1]+","+n[2]+","+t+")"};this.copy=function(e,t){for(var n in e){t[n]=e[n]}}};t.Dial=function(){t.o.call(this);this.startAngle=null;this.xy=null;this.radius=null;this.lineWidth=null;this.cursorExt=null;this.w2=null;this.PI2=2*Math.PI;this.extend=function(){this.o=e.extend({bgColor:this.$.data("bgcolor")||"#EEEEEE",angleOffset:this.$.data("angleoffset")||0,angleArc:this.$.data("anglearc")||360,inline:true},this.o)};this.val=function(e,t){if(null!=e){e=this.o.parse(e);if(t!==false&&e!=this.v&&this.rH&&this.rH(e)===false){return}this.cv=this.o.stopper?n(r(e,this.o.max),this.o.min):e;this.v=this.cv;this.$.val(this.o.format(this.v));this._draw()}else{return this.v}};this.xy2val=function(e,t){var i,s;i=Math.atan2(e-(this.x+this.w2),-(t-this.y-this.w2))-this.angleOffset;if(this.o.flip){i=this.angleArc-i-this.PI2}if(this.angleArc!=this.PI2&&i<0&&i>-.5){i=0}else if(i<0){i+=this.PI2}s=i*(this.o.max-this.o.min)/this.angleArc+this.o.min;this.o.stopper&&(s=n(r(s,this.o.max),this.o.min));return s};this.listen=function(){var t=this,i,s,o=function(e){e.preventDefault();var o=e.originalEvent,u=o.detail||o.wheelDeltaX,a=o.detail||o.wheelDeltaY,f=t._validate(t.o.parse(t.$.val()))+(u>0||a>0?t.o.step:u<0||a<0?-t.o.step:0);f=n(r(f,t.o.max),t.o.min);t.val(f,false);if(t.rH){clearTimeout(i);i=setTimeout(function(){t.rH(f);i=null},100);if(!s){s=setTimeout(function(){if(i)t.rH(f);s=null},200)}}},u,a,f=1,l={37:-t.o.step,38:t.o.step,39:t.o.step,40:-t.o.step};this.$.bind("keydown",function(i){var s=i.keyCode;if(s>=96&&s<=105){s=i.keyCode=s-48}u=parseInt(String.fromCharCode(s));if(isNaN(u)){s!==13&&s!==8&&s!==9&&s!==189&&(s!==190||t.$.val().match(/\./))&&i.preventDefault();if(e.inArray(s,[37,38,39,40])>-1){i.preventDefault();var o=t.o.parse(t.$.val())+l[s]*f;t.o.stopper&&(o=n(r(o,t.o.max),t.o.min));t.change(t._validate(o));t._draw();a=window.setTimeout(function(){f*=2},30)}}}).bind("keyup",function(e){if(isNaN(u)){if(a){window.clearTimeout(a);a=null;f=1;t.val(t.$.val())}}else{t.$.val()>t.o.max&&t.$.val(t.o.max)||t.$.val()<t.o.min&&t.$.val(t.o.min)}});this.$c.bind("mousewheel DOMMouseScroll",o);this.$.bind("mousewheel DOMMouseScroll",o)};this.init=function(){if(this.v<this.o.min||this.v>this.o.max){this.v=this.o.min}this.$.val(this.v);this.w2=this.w/2;this.cursorExt=this.o.cursor/100;this.xy=this.w2*this.scale;this.lineWidth=this.xy*this.o.thickness;this.lineCap=this.o.lineCap;this.radius=this.xy-this.lineWidth/2;this.o.angleOffset&&(this.o.angleOffset=isNaN(this.o.angleOffset)?0:this.o.angleOffset);this.o.angleArc&&(this.o.angleArc=isNaN(this.o.angleArc)?this.PI2:this.o.angleArc);this.angleOffset=this.o.angleOffset*Math.PI/180;this.angleArc=this.o.angleArc*Math.PI/180;this.startAngle=1.5*Math.PI+this.angleOffset;this.endAngle=1.5*Math.PI+this.angleOffset+this.angleArc;var e=n(String(Math.abs(this.o.max)).length,String(Math.abs(this.o.min)).length,2)+2;this.o.displayInput&&this.i.css({width:(this.w/2+4>>0)+"px",height:(this.w/3>>0)+"px",position:"absolute","vertical-align":"middle","margin-top":(this.w/3>>0)+"px","margin-left":"-"+(this.w*3/4+2>>0)+"px",border:0,background:"none",font:this.o.fontWeight+" "+(this.w/e>>0)+"px "+this.o.font,"text-align":"center",color:this.o.inputColor||this.o.fgColor,padding:"0px","-webkit-appearance":"none"})||this.i.css({width:"0px",visibility:"hidden"})};this.change=function(e){this.cv=e;this.$.val(this.o.format(e))};this.angle=function(e){return(e-this.o.min)*this.angleArc/(this.o.max-this.o.min)};this.arc=function(e){var t,n;e=this.angle(e);if(this.o.flip){t=this.endAngle+1e-5;n=t-e-1e-5}else{t=this.startAngle-1e-5;n=t+e+1e-5}this.o.cursor&&(t=n-this.cursorExt)&&(n=n+this.cursorExt);return{s:t,e:n,d:this.o.flip&&!this.o.cursor}};this.draw=function(){var e=this.g,t=this.arc(this.cv),n,r=1;e.lineWidth=this.lineWidth;e.lineCap=this.lineCap;if(this.o.bgColor!=="none"){e.beginPath();e.strokeStyle=this.o.bgColor;e.arc(this.xy,this.xy,this.radius,this.endAngle-1e-5,this.startAngle+1e-5,true);e.stroke()}if(this.o.displayPrevious){n=this.arc(this.v);e.beginPath();e.strokeStyle=this.pColor;e.arc(this.xy,this.xy,this.radius,n.s,n.e,n.d);e.stroke();r=this.cv==this.v}e.beginPath();e.strokeStyle=r?this.o.fgColor:this.fgColor;e.arc(this.xy,this.xy,this.radius,t.s,t.e,t.d);e.stroke()};this.cancel=function(){this.val(this.v)}};e.fn.dial=e.fn.knob=function(n){return this.each(function(){var r=new t.Dial;r.o=n;r.$=e(this);r.run()}).parent()}})


/*
 * jQuery Nivo Slider v3.2
 * http://nivo.dev7studios.com
 *
 * Copyright 2012, Dev7studios
 * Free to use and abuse under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 */

!function(i){var t=function(t,e){var n=i.extend({},i.fn.nivoSlider.defaults,e),a={currentSlide:0,currentImage:"",totalSlides:0,running:!1,paused:!1,stop:!1,controlNavEl:!1},o=i(t);o.data("nivo:vars",a).addClass("nivoSlider");var r=o.children();r.each(function(){var t=i(this),e="";t.is("img")||(t.is("a")&&(t.addClass("nivo-imageLink"),e=t),t=t.find("img:first"));var n=0===n?t.attr("width"):t.width(),o=0===o?t.attr("height"):t.height();""!==e&&e.css("display","none"),t.css("display","none"),a.totalSlides++}),n.randomStart&&(n.startSlide=Math.floor(Math.random()*a.totalSlides)),n.startSlide>0&&(n.startSlide>=a.totalSlides&&(n.startSlide=a.totalSlides-1),a.currentSlide=n.startSlide),a.currentImage=i(r[a.currentSlide]).is("img")?i(r[a.currentSlide]):i(r[a.currentSlide]).find("img:first"),i(r[a.currentSlide]).is("a")&&i(r[a.currentSlide]).css("display","block");var s=i("<img/>").addClass("nivo-main-image");s.attr("src",a.currentImage.attr("src")).show(),o.append(s),i(window).resize(function(){o.children("img").width(o.width()),s.attr("src",a.currentImage.attr("src")),s.stop().height("auto"),i(".nivo-slice").remove(),i(".nivo-box").remove()}),o.append(i('<div class="nivo-caption"></div>'));var c=function(t){var e=i(".nivo-caption",o);if(""!=a.currentImage.attr("title")&&void 0!=a.currentImage.attr("title")){var n=a.currentImage.attr("title");"#"==n.substr(0,1)&&(n=i(n).html()),"block"==e.css("display")?setTimeout(function(){e.html(n)},t.animSpeed):(e.html(n),e.stop().fadeIn(t.animSpeed))}else e.stop().fadeOut(t.animSpeed)};c(n);var l=0;if(!n.manualAdvance&&r.length>1&&(l=setInterval(function(){u(o,r,n,!1)},n.pauseTime)),n.directionNav&&(o.append('<div class="nivo-directionNav"><a class="nivo-prevNav">'+n.prevText+'</a><a class="nivo-nextNav">'+n.nextText+"</a></div>"),i(o).on("click","a.nivo-prevNav",function(){return a.running?!1:(clearInterval(l),l="",a.currentSlide-=2,void u(o,r,n,"prev"))}),i(o).on("click","a.nivo-nextNav",function(){return a.running?!1:(clearInterval(l),l="",void u(o,r,n,"next"))})),n.controlNav){a.controlNavEl=i('<div class="nivo-controlNav"></div>'),o.after(a.controlNavEl);for(var d=0;d<r.length;d++)if(n.controlNavThumbs){a.controlNavEl.addClass("nivo-thumbs-enabled");var v=r.eq(d);v.is("img")||(v=v.find("img:first")),v.attr("data-thumb")&&a.controlNavEl.append('<a class="nivo-control" rel="'+d+'"><img src="'+v.attr("data-thumb")+'" alt="" /></a>')}else a.controlNavEl.append('<a class="nivo-control" rel="'+d+'">'+(d+1)+"</a>");i("a:eq("+a.currentSlide+")",a.controlNavEl).addClass("active"),i("a",a.controlNavEl).bind("click",function(){return a.running?!1:i(this).hasClass("active")?!1:(clearInterval(l),l="",s.attr("src",a.currentImage.attr("src")),a.currentSlide=i(this).attr("rel")-1,void u(o,r,n,"control"))})}n.pauseOnHover&&o.hover(function(){a.paused=!0,clearInterval(l),l=""},function(){a.paused=!1,""!==l||n.manualAdvance||(l=setInterval(function(){u(o,r,n,!1)},n.pauseTime))}),o.bind("nivo:animFinished",function(){s.attr("src",a.currentImage.attr("src")),a.running=!1,i(r).each(function(){i(this).is("a")&&i(this).css("display","none")}),i(r[a.currentSlide]).is("a")&&i(r[a.currentSlide]).css("display","block"),""!==l||a.paused||n.manualAdvance||(l=setInterval(function(){u(o,r,n,!1)},n.pauseTime)),n.afterChange.call(this)});var h=function(t,e,n){i(n.currentImage).parent().is("a")&&i(n.currentImage).parent().css("display","block"),i('img[src="'+n.currentImage.attr("src")+'"]',t).not(".nivo-main-image,.nivo-control img").width(t.width()).css("visibility","hidden").show();for(var a=i('img[src="'+n.currentImage.attr("src")+'"]',t).not(".nivo-main-image,.nivo-control img").parent().is("a")?i('img[src="'+n.currentImage.attr("src")+'"]',t).not(".nivo-main-image,.nivo-control img").parent().height():i('img[src="'+n.currentImage.attr("src")+'"]',t).not(".nivo-main-image,.nivo-control img").height(),o=0;o<e.slices;o++){var r=Math.round(t.width()/e.slices);t.append(o===e.slices-1?i('<div class="nivo-slice" name="'+o+'"><img src="'+n.currentImage.attr("src")+'" style="position:absolute; width:'+t.width()+"px; height:auto; display:block !important; top:0; left:-"+(r+o*r-r)+'px;" /></div>').css({left:r*o+"px",width:t.width()-r*o+"px",height:a+"px",opacity:"0",overflow:"hidden"}):i('<div class="nivo-slice" name="'+o+'"><img src="'+n.currentImage.attr("src")+'" style="position:absolute; width:'+t.width()+"px; height:auto; display:block !important; top:0; left:-"+(r+o*r-r)+'px;" /></div>').css({left:r*o+"px",width:r+"px",height:a+"px",opacity:"0",overflow:"hidden"}))}i(".nivo-slice",t).height(a),s.stop().animate({height:i(n.currentImage).height()},e.animSpeed)},m=function(t,e,n){i(n.currentImage).parent().is("a")&&i(n.currentImage).parent().css("display","block"),i('img[src="'+n.currentImage.attr("src")+'"]',t).not(".nivo-main-image,.nivo-control img").width(t.width()).css("visibility","hidden").show();for(var a=Math.round(t.width()/e.boxCols),o=Math.round(i('img[src="'+n.currentImage.attr("src")+'"]',t).not(".nivo-main-image,.nivo-control img").height()/e.boxRows),r=0;r<e.boxRows;r++)for(var c=0;c<e.boxCols;c++)c===e.boxCols-1?(t.append(i('<div class="nivo-box" name="'+c+'" rel="'+r+'"><img src="'+n.currentImage.attr("src")+'" style="position:absolute; width:'+t.width()+"px; height:auto; display:block; top:-"+o*r+"px; left:-"+a*c+'px;" /></div>').css({opacity:0,left:a*c+"px",top:o*r+"px",width:t.width()-a*c+"px"})),i('.nivo-box[name="'+c+'"]',t).height(i('.nivo-box[name="'+c+'"] img',t).height()+"px")):(t.append(i('<div class="nivo-box" name="'+c+'" rel="'+r+'"><img src="'+n.currentImage.attr("src")+'" style="position:absolute; width:'+t.width()+"px; height:auto; display:block; top:-"+o*r+"px; left:-"+a*c+'px;" /></div>').css({opacity:0,left:a*c+"px",top:o*r+"px",width:a+"px"})),i('.nivo-box[name="'+c+'"]',t).height(i('.nivo-box[name="'+c+'"] img',t).height()+"px"));s.stop().animate({height:i(n.currentImage).height()},e.animSpeed)},u=function(t,e,n,a){var o=t.data("nivo:vars");if(o&&o.currentSlide===o.totalSlides-1&&n.lastSlide.call(this),(!o||o.stop)&&!a)return!1;n.beforeChange.call(this),a?("prev"===a&&s.attr("src",o.currentImage.attr("src")),"next"===a&&s.attr("src",o.currentImage.attr("src"))):s.attr("src",o.currentImage.attr("src")),o.currentSlide++,o.currentSlide===o.totalSlides&&(o.currentSlide=0,n.slideshowEnd.call(this)),o.currentSlide<0&&(o.currentSlide=o.totalSlides-1),o.currentImage=i(e[o.currentSlide]).is("img")?i(e[o.currentSlide]):i(e[o.currentSlide]).find("img:first"),n.controlNav&&(i("a",o.controlNavEl).removeClass("active"),i("a:eq("+o.currentSlide+")",o.controlNavEl).addClass("active")),c(n),i(".nivo-slice",t).remove(),i(".nivo-box",t).remove();var r=n.effect,l="";"random"===n.effect&&(l=new Array("sliceDownRight","sliceDownLeft","sliceUpRight","sliceUpLeft","sliceUpDown","sliceUpDownLeft","fold","fade","boxRandom","boxRain","boxRainReverse","boxRainGrow","boxRainGrowReverse"),r=l[Math.floor(Math.random()*(l.length+1))],void 0===r&&(r="fade")),-1!==n.effect.indexOf(",")&&(l=n.effect.split(","),r=l[Math.floor(Math.random()*l.length)],void 0===r&&(r="fade")),o.currentImage.attr("data-transition")&&(r=o.currentImage.attr("data-transition")),o.running=!0;var d=0,v=0,u="",f="",g="",x="";if("sliceDown"===r||"sliceDownRight"===r||"sliceDownLeft"===r)h(t,n,o),d=0,v=0,u=i(".nivo-slice",t),"sliceDownLeft"===r&&(u=i(".nivo-slice",t)._reverse()),u.each(function(){var e=i(this);e.css({top:"0px"}),v===n.slices-1?setTimeout(function(){e.animate({opacity:"1.0"},n.animSpeed,"",function(){t.trigger("nivo:animFinished")})},100+d):setTimeout(function(){e.animate({opacity:"1.0"},n.animSpeed)},100+d),d+=50,v++});else if("sliceUp"===r||"sliceUpRight"===r||"sliceUpLeft"===r)h(t,n,o),d=0,v=0,u=i(".nivo-slice",t),"sliceUpLeft"===r&&(u=i(".nivo-slice",t)._reverse()),u.each(function(){var e=i(this);e.css({bottom:"0px"}),v===n.slices-1?setTimeout(function(){e.animate({opacity:"1.0"},n.animSpeed,"",function(){t.trigger("nivo:animFinished")})},100+d):setTimeout(function(){e.animate({opacity:"1.0"},n.animSpeed)},100+d),d+=50,v++});else if("sliceUpDown"===r||"sliceUpDownRight"===r||"sliceUpDownLeft"===r){h(t,n,o),d=0,v=0;var w=0;u=i(".nivo-slice",t),"sliceUpDownLeft"===r&&(u=i(".nivo-slice",t)._reverse()),u.each(function(){var e=i(this);0===v?(e.css("top","0px"),v++):(e.css("bottom","0px"),v=0),w===n.slices-1?setTimeout(function(){e.animate({opacity:"1.0"},n.animSpeed,"",function(){t.trigger("nivo:animFinished")})},100+d):setTimeout(function(){e.animate({opacity:"1.0"},n.animSpeed)},100+d),d+=50,w++})}else if("fold"===r)h(t,n,o),d=0,v=0,i(".nivo-slice",t).each(function(){var e=i(this),a=e.width();e.css({top:"0px",width:"0px"}),v===n.slices-1?setTimeout(function(){e.animate({width:a,opacity:"1.0"},n.animSpeed,"",function(){t.trigger("nivo:animFinished")})},100+d):setTimeout(function(){e.animate({width:a,opacity:"1.0"},n.animSpeed)},100+d),d+=50,v++});else if("fade"===r)h(t,n,o),f=i(".nivo-slice:first",t),f.css({width:t.width()+"px"}),f.animate({opacity:"1.0"},2*n.animSpeed,"",function(){t.trigger("nivo:animFinished")});else if("slideInRight"===r)h(t,n,o),f=i(".nivo-slice:first",t),f.css({width:"0px",opacity:"1"}),f.animate({width:t.width()+"px"},2*n.animSpeed,"",function(){t.trigger("nivo:animFinished")});else if("slideInLeft"===r)h(t,n,o),f=i(".nivo-slice:first",t),f.css({width:"0px",opacity:"1",left:"",right:"0px"}),f.animate({width:t.width()+"px"},2*n.animSpeed,"",function(){f.css({left:"0px",right:""}),t.trigger("nivo:animFinished")});else if("boxRandom"===r)m(t,n,o),g=n.boxCols*n.boxRows,v=0,d=0,x=p(i(".nivo-box",t)),x.each(function(){var e=i(this);v===g-1?setTimeout(function(){e.animate({opacity:"1"},n.animSpeed,"",function(){t.trigger("nivo:animFinished")})},100+d):setTimeout(function(){e.animate({opacity:"1"},n.animSpeed)},100+d),d+=20,v++});else if("boxRain"===r||"boxRainReverse"===r||"boxRainGrow"===r||"boxRainGrowReverse"===r){m(t,n,o),g=n.boxCols*n.boxRows,v=0,d=0;var S=0,b=0,I=[];I[S]=[],x=i(".nivo-box",t),("boxRainReverse"===r||"boxRainGrowReverse"===r)&&(x=i(".nivo-box",t)._reverse()),x.each(function(){I[S][b]=i(this),b++,b===n.boxCols&&(S++,b=0,I[S]=[])});for(var y=0;y<2*n.boxCols;y++){for(var R=y,N=0;N<n.boxRows;N++)R>=0&&R<n.boxCols&&(!function(e,a,o,s,c){var l=i(I[e][a]),d=l.width(),v=l.height();("boxRainGrow"===r||"boxRainGrowReverse"===r)&&l.width(0).height(0),s===c-1?setTimeout(function(){l.animate({opacity:"1",width:d,height:v},n.animSpeed/1.3,"",function(){t.trigger("nivo:animFinished")})},100+o):setTimeout(function(){l.animate({opacity:"1",width:d,height:v},n.animSpeed/1.3)},100+o)}(N,R,d,v,g),v++),R--;d+=100}}},p=function(i){for(var t,e,n=i.length;n;t=parseInt(Math.random()*n,10),e=i[--n],i[n]=i[t],i[t]=e);return i},f=function(i){this.console&&"undefined"!=typeof console.log&&console.log(i)};return this.stop=function(){i(t).data("nivo:vars").stop||(i(t).data("nivo:vars").stop=!0,f("Stop Slider"))},this.start=function(){i(t).data("nivo:vars").stop&&(i(t).data("nivo:vars").stop=!1,f("Start Slider"))},n.afterLoad.call(this),this};i.fn.nivoSlider=function(e){return this.each(function(){var n=i(this);if(n.data("nivoslider"))return n.data("nivoslider");var a=new t(this,e);n.data("nivoslider",a)})},i.fn.nivoSlider.defaults={effect:"random",slices:15,boxCols:8,boxRows:4,animSpeed:500,pauseTime:3e3,startSlide:0,directionNav:!0,controlNav:!0,controlNavThumbs:!1,pauseOnHover:!0,manualAdvance:!1,prevText:"Prev",nextText:"Next",randomStart:!1,beforeChange:function(){},afterChange:function(){},slideshowEnd:function(){},lastSlide:function(){},afterLoad:function(){}},i.fn._reverse=[].reverse}(jQuery);


 /*
Plugin: jQuery Parallax
Version 1.1.3
Author: Ian Lunn
Twitter: @IanLunn
Author URL: http://www.ianlunn.co.uk/
Plugin URL: http://www.ianlunn.co.uk/plugins/jquery-parallax/

Dual licensed under the MIT and GPL licenses:
http://www.opensource.org/licenses/mit-license.php
http://www.gnu.org/licenses/gpl.html
*/

!function(n){var t=n(window),e=t.height();t.resize(function(){e=t.height()}),n.fn.parallax=function(o,i,r){function u(){a.each(function(){l=a.offset().top}),h=r?function(n){return n.outerHeight(!0)}:function(n){return n.height()};var u=t.scrollTop();a.each(function(){var t=n(this),r=t.offset().top,c=h(t);u>r+c||r>u+e||a.css("backgroundPosition",o+" "+Math.round((l-u)*i)+"px")})}var h,l,a=n(this);(arguments.length<1||null===o)&&(o="50%"),(arguments.length<2||null===i)&&(i=.1),(arguments.length<3||null===r)&&(r=!0),t.bind("scroll",u).resize(u),u()}}(jQuery);


// tipsy, facebook style tooltips for jquery
// version 1.0.0a
// (c) 2008-2010 jason frame [jason@onehackoranother.com]
// released under the MIT license

!function(t){function i(t,i){return"function"==typeof t?t.call(i):t}function e(t){for(;t=t.parentNode;)if(t==document)return!0;return!1}function s(i,e){this.$element=t(i),this.options=e,this.enabled=!0,this.fixTitle()}s.prototype={show:function(){var e=this.getTitle();if(e&&this.enabled){var s=this.tip();s.find(".tipsy-inner")[this.options.html?"html":"text"](e),s[0].className="tipsy",s.remove().css({top:0,left:0,visibility:"hidden",display:"block"}).prependTo(document.body);var n,o=t.extend({},this.$element.offset(),{width:this.$element[0].offsetWidth,height:this.$element[0].offsetHeight}),l=s[0].offsetWidth,a=s[0].offsetHeight,f=i(this.options.gravity,this.$element[0]);switch(f.charAt(0)){case"n":n={top:o.top+o.height+this.options.offset,left:o.left+o.width/2-l/2};break;case"s":n={top:o.top-a-this.options.offset,left:o.left+o.width/2-l/2};break;case"e":n={top:o.top+o.height/2-a/2,left:o.left-l-this.options.offset};break;case"w":n={top:o.top+o.height/2-a/2,left:o.left+o.width+this.options.offset}}2==f.length&&(n.left="w"==f.charAt(1)?o.left+o.width/2-15:o.left+o.width/2-l+15),s.css(n).addClass("tipsy-"+f),s.find(".tipsy-arrow")[0].className="tipsy-arrow tipsy-arrow-"+f.charAt(0),this.options.className&&s.addClass(i(this.options.className,this.$element[0])),this.options.fade?s.stop().css({opacity:0,display:"block",visibility:"visible"}).animate({opacity:this.options.opacity}):s.css({visibility:"visible",opacity:this.options.opacity})}},hide:function(){this.options.fade?this.tip().stop().fadeOut(function(){t(this).remove()}):this.tip().remove()},fixTitle:function(){var t=this.$element;(t.attr("title")||"string"!=typeof t.attr("original-title"))&&t.attr("original-title",t.attr("title")||"").removeAttr("title")},getTitle:function(){var t,i=this.$element,e=this.options;this.fixTitle();var t,e=this.options;return"string"==typeof e.title?t=i.attr("title"==e.title?"original-title":e.title):"function"==typeof e.title&&(t=e.title.call(i[0])),t=(""+t).replace(/(^\s*|\s*$)/,""),t||e.fallback},tip:function(){return this.$tip||(this.$tip=t('<div class="tipsy"></div>').html('<div class="tipsy-arrow"></div><div class="tipsy-inner"></div>'),this.$tip.data("tipsy-pointee",this.$element[0])),this.$tip},validate:function(){this.$element[0].parentNode||(this.hide(),this.$element=null,this.options=null)},enable:function(){this.enabled=!0},disable:function(){this.enabled=!1},toggleEnabled:function(){this.enabled=!this.enabled}},t.fn.tipsy=function(i){function e(e){var n=t.data(e,"tipsy");return n||(n=new s(e,t.fn.tipsy.elementOptions(e,i)),t.data(e,"tipsy",n)),n}function n(){var t=e(this);t.hoverState="in",0==i.delayIn?t.show():(t.fixTitle(),setTimeout(function(){"in"==t.hoverState&&t.show()},i.delayIn))}function o(){var t=e(this);t.hoverState="out",0==i.delayOut?t.hide():setTimeout(function(){"out"==t.hoverState&&t.hide()},i.delayOut)}if(i===!0)return this.data("tipsy");if("string"==typeof i){var l=this.data("tipsy");return l&&l[i](),this}if(i=t.extend({},t.fn.tipsy.defaults,i),i.live||this.each(function(){e(this)}),"manual"!=i.trigger){var a=i.live?"live":"bind",f="hover"==i.trigger?"mouseenter":"focus",h="hover"==i.trigger?"mouseleave":"blur";this[a](f,n)[a](h,o)}return this},t.fn.tipsy.defaults={className:null,delayIn:0,delayOut:0,fade:!1,fallback:"",gravity:"n",html:!1,live:!1,offset:0,opacity:.8,title:"title",trigger:"hover"},t.fn.tipsy.revalidate=function(){t(".tipsy").each(function(){var i=t.data(this,"tipsy-pointee");i&&e(i)||t(this).remove()})},t.fn.tipsy.elementOptions=function(i,e){return t.metadata?t.extend({},e,t(i).metadata()):e},t.fn.tipsy.autoNS=function(){return t(this).offset().top>t(document).scrollTop()+t(window).height()/2?"s":"n"},t.fn.tipsy.autoWE=function(){return t(this).offset().left>t(document).scrollLeft()+t(window).width()/2?"e":"w"},t.fn.tipsy.autoBounds=function(i,e){return function(){var s={ns:e[0],ew:e.length>1?e[1]:!1},n=t(document).scrollTop()+i,o=t(document).scrollLeft()+i,l=t(this);return l.offset().top<n&&(s.ns="n"),l.offset().left<o&&(s.ew="w"),t(window).width()+t(document).scrollLeft()-l.offset().left<i&&(s.ew="e"),t(window).height()+t(document).scrollTop()-l.offset().top<i&&(s.ns="s"),s.ns+(s.ew?s.ew:"")}}}(jQuery);


/**
 * Lightbox v2.7.1
 * by Lokesh Dhakar - http://lokeshdhakar.com/projects/lightbox2/
 *
 * @license http://creativecommons.org/licenses/by/2.5/
 * - Free for use in both personal and commercial projects
 * - Attribution requires leaving author name, author link, and the license info intact
 */

(function(){var a=jQuery,b=function(){function a(){this.fadeDuration=500,this.fitImagesInViewport=!0,this.resizeDuration=700,this.positionFromTop=50,this.showImageNumberLabel=!0,this.alwaysShowNavOnTouchDevices=!1,this.wrapAround=!1}return a.prototype.albumLabel=function(a,b){return"Image "+a+" of "+b},a}(),c=function(){function b(a){this.options=a,this.album=[],this.currentImageIndex=void 0,this.init()}return b.prototype.init=function(){this.enable(),this.build()},b.prototype.enable=function(){var b=this;a("body").on("click","a[rel^=lightbox], area[rel^=lightbox], a[data-lightbox], area[data-lightbox]",function(c){return b.start(a(c.currentTarget)),!1})},b.prototype.build=function(){var b=this;a("<div id='lightboxOverlay' class='lightboxOverlay'></div><div id='lightbox' class='lightbox'><div class='lb-outerContainer'><div class='lb-container'><img class='lb-image' src='' /><div class='lb-nav'><a class='lb-prev' href='' ></a><a class='lb-next' href='' ></a></div><div class='lb-loader'><a class='lb-cancel'></a></div></div></div><div class='lb-dataContainer'><div class='lb-data'><div class='lb-details'><span class='lb-caption'></span><span class='lb-number'></span></div><div class='lb-closeContainer'><a class='lb-close'></a></div></div></div></div>").appendTo(a("body")),this.$lightbox=a("#lightbox"),this.$overlay=a("#lightboxOverlay"),this.$outerContainer=this.$lightbox.find(".lb-outerContainer"),this.$container=this.$lightbox.find(".lb-container"),this.containerTopPadding=parseInt(this.$container.css("padding-top"),10),this.containerRightPadding=parseInt(this.$container.css("padding-right"),10),this.containerBottomPadding=parseInt(this.$container.css("padding-bottom"),10),this.containerLeftPadding=parseInt(this.$container.css("padding-left"),10),this.$overlay.hide().on("click",function(){return b.end(),!1}),this.$lightbox.hide().on("click",function(c){return"lightbox"===a(c.target).attr("id")&&b.end(),!1}),this.$outerContainer.on("click",function(c){return"lightbox"===a(c.target).attr("id")&&b.end(),!1}),this.$lightbox.find(".lb-prev").on("click",function(){return b.changeImage(0===b.currentImageIndex?b.album.length-1:b.currentImageIndex-1),!1}),this.$lightbox.find(".lb-next").on("click",function(){return b.changeImage(b.currentImageIndex===b.album.length-1?0:b.currentImageIndex+1),!1}),this.$lightbox.find(".lb-loader, .lb-close").on("click",function(){return b.end(),!1})},b.prototype.start=function(b){function c(a){d.album.push({link:a.attr("href"),title:a.attr("data-title")||a.attr("title")})}var d=this,e=a(window);e.on("resize",a.proxy(this.sizeOverlay,this)),a("select, object, embed").css({visibility:"hidden"}),this.sizeOverlay(),this.album=[];var f,g=0,h=b.attr("data-lightbox");if(h){f=a(b.prop("tagName")+'[data-lightbox="'+h+'"]');for(var i=0;i<f.length;i=++i)c(a(f[i])),f[i]===b[0]&&(g=i)}else if("lightbox"===b.attr("rel"))c(b);else{f=a(b.prop("tagName")+'[rel="'+b.attr("rel")+'"]');for(var j=0;j<f.length;j=++j)c(a(f[j])),f[j]===b[0]&&(g=j)}var k=e.scrollTop()+this.options.positionFromTop,l=e.scrollLeft();this.$lightbox.css({top:k+"px",left:l+"px"}).fadeIn(this.options.fadeDuration),this.changeImage(g)},b.prototype.changeImage=function(b){var c=this;this.disableKeyboardNav();var d=this.$lightbox.find(".lb-image");this.$overlay.fadeIn(this.options.fadeDuration),a(".lb-loader").fadeIn("slow"),this.$lightbox.find(".lb-image, .lb-nav, .lb-prev, .lb-next, .lb-dataContainer, .lb-numbers, .lb-caption").hide(),this.$outerContainer.addClass("animating");var e=new Image;e.onload=function(){var f,g,h,i,j,k,l;d.attr("src",c.album[b].link),f=a(e),d.width(e.width),d.height(e.height),c.options.fitImagesInViewport&&(l=a(window).width(),k=a(window).height(),j=l-c.containerLeftPadding-c.containerRightPadding-20,i=k-c.containerTopPadding-c.containerBottomPadding-120,(e.width>j||e.height>i)&&(e.width/j>e.height/i?(h=j,g=parseInt(e.height/(e.width/h),10),d.width(h),d.height(g)):(g=i,h=parseInt(e.width/(e.height/g),10),d.width(h),d.height(g)))),c.sizeContainer(d.width(),d.height())},e.src=this.album[b].link,this.currentImageIndex=b},b.prototype.sizeOverlay=function(){this.$overlay.width(a(window).width()).height(a(document).height())},b.prototype.sizeContainer=function(a,b){function c(){d.$lightbox.find(".lb-dataContainer").width(g),d.$lightbox.find(".lb-prevLink").height(h),d.$lightbox.find(".lb-nextLink").height(h),d.showImage()}var d=this,e=this.$outerContainer.outerWidth(),f=this.$outerContainer.outerHeight(),g=a+this.containerLeftPadding+this.containerRightPadding,h=b+this.containerTopPadding+this.containerBottomPadding;e!==g||f!==h?this.$outerContainer.animate({width:g,height:h},this.options.resizeDuration,"swing",function(){c()}):c()},b.prototype.showImage=function(){this.$lightbox.find(".lb-loader").hide(),this.$lightbox.find(".lb-image").fadeIn("slow"),this.updateNav(),this.updateDetails(),this.preloadNeighboringImages(),this.enableKeyboardNav()},b.prototype.updateNav=function(){var a=!1;try{document.createEvent("TouchEvent"),a=this.options.alwaysShowNavOnTouchDevices?!0:!1}catch(b){}this.$lightbox.find(".lb-nav").show(),this.album.length>1&&(this.options.wrapAround?(a&&this.$lightbox.find(".lb-prev, .lb-next").css("opacity","1"),this.$lightbox.find(".lb-prev, .lb-next").show()):(this.currentImageIndex>0&&(this.$lightbox.find(".lb-prev").show(),a&&this.$lightbox.find(".lb-prev").css("opacity","1")),this.currentImageIndex<this.album.length-1&&(this.$lightbox.find(".lb-next").show(),a&&this.$lightbox.find(".lb-next").css("opacity","1"))))},b.prototype.updateDetails=function(){var b=this;"undefined"!=typeof this.album[this.currentImageIndex].title&&""!==this.album[this.currentImageIndex].title&&this.$lightbox.find(".lb-caption").html(this.album[this.currentImageIndex].title).fadeIn("fast").find("a").on("click",function(){location.href=a(this).attr("href")}),this.album.length>1&&this.options.showImageNumberLabel?this.$lightbox.find(".lb-number").text(this.options.albumLabel(this.currentImageIndex+1,this.album.length)).fadeIn("fast"):this.$lightbox.find(".lb-number").hide(),this.$outerContainer.removeClass("animating"),this.$lightbox.find(".lb-dataContainer").fadeIn(this.options.resizeDuration,function(){return b.sizeOverlay()})},b.prototype.preloadNeighboringImages=function(){if(this.album.length>this.currentImageIndex+1){var a=new Image;a.src=this.album[this.currentImageIndex+1].link}if(this.currentImageIndex>0){var b=new Image;b.src=this.album[this.currentImageIndex-1].link}},b.prototype.enableKeyboardNav=function(){a(document).on("keyup.keyboard",a.proxy(this.keyboardAction,this))},b.prototype.disableKeyboardNav=function(){a(document).off(".keyboard")},b.prototype.keyboardAction=function(a){var b=27,c=37,d=39,e=a.keyCode,f=String.fromCharCode(e).toLowerCase();e===b||f.match(/x|o|c/)?this.end():"p"===f||e===c?0!==this.currentImageIndex?this.changeImage(this.currentImageIndex-1):this.options.wrapAround&&this.album.length>1&&this.changeImage(this.album.length-1):("n"===f||e===d)&&(this.currentImageIndex!==this.album.length-1?this.changeImage(this.currentImageIndex+1):this.options.wrapAround&&this.album.length>1&&this.changeImage(0))},b.prototype.end=function(){this.disableKeyboardNav(),a(window).off("resize",this.sizeOverlay),this.$lightbox.fadeOut(this.options.fadeDuration),this.$overlay.fadeOut(this.options.fadeDuration),a("select, object, embed").css({visibility:"visible"})},b}();a(function(){{var a=new b;new c(a)}})}).call(this);


/*!
 * Masonry PACKAGED v3.3.0
 * Cascading grid layout library
 * http://masonry.desandro.com
 * MIT License
 * by David DeSandro
 */

!function(a){function b(){}function c(a){function c(b){b.prototype.option||(b.prototype.option=function(b){a.isPlainObject(b)&&(this.options=a.extend(!0,this.options,b))})}function e(b,c){a.fn[b]=function(e){if("string"==typeof e){for(var g=d.call(arguments,1),h=0,i=this.length;i>h;h++){var j=this[h],k=a.data(j,b);if(k)if(a.isFunction(k[e])&&"_"!==e.charAt(0)){var l=k[e].apply(k,g);if(void 0!==l)return l}else f("no such method '"+e+"' for "+b+" instance");else f("cannot call methods on "+b+" prior to initialization; attempted to call '"+e+"'")}return this}return this.each(function(){var d=a.data(this,b);d?(d.option(e),d._init()):(d=new c(this,e),a.data(this,b,d))})}}if(a){var f="undefined"==typeof console?b:function(a){console.error(a)};return a.bridget=function(a,b){c(b),e(a,b)},a.bridget}}var d=Array.prototype.slice;"function"==typeof define&&define.amd?define("jquery-bridget/jquery.bridget",["jquery"],c):c("object"==typeof exports?require("jquery"):a.jQuery)}(window),function(a){function b(b){var c=a.event;return c.target=c.target||c.srcElement||b,c}var c=document.documentElement,d=function(){};c.addEventListener?d=function(a,b,c){a.addEventListener(b,c,!1)}:c.attachEvent&&(d=function(a,c,d){a[c+d]=d.handleEvent?function(){var c=b(a);d.handleEvent.call(d,c)}:function(){var c=b(a);d.call(a,c)},a.attachEvent("on"+c,a[c+d])});var e=function(){};c.removeEventListener?e=function(a,b,c){a.removeEventListener(b,c,!1)}:c.detachEvent&&(e=function(a,b,c){a.detachEvent("on"+b,a[b+c]);try{delete a[b+c]}catch(d){a[b+c]=void 0}});var f={bind:d,unbind:e};"function"==typeof define&&define.amd?define("eventie/eventie",f):"object"==typeof exports?module.exports=f:a.eventie=f}(window),function(){function a(){}function b(a,b){for(var c=a.length;c--;)if(a[c].listener===b)return c;return-1}function c(a){return function(){return this[a].apply(this,arguments)}}var d=a.prototype,e=this,f=e.EventEmitter;d.getListeners=function(a){var b,c,d=this._getEvents();if(a instanceof RegExp){b={};for(c in d)d.hasOwnProperty(c)&&a.test(c)&&(b[c]=d[c])}else b=d[a]||(d[a]=[]);return b},d.flattenListeners=function(a){var b,c=[];for(b=0;b<a.length;b+=1)c.push(a[b].listener);return c},d.getListenersAsObject=function(a){var b,c=this.getListeners(a);return c instanceof Array&&(b={},b[a]=c),b||c},d.addListener=function(a,c){var d,e=this.getListenersAsObject(a),f="object"==typeof c;for(d in e)e.hasOwnProperty(d)&&-1===b(e[d],c)&&e[d].push(f?c:{listener:c,once:!1});return this},d.on=c("addListener"),d.addOnceListener=function(a,b){return this.addListener(a,{listener:b,once:!0})},d.once=c("addOnceListener"),d.defineEvent=function(a){return this.getListeners(a),this},d.defineEvents=function(a){for(var b=0;b<a.length;b+=1)this.defineEvent(a[b]);return this},d.removeListener=function(a,c){var d,e,f=this.getListenersAsObject(a);for(e in f)f.hasOwnProperty(e)&&(d=b(f[e],c),-1!==d&&f[e].splice(d,1));return this},d.off=c("removeListener"),d.addListeners=function(a,b){return this.manipulateListeners(!1,a,b)},d.removeListeners=function(a,b){return this.manipulateListeners(!0,a,b)},d.manipulateListeners=function(a,b,c){var d,e,f=a?this.removeListener:this.addListener,g=a?this.removeListeners:this.addListeners;if("object"!=typeof b||b instanceof RegExp)for(d=c.length;d--;)f.call(this,b,c[d]);else for(d in b)b.hasOwnProperty(d)&&(e=b[d])&&("function"==typeof e?f.call(this,d,e):g.call(this,d,e));return this},d.removeEvent=function(a){var b,c=typeof a,d=this._getEvents();if("string"===c)delete d[a];else if(a instanceof RegExp)for(b in d)d.hasOwnProperty(b)&&a.test(b)&&delete d[b];else delete this._events;return this},d.removeAllListeners=c("removeEvent"),d.emitEvent=function(a,b){var c,d,e,f,g=this.getListenersAsObject(a);for(e in g)if(g.hasOwnProperty(e))for(d=g[e].length;d--;)c=g[e][d],c.once===!0&&this.removeListener(a,c.listener),f=c.listener.apply(this,b||[]),f===this._getOnceReturnValue()&&this.removeListener(a,c.listener);return this},d.trigger=c("emitEvent"),d.emit=function(a){var b=Array.prototype.slice.call(arguments,1);return this.emitEvent(a,b)},d.setOnceReturnValue=function(a){return this._onceReturnValue=a,this},d._getOnceReturnValue=function(){return this.hasOwnProperty("_onceReturnValue")?this._onceReturnValue:!0},d._getEvents=function(){return this._events||(this._events={})},a.noConflict=function(){return e.EventEmitter=f,a},"function"==typeof define&&define.amd?define("eventEmitter/EventEmitter",[],function(){return a}):"object"==typeof module&&module.exports?module.exports=a:e.EventEmitter=a}.call(this),function(a){function b(a){if(a){if("string"==typeof d[a])return a;a=a.charAt(0).toUpperCase()+a.slice(1);for(var b,e=0,f=c.length;f>e;e++)if(b=c[e]+a,"string"==typeof d[b])return b}}var c="Webkit Moz ms Ms O".split(" "),d=document.documentElement.style;"function"==typeof define&&define.amd?define("get-style-property/get-style-property",[],function(){return b}):"object"==typeof exports?module.exports=b:a.getStyleProperty=b}(window),function(a){function b(a){var b=parseFloat(a),c=-1===a.indexOf("%")&&!isNaN(b);return c&&b}function c(){}function d(){for(var a={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},b=0,c=g.length;c>b;b++){var d=g[b];a[d]=0}return a}function e(c){function e(){if(!m){m=!0;var d=a.getComputedStyle;if(j=function(){var a=d?function(a){return d(a,null)}:function(a){return a.currentStyle};return function(b){var c=a(b);return c||f("Style returned "+c+". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1"),c}}(),k=c("boxSizing")){var e=document.createElement("div");e.style.width="200px",e.style.padding="1px 2px 3px 4px",e.style.borderStyle="solid",e.style.borderWidth="1px 2px 3px 4px",e.style[k]="border-box";var g=document.body||document.documentElement;g.appendChild(e);var h=j(e);l=200===b(h.width),g.removeChild(e)}}}function h(a){if(e(),"string"==typeof a&&(a=document.querySelector(a)),a&&"object"==typeof a&&a.nodeType){var c=j(a);if("none"===c.display)return d();var f={};f.width=a.offsetWidth,f.height=a.offsetHeight;for(var h=f.isBorderBox=!(!k||!c[k]||"border-box"!==c[k]),m=0,n=g.length;n>m;m++){var o=g[m],p=c[o];p=i(a,p);var q=parseFloat(p);f[o]=isNaN(q)?0:q}var r=f.paddingLeft+f.paddingRight,s=f.paddingTop+f.paddingBottom,t=f.marginLeft+f.marginRight,u=f.marginTop+f.marginBottom,v=f.borderLeftWidth+f.borderRightWidth,w=f.borderTopWidth+f.borderBottomWidth,x=h&&l,y=b(c.width);y!==!1&&(f.width=y+(x?0:r+v));var z=b(c.height);return z!==!1&&(f.height=z+(x?0:s+w)),f.innerWidth=f.width-(r+v),f.innerHeight=f.height-(s+w),f.outerWidth=f.width+t,f.outerHeight=f.height+u,f}}function i(b,c){if(a.getComputedStyle||-1===c.indexOf("%"))return c;var d=b.style,e=d.left,f=b.runtimeStyle,g=f&&f.left;return g&&(f.left=b.currentStyle.left),d.left=c,c=d.pixelLeft,d.left=e,g&&(f.left=g),c}var j,k,l,m=!1;return h}var f="undefined"==typeof console?c:function(a){console.error(a)},g=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"];"function"==typeof define&&define.amd?define("get-size/get-size",["get-style-property/get-style-property"],e):"object"==typeof exports?module.exports=e(require("desandro-get-style-property")):a.getSize=e(a.getStyleProperty)}(window),function(a){function b(a){"function"==typeof a&&(b.isReady?a():g.push(a))}function c(a){var c="readystatechange"===a.type&&"complete"!==f.readyState;b.isReady||c||d()}function d(){b.isReady=!0;for(var a=0,c=g.length;c>a;a++){var d=g[a];d()}}function e(e){return"complete"===f.readyState?d():(e.bind(f,"DOMContentLoaded",c),e.bind(f,"readystatechange",c),e.bind(a,"load",c)),b}var f=a.document,g=[];b.isReady=!1,"function"==typeof define&&define.amd?define("doc-ready/doc-ready",["eventie/eventie"],e):"object"==typeof exports?module.exports=e(require("eventie")):a.docReady=e(a.eventie)}(window),function(a){function b(a,b){return a[g](b)}function c(a){if(!a.parentNode){var b=document.createDocumentFragment();b.appendChild(a)}}function d(a,b){c(a);for(var d=a.parentNode.querySelectorAll(b),e=0,f=d.length;f>e;e++)if(d[e]===a)return!0;return!1}function e(a,d){return c(a),b(a,d)}var f,g=function(){if(a.matches)return"matches";if(a.matchesSelector)return"matchesSelector";for(var b=["webkit","moz","ms","o"],c=0,d=b.length;d>c;c++){var e=b[c],f=e+"MatchesSelector";if(a[f])return f}}();if(g){var h=document.createElement("div"),i=b(h,"div");f=i?b:e}else f=d;"function"==typeof define&&define.amd?define("matches-selector/matches-selector",[],function(){return f}):"object"==typeof exports?module.exports=f:window.matchesSelector=f}(Element.prototype),function(a,b){"function"==typeof define&&define.amd?define("fizzy-ui-utils/utils",["doc-ready/doc-ready","matches-selector/matches-selector"],function(c,d){return b(a,c,d)}):"object"==typeof exports?module.exports=b(a,require("doc-ready"),require("desandro-matches-selector")):a.fizzyUIUtils=b(a,a.docReady,a.matchesSelector)}(window,function(a,b,c){var d={};d.extend=function(a,b){for(var c in b)a[c]=b[c];return a},d.modulo=function(a,b){return(a%b+b)%b};var e=Object.prototype.toString;d.isArray=function(a){return"[object Array]"==e.call(a)},d.makeArray=function(a){var b=[];if(d.isArray(a))b=a;else if(a&&"number"==typeof a.length)for(var c=0,e=a.length;e>c;c++)b.push(a[c]);else b.push(a);return b},d.indexOf=Array.prototype.indexOf?function(a,b){return a.indexOf(b)}:function(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c]===b)return c;return-1},d.removeFrom=function(a,b){var c=d.indexOf(a,b);-1!=c&&a.splice(c,1)},d.isElement="function"==typeof HTMLElement||"object"==typeof HTMLElement?function(a){return a instanceof HTMLElement}:function(a){return a&&"object"==typeof a&&1==a.nodeType&&"string"==typeof a.nodeName},d.setText=function(){function a(a,c){b=b||(void 0!==document.documentElement.textContent?"textContent":"innerText"),a[b]=c}var b;return a}(),d.getParent=function(a,b){for(;a!=document.body;)if(a=a.parentNode,c(a,b))return a},d.getQueryElement=function(a){return"string"==typeof a?document.querySelector(a):a},d.handleEvent=function(a){var b="on"+a.type;this[b]&&this[b](a)},d.filterFindElements=function(a,b){a=d.makeArray(a);for(var e=[],f=0,g=a.length;g>f;f++){var h=a[f];if(d.isElement(h))if(b){c(h,b)&&e.push(h);for(var i=h.querySelectorAll(b),j=0,k=i.length;k>j;j++)e.push(i[j])}else e.push(h)}return e},d.debounceMethod=function(a,b,c){var d=a.prototype[b],e=b+"Timeout";a.prototype[b]=function(){var a=this[e];a&&clearTimeout(a);var b=arguments,f=this;this[e]=setTimeout(function(){d.apply(f,b),delete f[e]},c||100)}},d.toDashed=function(a){return a.replace(/(.)([A-Z])/g,function(a,b,c){return b+"-"+c}).toLowerCase()};var f=a.console;return d.htmlInit=function(c,e){b(function(){for(var b=d.toDashed(e),g=document.querySelectorAll(".js-"+b),h="data-"+b+"-options",i=0,j=g.length;j>i;i++){var k,l=g[i],m=l.getAttribute(h);try{k=m&&JSON.parse(m)}catch(n){f&&f.error("Error parsing "+h+" on "+l.nodeName.toLowerCase()+(l.id?"#"+l.id:"")+": "+n);continue}var o=new c(l,k),p=a.jQuery;p&&p.data(l,e,o)}})},d}),function(a,b){"function"==typeof define&&define.amd?define("outlayer/item",["eventEmitter/EventEmitter","get-size/get-size","get-style-property/get-style-property","fizzy-ui-utils/utils"],function(c,d,e,f){return b(a,c,d,e,f)}):"object"==typeof exports?module.exports=b(a,require("wolfy87-eventemitter"),require("get-size"),require("desandro-get-style-property"),require("fizzy-ui-utils")):(a.Outlayer={},a.Outlayer.Item=b(a,a.EventEmitter,a.getSize,a.getStyleProperty,a.fizzyUIUtils))}(window,function(a,b,c,d,e){function f(a){for(var b in a)return!1;return b=null,!0}function g(a,b){a&&(this.element=a,this.layout=b,this.position={x:0,y:0},this._create())}var h=a.getComputedStyle,i=h?function(a){return h(a,null)}:function(a){return a.currentStyle},j=d("transition"),k=d("transform"),l=j&&k,m=!!d("perspective"),n={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"otransitionend",transition:"transitionend"}[j],o=["transform","transition","transitionDuration","transitionProperty"],p=function(){for(var a={},b=0,c=o.length;c>b;b++){var e=o[b],f=d(e);f&&f!==e&&(a[e]=f)}return a}();e.extend(g.prototype,b.prototype),g.prototype._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"})},g.prototype.handleEvent=function(a){var b="on"+a.type;this[b]&&this[b](a)},g.prototype.getSize=function(){this.size=c(this.element)},g.prototype.css=function(a){var b=this.element.style;for(var c in a){var d=p[c]||c;b[d]=a[c]}},g.prototype.getPosition=function(){var a=i(this.element),b=this.layout.options,c=b.isOriginLeft,d=b.isOriginTop,e=parseInt(a[c?"left":"right"],10),f=parseInt(a[d?"top":"bottom"],10);e=isNaN(e)?0:e,f=isNaN(f)?0:f;var g=this.layout.size;e-=c?g.paddingLeft:g.paddingRight,f-=d?g.paddingTop:g.paddingBottom,this.position.x=e,this.position.y=f},g.prototype.layoutPosition=function(){var a=this.layout.size,b=this.layout.options,c={},d=b.isOriginLeft?"paddingLeft":"paddingRight",e=b.isOriginLeft?"left":"right",f=b.isOriginLeft?"right":"left",g=this.position.x+a[d];g=b.percentPosition&&!b.isHorizontal?g/a.width*100+"%":g+"px",c[e]=g,c[f]="";var h=b.isOriginTop?"paddingTop":"paddingBottom",i=b.isOriginTop?"top":"bottom",j=b.isOriginTop?"bottom":"top",k=this.position.y+a[h];k=b.percentPosition&&b.isHorizontal?k/a.height*100+"%":k+"px",c[i]=k,c[j]="",this.css(c),this.emitEvent("layout",[this])};var q=m?function(a,b){return"translate3d("+a+"px, "+b+"px, 0)"}:function(a,b){return"translate("+a+"px, "+b+"px)"};g.prototype._transitionTo=function(a,b){this.getPosition();var c=this.position.x,d=this.position.y,e=parseInt(a,10),f=parseInt(b,10),g=e===this.position.x&&f===this.position.y;if(this.setPosition(a,b),g&&!this.isTransitioning)return void this.layoutPosition();var h=a-c,i=b-d,j={},k=this.layout.options;h=k.isOriginLeft?h:-h,i=k.isOriginTop?i:-i,j.transform=q(h,i),this.transition({to:j,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},g.prototype.goTo=function(a,b){this.setPosition(a,b),this.layoutPosition()},g.prototype.moveTo=l?g.prototype._transitionTo:g.prototype.goTo,g.prototype.setPosition=function(a,b){this.position.x=parseInt(a,10),this.position.y=parseInt(b,10)},g.prototype._nonTransition=function(a){this.css(a.to),a.isCleaning&&this._removeStyles(a.to);for(var b in a.onTransitionEnd)a.onTransitionEnd[b].call(this)},g.prototype._transition=function(a){if(!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(a);var b=this._transn;for(var c in a.onTransitionEnd)b.onEnd[c]=a.onTransitionEnd[c];for(c in a.to)b.ingProperties[c]=!0,a.isCleaning&&(b.clean[c]=!0);if(a.from){this.css(a.from);var d=this.element.offsetHeight;d=null}this.enableTransition(a.to),this.css(a.to),this.isTransitioning=!0};var r=k&&e.toDashed(k)+",opacity";g.prototype.enableTransition=function(){this.isTransitioning||(this.css({transitionProperty:r,transitionDuration:this.layout.options.transitionDuration}),this.element.addEventListener(n,this,!1))},g.prototype.transition=g.prototype[j?"_transition":"_nonTransition"],g.prototype.onwebkitTransitionEnd=function(a){this.ontransitionend(a)},g.prototype.onotransitionend=function(a){this.ontransitionend(a)};var s={"-webkit-transform":"transform","-moz-transform":"transform","-o-transform":"transform"};g.prototype.ontransitionend=function(a){if(a.target===this.element){var b=this._transn,c=s[a.propertyName]||a.propertyName;if(delete b.ingProperties[c],f(b.ingProperties)&&this.disableTransition(),c in b.clean&&(this.element.style[a.propertyName]="",delete b.clean[c]),c in b.onEnd){var d=b.onEnd[c];d.call(this),delete b.onEnd[c]}this.emitEvent("transitionEnd",[this])}},g.prototype.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(n,this,!1),this.isTransitioning=!1},g.prototype._removeStyles=function(a){var b={};for(var c in a)b[c]="";this.css(b)};var t={transitionProperty:"",transitionDuration:""};return g.prototype.removeTransitionStyles=function(){this.css(t)},g.prototype.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this])},g.prototype.remove=function(){if(!j||!parseFloat(this.layout.options.transitionDuration))return void this.removeElem();var a=this;this.once("transitionEnd",function(){a.removeElem()}),this.hide()},g.prototype.reveal=function(){delete this.isHidden,this.css({display:""});var a=this.layout.options,b={},c=this.getHideRevealTransitionEndProperty("visibleStyle");b[c]=this.onRevealTransitionEnd,this.transition({from:a.hiddenStyle,to:a.visibleStyle,isCleaning:!0,onTransitionEnd:b})},g.prototype.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal")},g.prototype.getHideRevealTransitionEndProperty=function(a){var b=this.layout.options[a];if(b.opacity)return"opacity";for(var c in b)return c},g.prototype.hide=function(){this.isHidden=!0,this.css({display:""});var a=this.layout.options,b={},c=this.getHideRevealTransitionEndProperty("hiddenStyle");b[c]=this.onHideTransitionEnd,this.transition({from:a.visibleStyle,to:a.hiddenStyle,isCleaning:!0,onTransitionEnd:b})},g.prototype.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"))},g.prototype.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""})},g}),function(a,b){"function"==typeof define&&define.amd?define("outlayer/outlayer",["eventie/eventie","eventEmitter/EventEmitter","get-size/get-size","fizzy-ui-utils/utils","./item"],function(c,d,e,f,g){return b(a,c,d,e,f,g)}):"object"==typeof exports?module.exports=b(a,require("eventie"),require("wolfy87-eventemitter"),require("get-size"),require("fizzy-ui-utils"),require("./item")):a.Outlayer=b(a,a.eventie,a.EventEmitter,a.getSize,a.fizzyUIUtils,a.Outlayer.Item)}(window,function(a,b,c,d,e,f){function g(a,b){var c=e.getQueryElement(a);if(!c)return void(h&&h.error("Bad element for "+this.constructor.namespace+": "+(c||a)));this.element=c,i&&(this.$element=i(this.element)),this.options=e.extend({},this.constructor.defaults),this.option(b);var d=++k;this.element.outlayerGUID=d,l[d]=this,this._create(),this.options.isInitLayout&&this.layout()}var h=a.console,i=a.jQuery,j=function(){},k=0,l={};return g.namespace="outlayer",g.Item=f,g.defaults={containerStyle:{position:"relative"},isInitLayout:!0,isOriginLeft:!0,isOriginTop:!0,isResizeBound:!0,isResizingContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}},e.extend(g.prototype,c.prototype),g.prototype.option=function(a){e.extend(this.options,a)},g.prototype._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),e.extend(this.element.style,this.options.containerStyle),this.options.isResizeBound&&this.bindResize()},g.prototype.reloadItems=function(){this.items=this._itemize(this.element.children)},g.prototype._itemize=function(a){for(var b=this._filterFindItemElements(a),c=this.constructor.Item,d=[],e=0,f=b.length;f>e;e++){var g=b[e],h=new c(g,this);d.push(h)}return d},g.prototype._filterFindItemElements=function(a){return e.filterFindElements(a,this.options.itemSelector)},g.prototype.getItemElements=function(){for(var a=[],b=0,c=this.items.length;c>b;b++)a.push(this.items[b].element);return a},g.prototype.layout=function(){this._resetLayout(),this._manageStamps();var a=void 0!==this.options.isLayoutInstant?this.options.isLayoutInstant:!this._isLayoutInited;this.layoutItems(this.items,a),this._isLayoutInited=!0},g.prototype._init=g.prototype.layout,g.prototype._resetLayout=function(){this.getSize()},g.prototype.getSize=function(){this.size=d(this.element)},g.prototype._getMeasurement=function(a,b){var c,f=this.options[a];f?("string"==typeof f?c=this.element.querySelector(f):e.isElement(f)&&(c=f),this[a]=c?d(c)[b]:f):this[a]=0},g.prototype.layoutItems=function(a,b){a=this._getItemsForLayout(a),this._layoutItems(a,b),this._postLayout()},g.prototype._getItemsForLayout=function(a){for(var b=[],c=0,d=a.length;d>c;c++){var e=a[c];e.isIgnored||b.push(e)}return b},g.prototype._layoutItems=function(a,b){if(this._emitCompleteOnItems("layout",a),a&&a.length){for(var c=[],d=0,e=a.length;e>d;d++){var f=a[d],g=this._getItemLayoutPosition(f);g.item=f,g.isInstant=b||f.isLayoutInstant,c.push(g)}this._processLayoutQueue(c)}},g.prototype._getItemLayoutPosition=function(){return{x:0,y:0}},g.prototype._processLayoutQueue=function(a){for(var b=0,c=a.length;c>b;b++){var d=a[b];this._positionItem(d.item,d.x,d.y,d.isInstant)}},g.prototype._positionItem=function(a,b,c,d){d?a.goTo(b,c):a.moveTo(b,c)},g.prototype._postLayout=function(){this.resizeContainer()},g.prototype.resizeContainer=function(){if(this.options.isResizingContainer){var a=this._getContainerSize();a&&(this._setContainerMeasure(a.width,!0),this._setContainerMeasure(a.height,!1))}},g.prototype._getContainerSize=j,g.prototype._setContainerMeasure=function(a,b){if(void 0!==a){var c=this.size;c.isBorderBox&&(a+=b?c.paddingLeft+c.paddingRight+c.borderLeftWidth+c.borderRightWidth:c.paddingBottom+c.paddingTop+c.borderTopWidth+c.borderBottomWidth),a=Math.max(a,0),this.element.style[b?"width":"height"]=a+"px"}},g.prototype._emitCompleteOnItems=function(a,b){function c(){e.emitEvent(a+"Complete",[b])}function d(){g++,g===f&&c()}var e=this,f=b.length;if(!b||!f)return void c();for(var g=0,h=0,i=b.length;i>h;h++){var j=b[h];j.once(a,d)}},g.prototype.ignore=function(a){var b=this.getItem(a);b&&(b.isIgnored=!0)},g.prototype.unignore=function(a){var b=this.getItem(a);b&&delete b.isIgnored},g.prototype.stamp=function(a){if(a=this._find(a)){this.stamps=this.stamps.concat(a);for(var b=0,c=a.length;c>b;b++){var d=a[b];this.ignore(d)}}},g.prototype.unstamp=function(a){if(a=this._find(a))for(var b=0,c=a.length;c>b;b++){var d=a[b];e.removeFrom(this.stamps,d),this.unignore(d)}},g.prototype._find=function(a){return a?("string"==typeof a&&(a=this.element.querySelectorAll(a)),a=e.makeArray(a)):void 0},g.prototype._manageStamps=function(){if(this.stamps&&this.stamps.length){this._getBoundingRect();for(var a=0,b=this.stamps.length;b>a;a++){var c=this.stamps[a];this._manageStamp(c)}}},g.prototype._getBoundingRect=function(){var a=this.element.getBoundingClientRect(),b=this.size;this._boundingRect={left:a.left+b.paddingLeft+b.borderLeftWidth,top:a.top+b.paddingTop+b.borderTopWidth,right:a.right-(b.paddingRight+b.borderRightWidth),bottom:a.bottom-(b.paddingBottom+b.borderBottomWidth)}},g.prototype._manageStamp=j,g.prototype._getElementOffset=function(a){var b=a.getBoundingClientRect(),c=this._boundingRect,e=d(a),f={left:b.left-c.left-e.marginLeft,top:b.top-c.top-e.marginTop,right:c.right-b.right-e.marginRight,bottom:c.bottom-b.bottom-e.marginBottom};return f},g.prototype.handleEvent=function(a){var b="on"+a.type;this[b]&&this[b](a)},g.prototype.bindResize=function(){this.isResizeBound||(b.bind(a,"resize",this),this.isResizeBound=!0)},g.prototype.unbindResize=function(){this.isResizeBound&&b.unbind(a,"resize",this),this.isResizeBound=!1},g.prototype.onresize=function(){function a(){b.resize(),delete b.resizeTimeout}this.resizeTimeout&&clearTimeout(this.resizeTimeout);var b=this;this.resizeTimeout=setTimeout(a,100)},g.prototype.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},g.prototype.needsResizeLayout=function(){var a=d(this.element),b=this.size&&a;return b&&a.innerWidth!==this.size.innerWidth},g.prototype.addItems=function(a){var b=this._itemize(a);return b.length&&(this.items=this.items.concat(b)),b},g.prototype.appended=function(a){var b=this.addItems(a);b.length&&(this.layoutItems(b,!0),this.reveal(b))},g.prototype.prepended=function(a){var b=this._itemize(a);if(b.length){var c=this.items.slice(0);this.items=b.concat(c),this._resetLayout(),this._manageStamps(),this.layoutItems(b,!0),this.reveal(b),this.layoutItems(c)}},g.prototype.reveal=function(a){this._emitCompleteOnItems("reveal",a);for(var b=a&&a.length,c=0;b&&b>c;c++){var d=a[c];d.reveal()}},g.prototype.hide=function(a){this._emitCompleteOnItems("hide",a);for(var b=a&&a.length,c=0;b&&b>c;c++){var d=a[c];d.hide()}},g.prototype.revealItemElements=function(a){var b=this.getItems(a);this.reveal(b)},g.prototype.hideItemElements=function(a){var b=this.getItems(a);this.hide(b)},g.prototype.getItem=function(a){for(var b=0,c=this.items.length;c>b;b++){var d=this.items[b];if(d.element===a)return d}},g.prototype.getItems=function(a){a=e.makeArray(a);for(var b=[],c=0,d=a.length;d>c;c++){var f=a[c],g=this.getItem(f);g&&b.push(g)}return b},g.prototype.remove=function(a){var b=this.getItems(a);if(this._emitCompleteOnItems("remove",b),b&&b.length)for(var c=0,d=b.length;d>c;c++){var f=b[c];f.remove(),e.removeFrom(this.items,f)}},g.prototype.destroy=function(){var a=this.element.style;a.height="",a.position="",a.width="";for(var b=0,c=this.items.length;c>b;b++){var d=this.items[b];d.destroy()}this.unbindResize();var e=this.element.outlayerGUID;delete l[e],delete this.element.outlayerGUID,i&&i.removeData(this.element,this.constructor.namespace)},g.data=function(a){a=e.getQueryElement(a);var b=a&&a.outlayerGUID;return b&&l[b]},g.create=function(a,b){function c(){g.apply(this,arguments)}return Object.create?c.prototype=Object.create(g.prototype):e.extend(c.prototype,g.prototype),c.prototype.constructor=c,c.defaults=e.extend({},g.defaults),e.extend(c.defaults,b),c.prototype.settings={},c.namespace=a,c.data=g.data,c.Item=function(){f.apply(this,arguments)},c.Item.prototype=new f,e.htmlInit(c,a),i&&i.bridget&&i.bridget(a,c),c},g.Item=f,g}),function(a,b){"function"==typeof define&&define.amd?define(["outlayer/outlayer","get-size/get-size","fizzy-ui-utils/utils"],b):"object"==typeof exports?module.exports=b(require("outlayer"),require("get-size"),require("fizzy-ui-utils")):a.Masonry=b(a.Outlayer,a.getSize,a.fizzyUIUtils)}(window,function(a,b,c){var d=a.create("masonry");return d.prototype._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns();var a=this.cols;for(this.colYs=[];a--;)this.colYs.push(0);this.maxY=0},d.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var a=this.items[0],c=a&&a.element;this.columnWidth=c&&b(c).outerWidth||this.containerWidth}var d=this.columnWidth+=this.gutter,e=this.containerWidth+this.gutter,f=e/d,g=d-e%d,h=g&&1>g?"round":"floor";f=Math[h](f),this.cols=Math.max(f,1)},d.prototype.getContainerWidth=function(){var a=this.options.isFitWidth?this.element.parentNode:this.element,c=b(a);this.containerWidth=c&&c.innerWidth},d.prototype._getItemLayoutPosition=function(a){a.getSize();var b=a.size.outerWidth%this.columnWidth,d=b&&1>b?"round":"ceil",e=Math[d](a.size.outerWidth/this.columnWidth);e=Math.min(e,this.cols);for(var f=this._getColGroup(e),g=Math.min.apply(Math,f),h=c.indexOf(f,g),i={x:this.columnWidth*h,y:g},j=g+a.size.outerHeight,k=this.cols+1-f.length,l=0;k>l;l++)this.colYs[h+l]=j;return i},d.prototype._getColGroup=function(a){if(2>a)return this.colYs;for(var b=[],c=this.cols+1-a,d=0;c>d;d++){var e=this.colYs.slice(d,d+a);b[d]=Math.max.apply(Math,e)}return b},d.prototype._manageStamp=function(a){var c=b(a),d=this._getElementOffset(a),e=this.options.isOriginLeft?d.left:d.right,f=e+c.outerWidth,g=Math.floor(e/this.columnWidth);g=Math.max(0,g);var h=Math.floor(f/this.columnWidth);h-=f%this.columnWidth?0:1,h=Math.min(this.cols-1,h);for(var i=(this.options.isOriginTop?d.top:d.bottom)+c.outerHeight,j=g;h>=j;j++)this.colYs[j]=Math.max(i,this.colYs[j])},d.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var a={height:this.maxY};return this.options.isFitWidth&&(a.width=this._getContainerFitWidth()),a},d.prototype._getContainerFitWidth=function(){for(var a=0,b=this.cols;--b&&0===this.colYs[b];)a++;return(this.cols-a)*this.columnWidth-this.gutter},d.prototype.needsResizeLayout=function(){var a=this.containerWidth;return this.getContainerWidth(),a!==this.containerWidth},d});


/* prettify 
https://code.google.com/p/google-code-prettify/
*/

!function(){var q=null;window.PR_SHOULD_USE_CONTINUATION=!0;(function(){function S(a){function d(e){var b=e.charCodeAt(0);if(b!==92)return b;var a=e.charAt(1);return(b=r[a])?b:"0"<=a&&a<="7"?parseInt(e.substring(1),8):a==="u"||a==="x"?parseInt(e.substring(2),16):e.charCodeAt(1)}function g(e){if(e<32)return(e<16?"\\x0":"\\x")+e.toString(16);e=String.fromCharCode(e);return e==="\\"||e==="-"||e==="]"||e==="^"?"\\"+e:e}function b(e){var b=e.substring(1,e.length-1).match(/\\u[\dA-Fa-f]{4}|\\x[\dA-Fa-f]{2}|\\[0-3][0-7]{0,2}|\\[0-7]{1,2}|\\[\S\s]|[^\\]/g),e=[],a=b[0]==="^",c=["["];a&&c.push("^");for(var a=a?1:0,f=b.length;a<f;++a){var h=b[a];if(/\\[bdsw]/i.test(h))c.push(h);else{var h=d(h),l;a+2<f&&"-"===b[a+1]?(l=d(b[a+2]),a+=2):l=h;e.push([h,l]);l<65||h>122||(l<65||h>90||e.push([Math.max(65,h)|32,Math.min(l,90)|32]),l<97||h>122||e.push([Math.max(97,h)&-33,Math.min(l,122)&-33]))}}e.sort(function(e,a){return e[0]-a[0]||a[1]-e[1]});b=[];f=[];for(a=0;a<e.length;++a)h=e[a],h[0]<=f[1]+1?f[1]=Math.max(f[1],h[1]):b.push(f=h);for(a=0;a<b.length;++a)h=b[a],c.push(g(h[0])),h[1]>h[0]&&(h[1]+1>h[0]&&c.push("-"),c.push(g(h[1])));c.push("]");return c.join("")}function s(e){for(var a=e.source.match(/\[(?:[^\\\]]|\\[\S\s])*]|\\u[\dA-Fa-f]{4}|\\x[\dA-Fa-f]{2}|\\\d+|\\[^\dux]|\(\?[!:=]|[()^]|[^()[\\^]+/g),c=a.length,d=[],f=0,h=0;f<c;++f){var l=a[f];l==="("?++h:"\\"===l.charAt(0)&&(l=+l.substring(1))&&(l<=h?d[l]=-1:a[f]=g(l))}for(f=1;f<d.length;++f)-1===d[f]&&(d[f]=++x);for(h=f=0;f<c;++f)l=a[f],l==="("?(++h,d[h]||(a[f]="(?:")):"\\"===l.charAt(0)&&(l=+l.substring(1))&&l<=h&&(a[f]="\\"+d[l]);for(f=0;f<c;++f)"^"===a[f]&&"^"!==a[f+1]&&(a[f]="");if(e.ignoreCase&&m)for(f=0;f<c;++f)l=a[f],e=l.charAt(0),l.length>=2&&e==="["?a[f]=b(l):e!=="\\"&&(a[f]=l.replace(/[A-Za-z]/g,function(a){a=a.charCodeAt(0);return"["+String.fromCharCode(a&-33,a|32)+"]"}));return a.join("")}for(var x=0,m=!1,j=!1,k=0,c=a.length;k<c;++k){var i=a[k];if(i.ignoreCase)j=!0;else if(/[a-z]/i.test(i.source.replace(/\\u[\da-f]{4}|\\x[\da-f]{2}|\\[^UXux]/gi,""))){m=!0;j=!1;break}}for(var r={b:8,t:9,n:10,v:11,f:12,r:13},n=[],k=0,c=a.length;k<c;++k){i=a[k];if(i.global||i.multiline)throw Error(""+i);n.push("(?:"+s(i)+")")}return RegExp(n.join("|"),j?"gi":"g")}function T(a,d){function g(a){var c=a.nodeType;if(c==1){if(!b.test(a.className)){for(c=a.firstChild;c;c=c.nextSibling)g(c);c=a.nodeName.toLowerCase();if("br"===c||"li"===c)s[j]="\n",m[j<<1]=x++,m[j++<<1|1]=a}}else if(c==3||c==4)c=a.nodeValue,c.length&&(c=d?c.replace(/\r\n?/g,"\n"):c.replace(/[\t\n\r ]+/g," "),s[j]=c,m[j<<1]=x,x+=c.length,m[j++<<1|1]=a)}var b=/(?:^|\s)nocode(?:\s|$)/,s=[],x=0,m=[],j=0;g(a);return{a:s.join("").replace(/\n$/,""),d:m}}function H(a,d,g,b){d&&(a={a:d,e:a},g(a),b.push.apply(b,a.g))}function U(a){for(var d=void 0,g=a.firstChild;g;g=g.nextSibling)var b=g.nodeType,d=b===1?d?a:g:b===3?V.test(g.nodeValue)?a:d:d;return d===a?void 0:d}function C(a,d){function g(a){for(var j=a.e,k=[j,"pln"],c=0,i=a.a.match(s)||[],r={},n=0,e=i.length;n<e;++n){var z=i[n],w=r[z],t=void 0,f;if(typeof w==="string")f=!1;else{var h=b[z.charAt(0)];if(h)t=z.match(h[1]),w=h[0];else{for(f=0;f<x;++f)if(h=d[f],t=z.match(h[1])){w=h[0];break}t||(w="pln")}if((f=w.length>=5&&"lang-"===w.substring(0,5))&&!(t&&typeof t[1]==="string"))f=!1,w="src";f||(r[z]=w)}h=c;c+=z.length;if(f){f=t[1];var l=z.indexOf(f),B=l+f.length;t[2]&&(B=z.length-t[2].length,l=B-f.length);w=w.substring(5);H(j+h,z.substring(0,l),g,k);H(j+h+l,f,I(w,f),k);H(j+h+B,z.substring(B),g,k)}else k.push(j+h,w)}a.g=k}var b={},s;(function(){for(var g=a.concat(d),j=[],k={},c=0,i=g.length;c<i;++c){var r=g[c],n=r[3];if(n)for(var e=n.length;--e>=0;)b[n.charAt(e)]=r;r=r[1];n=""+r;k.hasOwnProperty(n)||(j.push(r),k[n]=q)}j.push(/[\S\s]/);s=S(j)})();var x=d.length;return g}function v(a){var d=[],g=[];a.tripleQuotedStrings?d.push(["str",/^(?:'''(?:[^'\\]|\\[\S\s]|''?(?=[^']))*(?:'''|$)|"""(?:[^"\\]|\\[\S\s]|""?(?=[^"]))*(?:"""|$)|'(?:[^'\\]|\\[\S\s])*(?:'|$)|"(?:[^"\\]|\\[\S\s])*(?:"|$))/,q,"'\""]):a.multiLineStrings?d.push(["str",/^(?:'(?:[^'\\]|\\[\S\s])*(?:'|$)|"(?:[^"\\]|\\[\S\s])*(?:"|$)|`(?:[^\\`]|\\[\S\s])*(?:`|$))/,q,"'\"`"]):d.push(["str",/^(?:'(?:[^\n\r'\\]|\\.)*(?:'|$)|"(?:[^\n\r"\\]|\\.)*(?:"|$))/,q,"\"'"]);a.verbatimStrings&&g.push(["str",/^@"(?:[^"]|"")*(?:"|$)/,q]);var b=a.hashComments;b&&(a.cStyleComments?(b>1?d.push(["com",/^#(?:##(?:[^#]|#(?!##))*(?:###|$)|.*)/,q,"#"]):d.push(["com",/^#(?:(?:define|e(?:l|nd)if|else|error|ifn?def|include|line|pragma|undef|warning)\b|[^\n\r]*)/,q,"#"]),g.push(["str",/^<(?:(?:(?:\.\.\/)*|\/?)(?:[\w-]+(?:\/[\w-]+)+)?[\w-]+\.h(?:h|pp|\+\+)?|[a-z]\w*)>/,q])):d.push(["com",/^#[^\n\r]*/,q,"#"]));a.cStyleComments&&(g.push(["com",/^\/\/[^\n\r]*/,q]),g.push(["com",/^\/\*[\S\s]*?(?:\*\/|$)/,q]));if(b=a.regexLiterals){var s=(b=b>1?"":"\n\r")?".":"[\\S\\s]";g.push(["lang-regex",RegExp("^(?:^^\\.?|[+-]|[!=]=?=?|\\#|%=?|&&?=?|\\(|\\*=?|[+\\-]=|->|\\/=?|::?|<<?=?|>>?>?=?|,|;|\\?|@|\\[|~|{|\\^\\^?=?|\\|\\|?=?|break|case|continue|delete|do|else|finally|instanceof|return|throw|try|typeof)\\s*("+("/(?=[^/*"+b+"])(?:[^/\\x5B\\x5C"+b+"]|\\x5C"+s+"|\\x5B(?:[^\\x5C\\x5D"+b+"]|\\x5C"+s+")*(?:\\x5D|$))+/")+")")])}(b=a.types)&&g.push(["typ",b]);b=(""+a.keywords).replace(/^ | $/g,"");b.length&&g.push(["kwd",RegExp("^(?:"+b.replace(/[\s,]+/g,"|")+")\\b"),q]);d.push(["pln",/^\s+/,q," \r\n\t\u00a0"]);b="^.[^\\s\\w.$@'\"`/\\\\]*";a.regexLiterals&&(b+="(?!s*/)");g.push(["lit",/^@[$_a-z][\w$@]*/i,q],["typ",/^(?:[@_]?[A-Z]+[a-z][\w$@]*|\w+_t\b)/,q],["pln",/^[$_a-z][\w$@]*/i,q],["lit",/^(?:0x[\da-f]+|(?:\d(?:_\d+)*\d*(?:\.\d*)?|\.\d\+)(?:e[+-]?\d+)?)[a-z]*/i,q,"0123456789"],["pln",/^\\[\S\s]?/,q],["pun",RegExp(b),q]);return C(d,g)}function J(a,d,g){function b(a){var c=a.nodeType;if(c==1&&!x.test(a.className))if("br"===a.nodeName)s(a),a.parentNode&&a.parentNode.removeChild(a);else for(a=a.firstChild;a;a=a.nextSibling)b(a);else if((c==3||c==4)&&g){var d=a.nodeValue,i=d.match(m);if(i)c=d.substring(0,i.index),a.nodeValue=c,(d=d.substring(i.index+i[0].length))&&a.parentNode.insertBefore(j.createTextNode(d),a.nextSibling),s(a),c||a.parentNode.removeChild(a)}}function s(a){function b(a,c){var d=c?a.cloneNode(!1):a,e=a.parentNode;if(e){var e=b(e,1),g=a.nextSibling;e.appendChild(d);for(var i=g;i;i=g)g=i.nextSibling,e.appendChild(i)}return d}for(;!a.nextSibling;)if(a=a.parentNode,!a)return;for(var a=b(a.nextSibling,0),d;(d=a.parentNode)&&d.nodeType===1;)a=d;c.push(a)}for(var x=/(?:^|\s)nocode(?:\s|$)/,m=/\r\n?|\n/,j=a.ownerDocument,k=j.createElement("li");a.firstChild;)k.appendChild(a.firstChild);for(var c=[k],i=0;i<c.length;++i)b(c[i]);d===(d|0)&&c[0].setAttribute("value",d);var r=j.createElement("ol");r.className="linenums";for(var d=Math.max(0,d-1|0)||0,i=0,n=c.length;i<n;++i)k=c[i],k.className="L"+(i+d)%10,k.firstChild||k.appendChild(j.createTextNode("\u00a0")),r.appendChild(k);a.appendChild(r)}function p(a,d){for(var g=d.length;--g>=0;){var b=d[g];F.hasOwnProperty(b)?D.console&&console.warn("cannot override language handler %s",b):F[b]=a}}function I(a,d){if(!a||!F.hasOwnProperty(a))a=/^\s*</.test(d)?"default-markup":"default-code";return F[a]}function K(a){var d=a.h;try{var g=T(a.c,a.i),b=g.a;a.a=b;a.d=g.d;a.e=0;I(d,b)(a);var s=/\bMSIE\s(\d+)/.exec(navigator.userAgent),s=s&&+s[1]<=8,d=/\n/g,x=a.a,m=x.length,g=0,j=a.d,k=j.length,b=0,c=a.g,i=c.length,r=0;c[i]=m;var n,e;for(e=n=0;e<i;)c[e]!==c[e+2]?(c[n++]=c[e++],c[n++]=c[e++]):e+=2;i=n;for(e=n=0;e<i;){for(var p=c[e],w=c[e+1],t=e+2;t+2<=i&&c[t+1]===w;)t+=2;c[n++]=p;c[n++]=w;e=t}c.length=n;var f=a.c,h;if(f)h=f.style.display,f.style.display="none";try{for(;b<k;){var l=j[b+2]||m,B=c[r+2]||m,t=Math.min(l,B),A=j[b+1],G;if(A.nodeType!==1&&(G=x.substring(g,t))){s&&(G=G.replace(d,"\r"));A.nodeValue=G;var L=A.ownerDocument,o=L.createElement("span");o.className=c[r+1];var v=A.parentNode;v.replaceChild(o,A);o.appendChild(A);g<l&&(j[b+1]=A=L.createTextNode(x.substring(t,l)),v.insertBefore(A,o.nextSibling))}g=t;g>=l&&(b+=2);g>=B&&(r+=2)}}finally{if(f)f.style.display=h}}catch(u){D.console&&console.log(u&&u.stack||u)}}var D=window,y=["break,continue,do,else,for,if,return,while"],E=[[y,"auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile"],"catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof"],M=[E,"alignof,align_union,asm,axiom,bool,concept,concept_map,const_cast,constexpr,decltype,delegate,dynamic_cast,explicit,export,friend,generic,late_check,mutable,namespace,nullptr,property,reinterpret_cast,static_assert,static_cast,template,typeid,typename,using,virtual,where"],N=[E,"abstract,assert,boolean,byte,extends,final,finally,implements,import,instanceof,interface,null,native,package,strictfp,super,synchronized,throws,transient"],O=[N,"as,base,by,checked,decimal,delegate,descending,dynamic,event,fixed,foreach,from,group,implicit,in,internal,into,is,let,lock,object,out,override,orderby,params,partial,readonly,ref,sbyte,sealed,stackalloc,string,select,uint,ulong,unchecked,unsafe,ushort,var,virtual,where"],E=[E,"debugger,eval,export,function,get,null,set,undefined,var,with,Infinity,NaN"],P=[y,"and,as,assert,class,def,del,elif,except,exec,finally,from,global,import,in,is,lambda,nonlocal,not,or,pass,print,raise,try,with,yield,False,True,None"],Q=[y,"alias,and,begin,case,class,def,defined,elsif,end,ensure,false,in,module,next,nil,not,or,redo,rescue,retry,self,super,then,true,undef,unless,until,when,yield,BEGIN,END"],W=[y,"as,assert,const,copy,drop,enum,extern,fail,false,fn,impl,let,log,loop,match,mod,move,mut,priv,pub,pure,ref,self,static,struct,true,trait,type,unsafe,use"],y=[y,"case,done,elif,esac,eval,fi,function,in,local,set,then,until"],R=/^(DIR|FILE|vector|(de|priority_)?queue|list|stack|(const_)?iterator|(multi)?(set|map)|bitset|u?(int|float)\d*)\b/,V=/\S/,X=v({keywords:[M,O,E,"caller,delete,die,do,dump,elsif,eval,exit,foreach,for,goto,if,import,last,local,my,next,no,our,print,package,redo,require,sub,undef,unless,until,use,wantarray,while,BEGIN,END",P,Q,y],hashComments:!0,cStyleComments:!0,multiLineStrings:!0,regexLiterals:!0}),F={};p(X,["default-code"]);p(C([],[["pln",/^[^<?]+/],["dec",/^<!\w[^>]*(?:>|$)/],["com",/^<\!--[\S\s]*?(?:--\>|$)/],["lang-",/^<\?([\S\s]+?)(?:\?>|$)/],["lang-",/^<%([\S\s]+?)(?:%>|$)/],["pun",/^(?:<[%?]|[%?]>)/],["lang-",/^<xmp\b[^>]*>([\S\s]+?)<\/xmp\b[^>]*>/i],["lang-js",/^<script\b[^>]*>([\S\s]*?)(<\/script\b[^>]*>)/i],["lang-css",/^<style\b[^>]*>([\S\s]*?)(<\/style\b[^>]*>)/i],["lang-in.tag",/^(<\/?[a-z][^<>]*>)/i]]),["default-markup","htm","html","mxml","xhtml","xml","xsl"]);p(C([["pln",/^\s+/,q," \t\r\n"],["atv",/^(?:"[^"]*"?|'[^']*'?)/,q,"\"'"]],[["tag",/^^<\/?[a-z](?:[\w-.:]*\w)?|\/?>$/i],["atn",/^(?!style[\s=]|on)[a-z](?:[\w:-]*\w)?/i],["lang-uq.val",/^=\s*([^\s"'>]*(?:[^\s"'/>]|\/(?=\s)))/],["pun",/^[/<->]+/],["lang-js",/^on\w+\s*=\s*"([^"]+)"/i],["lang-js",/^on\w+\s*=\s*'([^']+)'/i],["lang-js",/^on\w+\s*=\s*([^\s"'>]+)/i],["lang-css",/^style\s*=\s*"([^"]+)"/i],["lang-css",/^style\s*=\s*'([^']+)'/i],["lang-css",/^style\s*=\s*([^\s"'>]+)/i]]),["in.tag"]);p(C([],[["atv",/^[\S\s]+/]]),["uq.val"]);p(v({keywords:M,hashComments:!0,cStyleComments:!0,types:R}),["c","cc","cpp","cxx","cyc","m"]);p(v({keywords:"null,true,false"}),["json"]);p(v({keywords:O,hashComments:!0,cStyleComments:!0,verbatimStrings:!0,types:R}),["cs"]);p(v({keywords:N,cStyleComments:!0}),["java"]);p(v({keywords:y,hashComments:!0,multiLineStrings:!0}),["bash","bsh","csh","sh"]);p(v({keywords:P,hashComments:!0,multiLineStrings:!0,tripleQuotedStrings:!0}),["cv","py","python"]);p(v({keywords:"caller,delete,die,do,dump,elsif,eval,exit,foreach,for,goto,if,import,last,local,my,next,no,our,print,package,redo,require,sub,undef,unless,until,use,wantarray,while,BEGIN,END",hashComments:!0,multiLineStrings:!0,regexLiterals:2}),["perl","pl","pm"]);p(v({keywords:Q,hashComments:!0,multiLineStrings:!0,regexLiterals:!0}),["rb","ruby"]);p(v({keywords:E,cStyleComments:!0,regexLiterals:!0}),["javascript","js"]);p(v({keywords:"all,and,by,catch,class,else,extends,false,finally,for,if,in,is,isnt,loop,new,no,not,null,of,off,on,or,return,super,then,throw,true,try,unless,until,when,while,yes",hashComments:3,cStyleComments:!0,multilineStrings:!0,tripleQuotedStrings:!0,regexLiterals:!0}),["coffee"]);p(v({keywords:W,cStyleComments:!0,multilineStrings:!0}),["rc","rs","rust"]);p(C([],[["str",/^[\S\s]+/]]),["regex"]);var Y=D.PR={createSimpleLexer:C,registerLangHandler:p,sourceDecorator:v,PR_ATTRIB_NAME:"atn",PR_ATTRIB_VALUE:"atv",PR_COMMENT:"com",PR_DECLARATION:"dec",PR_KEYWORD:"kwd",PR_LITERAL:"lit",PR_NOCODE:"nocode",PR_PLAIN:"pln",PR_PUNCTUATION:"pun",PR_SOURCE:"src",PR_STRING:"str",PR_TAG:"tag",PR_TYPE:"typ",prettyPrintOne:D.prettyPrintOne=function(a,d,g){var b=document.createElement("div");b.innerHTML="<pre>"+a+"</pre>";b=b.firstChild;g&&J(b,g,!0);K({h:d,j:g,c:b,i:1});return b.innerHTML},prettyPrint:D.prettyPrint=function(a,d){function g(){for(var b=D.PR_SHOULD_USE_CONTINUATION?c.now()+250:Infinity;i<p.length&&c.now()<b;i++){for(var d=p[i],j=h,k=d;k=k.previousSibling;){var m=k.nodeType,o=(m===7||m===8)&&k.nodeValue;if(o?!/^\??prettify\b/.test(o):m!==3||/\S/.test(k.nodeValue))break;if(o){j={};o.replace(/\b(\w+)=([\w%+\-.:]+)/g,function(a,b,c){j[b]=c});break}}k=d.className;if((j!==h||e.test(k))&&!v.test(k)){m=!1;for(o=d.parentNode;o;o=o.parentNode)if(f.test(o.tagName)&&o.className&&e.test(o.className)){m=!0;break}if(!m){d.className+=" prettyprinted";m=j.lang;if(!m){var m=k.match(n),y;if(!m&&(y=U(d))&&t.test(y.tagName))m=y.className.match(n);m&&(m=m[1])}if(w.test(d.tagName))o=1;else var o=d.currentStyle,u=s.defaultView,o=(o=o?o.whiteSpace:u&&u.getComputedStyle?u.getComputedStyle(d,q).getPropertyValue("white-space"):0)&&"pre"===o.substring(0,3);u=j.linenums;if(!(u=u==="true"||+u))u=(u=k.match(/\blinenums\b(?::(\d+))?/))?u[1]&&u[1].length?+u[1]:!0:!1;u&&J(d,u,o);r={h:m,c:d,j:u,i:o};K(r)}}}i<p.length?setTimeout(g,250):"function"===typeof a&&a()}for(var b=d||document.body,s=b.ownerDocument||document,b=[b.getElementsByTagName("pre"),b.getElementsByTagName("code"),b.getElementsByTagName("xmp")],p=[],m=0;m<b.length;++m)for(var j=0,k=b[m].length;j<k;++j)p.push(b[m][j]);var b=q,c=Date;c.now||(c={now:function(){return+new Date}});var i=0,r,n=/\blang(?:uage)?-([\w.]+)(?!\S)/,e=/\bprettyprint\b/,v=/\bprettyprinted\b/,w=/pre|xmp/i,t=/^code$/i,f=/^(?:pre|code|xmp)$/i,h={};g()}};typeof define==="function"&&define.amd&&define("google-code-prettify",[],function(){return Y})})();}()
