<?php


/**
	ab-tweet-scroller plugin support
**/
if( in_array('ab-tweet-scroller/ab-tweet-scroller.php', get_option('active_plugins')) ){ //first check if plugin is installed
	$tcvpb_elements['ab_tweet_scroller'] = array(
		'name' => esc_html__('AB Tweet Scroller', 'ABdev_dzen' ),
		'description' => esc_html__('AB Tweet Scroller', 'ABdev_dzen'),
		'type' => 'block',
		'icon' => 'pi-tweet',
		'category' =>  esc_html__('Social', 'ABdev_dzen'),
		'third_party' => 1,
		'attributes' => array(
			'user' => array(
				'description' => esc_html__('User', 'ABdev_dzen'),
				'info' => esc_html__('Displays different user than the one specified in API settings', 'ABdev_dzen'),
			),
			'limit' => array(
				'description' => esc_html__('Limit', 'ABdev_dzen'),
				'info' => esc_html__('Number of tweets to show', 'ABdev_dzen'),
				'default' => '5',
			),
			'link_target' => array(
				'description' => esc_html__('External Link Target', 'ABdev_dzen'),
				'default' => '_blank',
				'type' => 'select',
				'values' => array(
					'_blank' => esc_html__('Blank', 'ABdev_dzen'),
					'_self' =>  esc_html__('Self', 'ABdev_dzen'),
				),
				'divider' => 'true',
			),
			'hide_image' => array(
				'default' => '0',
				'type' => 'checkbox',
				'description' => esc_html__('Hide Image', 'ABdev_dzen'),
			),
			'hide_reply' => array(
				'default' => '0',
				'type' => 'checkbox',
				'description' => esc_html__('Hide Reply Link', 'ABdev_dzen'),
			),
			'hide_retweet' => array(
				'default' => '0',
				'type' => 'checkbox',
				'description' => esc_html__('Hide Retweet Link', 'ABdev_dzen'),
			),
			'hide_favorite' => array(
				'default' => '0',
				'type' => 'checkbox',
				'description' => esc_html__('Hide Favorite Link', 'ABdev_dzen'),
				'divider' => 'true',
			),
			'date_format' => array(
				'description' => esc_html__('Date Format', 'ABdev_dzen'),
				'info' => esc_html__('Specifies date format to be used, or to hide the date. Possible values are human, hide or PHP date format string', 'ABdev_dzen'),
				'default' => 'human',
			),
			'show_arrows' => array(
				'default' => '1',
				'type' => 'checkbox',
				'description' => esc_html__('Show Arrows', 'ABdev_dzen'),
			),
			'fx' => array(
				'description' => esc_html__('Effect', 'ABdev_dzen'),
				'default' => 'fade',
				'type' => 'select',
				'values' => array(
					'none' => esc_html__('none', 'ABdev_dzen'),
					'scroll' =>  esc_html__('scroll', 'ABdev_dzen'),
					'fade' =>  esc_html__('fade', 'ABdev_dzen'),
					'crossfade' =>  esc_html__('crossfade', 'ABdev_dzen'),
					'cover-fade' =>  esc_html__('cover-fade', 'ABdev_dzen'),
					'uncover-fade' =>  esc_html__('uncover-fade', 'ABdev_dzen'),
				),
				'tab' => esc_html__('Animation', 'ABdev_dzen'),
			),
			'easing' => array(
				'description' => esc_html__('Easing', 'ABdev_dzen'),
				'default' => 'swing',
				'type' => 'select',
				'values' => array(
					'linear' => esc_html__('linear', 'ABdev_dzen'),
					'swing' =>  esc_html__('swing', 'ABdev_dzen'),
					'cubic' =>  esc_html__('cubic', 'ABdev_dzen'),
					'elastic' =>  esc_html__('elastic', 'ABdev_dzen'),
				),
				'tab' => esc_html__('Animation', 'ABdev_dzen'),
			),
			'duration' => array(
				'description' => esc_html__('Transition Duration', 'ABdev_dzen'),
				'info' => esc_html__('Duration of transition in seconds', 'ABdev_dzen'),
				'default' => '1000',
				'tab' => esc_html__('Animation', 'ABdev_dzen'),
			),
			'pauseonhover' => array(
				'description' => esc_html__('Pause on Hover', 'ABdev_dzen'),
				'default' => 'immediate',
				'type' => 'select',
				'values' => array(
					'false' => esc_html__('false', 'ABdev_dzen'),
					'resume' =>  esc_html__('resume', 'ABdev_dzen'),
					'immediate' =>  esc_html__('immediate', 'ABdev_dzen'),
				),
				'tab' => esc_html__('Animation', 'ABdev_dzen'),
			),
			'timeoutduration' => array(
				'description' => esc_html__('Transition Duration', 'ABdev_dzen'),
				'info' => esc_html__('How long is each slide displayed, in seconds', 'ABdev_dzen'),
				'default' => '5000',
				'tab' => esc_html__('Animation', 'ABdev_dzen'),
			),
			'play' => array(
				'default' => '1',
				'type' => 'checkbox',
				'description' => esc_html__('Autoplay', 'ABdev_dzen'),
				'tab' => esc_html__('Animation', 'ABdev_dzen'),
			),
			'class' => array(
				'description' => esc_html__('Class', 'ABdev_dzen'),
				'info' => esc_html__('Additional custom classes for custom styling', 'ABdev_dzen'),
				'tab' => esc_html__('Advanced', 'ABdev_dzen'),
			),
		),
	);
}