<?php

/*********** Shortcode: Image Hotspots ************************************************************/

$tcvpb_elements['image_hotspots_tc'] = array(
	'name' => esc_html__('Image Hotspots', 'ABdev_dzen' ),
	'type' => 'block',
	'icon' => 'pi-image-hotspots',
	'category' => esc_html__('Media', 'ABdev_dzen' ),
	'child' => 'image_hotspot_tc',
	'child_button' => esc_html__('New Hotspot', 'ABdev_dzen'),
	'child_title' => esc_html__('Hotspot', 'ABdev_dzen'),
	'attributes' => array(
		'url' => array(
			'type' => 'image',
			'description' => esc_html__('Select Image', 'ABdev_dzen'),
		),
		'animation' => array(
			'default' => 'none',
			'description' => esc_html__('Entrance Animation', 'ABdev_dzen'),
			'type' => 'select',
			'values' => array(
				'' => esc_html__('None', 'ABdev_dzen'),
				'flip' => esc_html__('Flip', 'ABdev_dzen'),
				'flipInX' => esc_html__('Flip In X', 'ABdev_dzen'),
				'flipInY' => esc_html__('Flip In Y', 'ABdev_dzen'),
				'fadeIn' => esc_html__('Fade In', 'ABdev_dzen'),
				'fadeInUp' => esc_html__('Fade In Up', 'ABdev_dzen'),
				'fadeInDown' => esc_html__('Fade In Down', 'ABdev_dzen'),
				'fadeInLeft' => esc_html__('Fade In Left', 'ABdev_dzen'),
				'fadeInRight' => esc_html__('Fade In Right', 'ABdev_dzen'),
				'fadeInUpBig' => esc_html__('Fade In Up Big', 'ABdev_dzen'),
				'fadeInDownBig' => esc_html__('Fade In Down Big', 'ABdev_dzen'),
				'fadeInLeftBig' => esc_html__('Fade In Left Big', 'ABdev_dzen'),
				'fadeInRightBig' => esc_html__('Fade In Right Big', 'ABdev_dzen'),
				'slideInLeft' => esc_html__('Slide In Left', 'ABdev_dzen'),
				'slideInRight' => esc_html__('Slide In Right', 'ABdev_dzen'),
				'bounceIn' => esc_html__('Bounce In', 'ABdev_dzen'),
				'bounceInDown' => esc_html__('Bounce In Down', 'ABdev_dzen'),
				'bounceInUp' => esc_html__('Bounce In Up', 'ABdev_dzen'),
				'bounceInLeft' => esc_html__('Bounce In Left', 'ABdev_dzen'),
				'bounceInRight' => esc_html__('Bounce In Right', 'ABdev_dzen'),
				'rotateIn' => esc_html__('Rotate In', 'ABdev_dzen'),
				'rotateInDownLeft' => esc_html__('Rotate In Down Left', 'ABdev_dzen'),
				'rotateInDownRight' => esc_html__('Rotate In Down Right', 'ABdev_dzen'),
				'rotateInUpLeft' => esc_html__('Rotate In Up Left', 'ABdev_dzen'),
				'rotateInUpRight' => esc_html__('Rotate In Up Right', 'ABdev_dzen'),
				'lightSpeedIn' => esc_html__('Light Speed In', 'ABdev_dzen'),
				'rollIn' => esc_html__('Roll In', 'ABdev_dzen'),
				'flash' => esc_html__('Flash', 'ABdev_dzen'),
				'bounce' => esc_html__('Bounce', 'ABdev_dzen'),
				'shake' => esc_html__('Shake', 'ABdev_dzen'),
				'tada' => esc_html__('Tada', 'ABdev_dzen'),
				'swing' => esc_html__('Swing', 'ABdev_dzen'),
				'wobble' => esc_html__('Wobble', 'ABdev_dzen'),
				'pulse' => esc_html__('Pulse', 'ABdev_dzen'),
			),
			'tab' => esc_html__('Animation', 'ABdev_dzen'),
		),
		'timing' => array(
			'default' => 'linear',
			'description' => esc_html__('Timing Function', 'ABdev_dzen'),
			'type' => 'select',
			'values' => array(
				'linear' => esc_html__('Linear', 'ABdev_dzen'),
				'ease' => esc_html__('Ease', 'ABdev_dzen'),
				'ease-in' => esc_html__('Ease-in', 'ABdev_dzen'),
				'ease-out' => esc_html__('Ease-out', 'ABdev_dzen'),
				'ease-in-out' => esc_html__('Ease-in-out', 'ABdev_dzen'),
			),
			'tab' => esc_html__('Animation', 'ABdev_dzen'),
		),
		'trigger_pt' => array(
			'description' => esc_html__('Trigger Point (in px)', 'ABdev_dzen'),
			'info' => esc_html__('Amount of pixels from bottom to start animation', 'ABdev_dzen'),
			'default' => '0',
			'tab' => esc_html__('Animation', 'ABdev_dzen'),
		),
		'duration' => array(
			'description' => esc_html__('Animation Duration (in ms)', 'ABdev_dzen'),
			'default' => '1000',
			'tab' => esc_html__('Animation', 'ABdev_dzen'),
		),
		'delay' => array(
			'description' => esc_html__('Animation Delay (in ms)', 'ABdev_dzen'),
			'default' => '0',
			'tab' => esc_html__('Animation', 'ABdev_dzen'),
		),
		'id' => array(
			'description' => esc_html__('ID', 'ABdev_dzen'),
			'info' => esc_html__('Additional custom ID', 'ABdev_dzen'),
			'tab' => esc_html__('Advanced', 'ABdev_dzen'),
		),
		'class' => array(
			'description' => esc_html__('Class', 'ABdev_dzen'),
			'info' => esc_html__('Additional custom classes for custom styling', 'ABdev_dzen'),
			'tab' => esc_html__('Advanced', 'ABdev_dzen'),
		),
	),
);
function tcvpb_image_hotspots_tc_shortcode( $attributes, $content = null ) {
	extract(shortcode_atts(tcvpb_extract_attributes('image_hotspots_tc'), $attributes));
	$id_out = ($id!='') ? 'id='.$id.'' : '';

	$classes=array();
	$animation_out='';

	if($animation!=''){
		$classes[] = 'tcvpb-animo';
		$duration = ($duration!='') ? $duration : '1000';
		$animation_out = 'data-animation="'.esc_attr($animation).'" data-trigger_pt="'.esc_attr($trigger_pt).'" data-duration="'.esc_attr($duration).'" data-delay="'.esc_attr($delay).'"';
	}

	if($class!=''){
		$classes[] = $class;
	}

	$classes = implode(' ', $classes);

	return '<div '.esc_attr($id_out).' class="'.esc_attr($classes).'" '.$animation_out.' style="position:relative;"><img src="'.esc_url($url).'">'.  do_shortcode($content)  . '</div>';
}

$tcvpb_elements['image_hotspot_tc'] = array(
	'name' => esc_html__('Single hotspot section', 'ABdev_dzen' ),
	'type' => 'child',
	'attributes' => array(
		'top' => array(
			'description' => esc_html__('Vertical Position (%)', 'ABdev_dzen'),
		),
		'left' => array(
			'description' => esc_html__('Horizontal Position (%)', 'ABdev_dzen'),
		),
		'number' => array(
			'description' => esc_html__('Number in Hotspot', 'ABdev_dzen'),
		),
		'icon' => array(
			'description' => esc_html__('Icon in Hotspot', 'ABdev_dzen'),
			'type' => 'icon',
		),
		'color' => array(
			'description' => esc_html__('Icon or Text Color', 'ABdev_dzen'),
			'type' => 'color',
		),
		'effect' => array(
			'default' => '',
			'description' => esc_html__('Select Hotspot Effect', 'ABdev_dzen'),
			'type' => 'select',
			'values' => array(
				'' => esc_html__('None', 'ABdev_dzen'),
				'pulse' => esc_html__('Pulse', 'ABdev_dzen'),
				'grow' => esc_html__('Grow', 'ABdev_dzen'),
			),
		),
		'hotspot_background' => array(
			'description' => esc_html__('Hotspot Background', 'ABdev_dzen'),
			'type' => 'coloralpha',
		),
		'pulse_background' => array(
			'description' => esc_html__('Effect Background', 'ABdev_dzen'),
			'type' => 'coloralpha',
		),
		'gravity' => array(
			'default' => 's',
			'description' => esc_html__('Tooltip Position', 'ABdev_dzen'),
			'type' => 'select',
			'values' => array(
				'n' => esc_html__('Top', 'ABdev_dzen'),
				's' => esc_html__('Bottom', 'ABdev_dzen'),
				'e' => esc_html__('Left', 'ABdev_dzen'),
				'w' => esc_html__('Right', 'ABdev_dzen'),
			),
		),
		'tooltip_content' => array(
			'description' => esc_html__('Tooltip Content', 'ABdev_dzen'),
		),
	),
);
function tcvpb_image_hotspot_tc_shortcode( $attributes, $content = null ) {
	extract(shortcode_atts(tcvpb_extract_attributes('image_hotspot_tc'), $attributes));

	$icon_out = ($icon !='') ? '<i class="'.esc_attr($icon).'"></i>' : '';
	$number_out = ($number !='') ? '<span>'.esc_attr($number).'</span>' :'';
	$color = ($color!='') ? 'color: '.esc_attr($color).';' : '';
	$hotspot_background = ($hotspot_background!='') ? 'background:'.esc_attr($hotspot_background).';' : '';
	$pulse_background = ($pulse_background!='') ? 'background:'.esc_attr($pulse_background).';' : '';

	$return = '
		<div class="tcvpb-hotspot-body" style="position:absolute; top:'.esc_attr($top).'%; left:'.esc_attr($left).'%;">
			<a class="tcvpb-hotspot-tooltip" style="'.esc_attr($hotspot_background.$color).'" title="'.esc_attr($tooltip_content).'" data-gravity="'.esc_attr($gravity).'">
				'.$icon_out.'
				'.$number_out.'
			</a>
			<div class="tcvpb-hotspot-'.esc_attr($effect).'" style="'.esc_attr($pulse_background).'"></div>
		</div>';

	return $return;
}