<?php

require_once 'custom_controls.php';
require_once 'import_redux_options.php';

function dzen_customize_register( $wp_customize ) {

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';


	/**
	------------------------------------------------------------
	SECTION: General
	------------------------------------------------------------
	**/
	$wp_customize->add_section('section_general', array(
		'title'		=> esc_html__('General', 'ABdev_dzen'),
		'priority'	=> 0,
	));

		/**
		Disable Responsiveness
		**/
		$wp_customize->add_setting('disable_responsiveness', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'disable_responsiveness', array(
			'label'    => esc_html__('Disable Responsiveness', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Google Map API Key
		**/
		$wp_customize->add_setting('google_maps_api_key', array(
			'default'     => '',
		));
		$wp_customize->add_control('google_maps_api_key', array(
			'label'    => esc_html__('Google Map API Key', 'ABdev_dzen'),
			'description'    => esc_html__('For more details please check ', 'ABdev_dzen'). '<a href="'.esc_url('https://developers.google.com/maps/documentation/javascript/get-api-key').'" target="_blank">'.esc_html__( 'Google Maps API v3', 'ABdev_dzen' ).'</a>' . esc_html__(' documentation.', 'ABdev_dzen'),
			'type'     => 'text',
			'section'  => 'section_general',
		));

		/**
		Hide Comments
		**/
		$wp_customize->add_setting('hide_comments', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'hide_comments', array(
			'label'    => esc_html__('Hide Comments', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Hide Author Bio
		**/
		$wp_customize->add_setting('hide_author_bio', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'hide_author_bio', array(
			'label'    => esc_html__('Hide Author Bio', 'ABdev_dzen'),
			'description'   => esc_html__('Use this to hide author biography under post content', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Hide Related Posts
		**/
		$wp_customize->add_setting('hide_related', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'hide_related', array(
			'label'    => esc_html__('Hide Related Posts', 'ABdev_dzen'),
			'description'   => esc_html__('Use this to hide related posts under post content', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Use Preloader
		**/
		$wp_customize->add_setting('enable_preloader', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'enable_preloader', array(
			'label'    => esc_html__('Use Preloader', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Boxed Body
		**/
		$wp_customize->add_setting('boxed_body', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'boxed_body', array(
			'label'    => esc_html__('Boxed Body', 'ABdev_dzen'),
			'description'   => esc_attr__('Check this to enable boxed body layout', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Body Background
		**/
		$wp_customize->add_setting('bg_color', array(
			'default'     => '#056ab2',
			'transport'	  => 'postMessage',
		));
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'bg_color', array(
			'label'      => esc_attr__('Background Color', 'ABdev_dzen'),
			'settings'   => 'bg_color',
			'section'    => 'section_general',
		)));


        $wp_customize->add_setting( 'custom_bg_image', array(
            'default'        => '',
        ) );

        $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'custom_bg_image' , array(
			'label'      => esc_attr__('Background Image', 'ABdev_dzen'),
			'settings'   => 'custom_bg_image',
			'section'    => 'section_general',
        )));


        $wp_customize->add_setting( 'vozx_background_repeat', array(
            'default'        => 'no-repeat',
        ) );

        $wp_customize->add_control( 'vozx_background_repeat', array(
            'label'      => esc_attr__( 'Background Repeat', 'ABdev_dzen' ),
            'section'    => 'section_general',
            'type'       => 'select',
            'choices'    => array(
                'no-repeat'  => esc_attr__('No Repeat', 'ABdev_dzen'),
                'repeat'     => esc_attr__('Tile', 'ABdev_dzen'),
                'repeat-x'   => esc_attr__('Tile Horizontally', 'ABdev_dzen'),
                'repeat-y'   => esc_attr__('Tile Vertically', 'ABdev_dzen'),
            ),
        ) );


        $wp_customize->add_setting( 'vozx_background_size', array(
            'default'        => 'cover',
        ) );

        $wp_customize->add_control( 'vozx_background_size', array(
            'label'      => esc_attr__( 'Background Size', 'ABdev_dzen' ),
            'section'    => 'section_general',
            'type'       => 'select',
            'choices'    => array(
                'cover'  => esc_attr__('Cover', 'ABdev_dzen'),
                'contain' => esc_attr__('Contain', 'ABdev_dzen'),
            ),
        ) );

        $wp_customize->add_setting( 'vozx_background_position', array(
            'default'  => 'center center',
        ) );

        $wp_customize->add_control( 'vozx_background_position', array(
            'label'      => esc_attr__( 'Background Position', 'ABdev_dzen' ),
            'section'    => 'section_general',
            'type'       => 'select',
            'choices'    => array(
                'left top'       => esc_attr__( 'Left Top', 'ABdev_dzen' ),
                'left center'     => esc_attr__( 'Left Center', 'ABdev_dzen' ),
                'left bottom'      => esc_attr__( 'Left Bottom', 'ABdev_dzen' ),
                'center top'       => esc_attr__( 'Center Top', 'ABdev_dzen' ),
                'center center'     => esc_attr__( 'Center Center', 'ABdev_dzen' ),
                'center bottom'      => esc_attr__( 'Center Bottom', 'ABdev_dzen' ),
                'right top'       => esc_attr__( 'Right Top', 'ABdev_dzen' ),
                'right center'     => esc_attr__( 'Right Center', 'ABdev_dzen' ),
                'right bottom'      => esc_attr__( 'Right Bottom', 'ABdev_dzen' ),
            ),
        ) );

        $wp_customize->add_setting( 'vozx_background_attachment', array(
            'default'        => 'fixed',
        ) );

        $wp_customize->add_control( 'vozx_background_attachment', array(
            'label'      => esc_attr__( 'Background Attachment', 'ABdev_dzen' ),
            'section'    => 'section_general',
            'type'       => 'select',
            'choices'    => array(
                'fixed'      => esc_attr__('Fixed', 'ABdev_dzen'),
                'scroll'     => esc_attr__('Scroll', 'ABdev_dzen'),
            ),
        ) );


	/**
	------------------------------------------------------------
	SECTION: Header
	------------------------------------------------------------
	**/
	$wp_customize->add_section('section_header', array(
		'title'		=> esc_html__('Header', 'ABdev_dzen'),
		'priority'	=> 0,
	));

		/**
		Header Logo
		**/
		$wp_customize->add_setting('header_logo', array(
			'default'     => '',
		));
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'header_logo', array(
			'label'     	=> esc_html__( 'Header Logo', 'ABdev_dzen' ),
			'settings'  	=> 'header_logo',
			'section'   	=> 'section_header',
		)));

		/**
		Header Retina Logo 
		**/
		$wp_customize->add_setting('header_retina_logo', array(
			'default'     => '',
		));
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'header_retina_logo', array(
			'label'     	=> esc_html__( 'Header Logo (Retina Version @2x)', 'ABdev_dzen' ),
			'description'    => esc_html__('Select an image file for the retina version of the logo. It should be exactly 2x the size of main logo.', 'ABdev_dzen'),
			'settings'  	=> 'header_retina_logo',
			'section'   	=> 'section_header',
		)));

		/**
		Header Retina Logo Width
		**/
		$wp_customize->add_setting('header_retina_logo_width', array(
			'default'     => '',
		));
		$wp_customize->add_control('header_retina_logo_width', array(
			'label'    => esc_html__('Retina Logo Width', 'ABdev_dzen'),
			'description'    => esc_html__('If retina logo is uploaded, enter the standard logo (1x) version width, do not enter the retina logo width.', 'ABdev_dzen'),
			'type'     => 'text',
			'section'  => 'section_header',
		));

		/**
		Header Retina Logo Height
		**/
		$wp_customize->add_setting('header_retina_logo_height', array(
			'default'     => '',
		));
		$wp_customize->add_control('header_retina_logo_height', array(
			'label'    => esc_html__('Retina Logo Height', 'ABdev_dzen'),
			'description'    => esc_html__('If retina logo is uploaded, enter the standard logo (1x) version height, do not enter the retina logo height.', 'ABdev_dzen'),
			'type'     => 'text',
			'section'  => 'section_header',
		));

		/**
		Hide Title/Breadcrumbs Bar
		**/
		$wp_customize->add_setting('hide_title_breadcrumbs_bar', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'hide_title_breadcrumbs_bar', array(
			'label'    => esc_html__('Hide Title/Breadcrumbs Bar', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Hide Title From Bar
		**/
		$wp_customize->add_setting('hide_title_from_bar', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'hide_title_from_bar', array(
			'label'    => esc_html__('Hide Title From Bar', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Hide Breadcrumbs From Bar
		**/
		$wp_customize->add_setting('hide_breadcrumbs_from_bar', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'hide_breadcrumbs_from_bar', array(
			'label'    => esc_html__('Hide Breadcrumbs From Bar', 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));

		/**
		Title/Breadcrumbs Bar Background Color
		**/
		$wp_customize->add_setting('dzen_title_breadcrumbs_color', array(
			'default'     => '',
			'transport'   => 'postMessage',
		));
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'dzen_title_breadcrumbs_color', array(
			'label'      => esc_html__('Title/Breadcrumbs Bar Background Color', 'ABdev_dzen'),
			'settings'   => 'dzen_title_breadcrumbs_color',
			'section'    => 'section_header',
		)));

		/**
		Title/Breadcrumbs Bar Background Image
		**/
		$wp_customize->add_setting('dzen_title_breadcrumbs_image', array(
			'default'     => '',
		));
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'dzen_title_breadcrumbs_image', array(
			'label'     	=> esc_html__( 'Title/Breadcrumbs Bar Background Image', 'ABdev_dzen' ),
			'settings'  	=> 'dzen_title_breadcrumbs_image',
			'section'   	=> 'section_header',
		)));


		$wp_customize->add_setting( 'dzen_title_breadcrumbs_bar_background_repeat', array(
            'default'        => 'no-repeat',
        ) );

        $wp_customize->add_control( 'dzen_title_breadcrumbs_bar_background_repeat', array(
            'label'      => esc_attr__( 'Background Repeat', 'ABdev_dzen' ),
            'section'    => 'section_header',
            'type'       => 'select',
            'choices'    => array(
                'no-repeat'  => esc_attr__('No Repeat', 'ABdev_dzen'),
                'repeat'     => esc_attr__('Tile', 'ABdev_dzen'),
                'repeat-x'   => esc_attr__('Tile Horizontally', 'ABdev_dzen'),
                'repeat-y'   => esc_attr__('Tile Vertically', 'ABdev_dzen'),
            ),
        ) );


        $wp_customize->add_setting( 'dzen_title_breadcrumbs_bar_background_size', array(
            'default'        => 'cover',
        ) );

        $wp_customize->add_control( 'dzen_title_breadcrumbs_bar_background_size', array(
            'label'      => esc_attr__( 'Background Size', 'ABdev_dzen' ),
            'section'    => 'section_header',
            'type'       => 'select',
            'choices'    => array(
                'cover'  => esc_attr__('Cover', 'ABdev_dzen'),
                'contain' => esc_attr__('Contain', 'ABdev_dzen'),
            ),
        ) );

        $wp_customize->add_setting( 'dzen_title_breadcrumbs_bar_background_position', array(
            'default'  => 'center center',
        ) );

        $wp_customize->add_control( 'dzen_title_breadcrumbs_bar_background_position', array(
            'label'      => esc_attr__( 'Background Position', 'ABdev_dzen' ),
            'section'    => 'section_header',
            'type'       => 'select',
            'choices'    => array(
                'left top'       => esc_attr__( 'Left Top', 'ABdev_dzen' ),
                'left center'     => esc_attr__( 'Left Center', 'ABdev_dzen' ),
                'left bottom'      => esc_attr__( 'Left Bottom', 'ABdev_dzen' ),
                'center top'       => esc_attr__( 'Center Top', 'ABdev_dzen' ),
                'center center'     => esc_attr__( 'Center Center', 'ABdev_dzen' ),
                'center bottom'      => esc_attr__( 'Center Bottom', 'ABdev_dzen' ),
                'right top'       => esc_attr__( 'Right Top', 'ABdev_dzen' ),
                'right center'     => esc_attr__( 'Right Center', 'ABdev_dzen' ),
                'right bottom'      => esc_attr__( 'Right Bottom', 'ABdev_dzen' ),
            ),
        ) );
		

if( in_array('dnd-shortcodes/dnd-shortcodes.php', get_option('active_plugins')) ){
	/**
	------------------------------------------------------------
	SECTION: Icons
	------------------------------------------------------------
	**/
	$wp_customize->add_section('section_icons', array(
		'title'		=> esc_html__('Icons', 'ABdev_dzen'),
		'priority'	=> 0,
	));

		/**
		Info
		**/
		$wp_customize->add_setting('icons_info_1', array(
			'default'     => '',
		));
		$wp_customize->add_control(new Info_Custom_control($wp_customize, 'icons_info_1', array(
			'label'     	=> esc_html__( "Complete theme's icons names list", 'ABdev_dzen' ),
			'description'   => esc_html__( 'Icon list with all icons and their names can be found <a href="'.esc_url(get_template_directory_uri()).'/css/icons/demo.html" target="_blank">here</a>.', 'ABdev_dzen' ),
			'settings'  	=> 'icons_info_1',
			'section'   	=> 'section_icons',
		)));

		/**
		Disable Theme Icon Font
		**/
		$wp_customize->add_setting('disable_icon_font', array(
			'default'     => '',
			'sanitize_callback' => 'ABdev_checkbox_sanitization',
		));
		$wp_customize->add_control(new Toggle_Checkbox_Custom_control($wp_customize, 'disable_icon_font', array(
			'label'    => esc_html__('Disable Theme Icon Font', 'ABdev_dzen'),
			'description'    => esc_html__("If you don't use theme's icons (e.g. you have Font Awesome or WHHG enabled in Drag and Drop settings) you can disable theme's icon set.", 'ABdev_dzen'),
			'type'     => 'checkbox',
			'section'  => 'section_general',
		)));
}


	/**
	------------------------------------------------------------
	SECTION: Sidebars
	------------------------------------------------------------
	**/
	$wp_customize->add_section('section_sidebars', array(
		'title'		=> esc_html__('Sidebars', 'ABdev_dzen'),
		'priority'	=> 0,
	));

		/**
		Sidebars
		**/
		$wp_customize->add_setting('sidebars', array(
			'default'     => '',
			'transport'   => 'postMessage',
		));
		$wp_customize->add_control(new Multi_Input_Custom_control($wp_customize, 'sidebars', array(
			'label'     	=> esc_html__( 'Sidebars', 'ABdev_dzen' ),
			'description'   => esc_html__( 'Add as many custom sidebars as you need', 'ABdev_dzen' ),
			'settings'  	=> 'sidebars',
			'section'   	=> 'section_sidebars',
		)));


	/**
	------------------------------------------------------------
	SECTION: Colors
	------------------------------------------------------------
	**/
	$wp_customize->add_section('section_global_colors', array(
		'title'		=> esc_html__('Colors', 'ABdev_dzen'),
		'priority'	=> 0,
	));

		/**
		Main Color
		**/
		$wp_customize->add_setting('main_color', array(
			'default'     => '#056ab2',
			'transport'   => 'postMessage',
		));
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'main_color', array(
			'label'      => esc_html__('Main Color', 'ABdev_dzen'),
			'settings'   => 'main_color',
			'section'    => 'section_global_colors',
		)));

		/**
		Secondary Color
		**/
		$wp_customize->add_setting('secondary_color', array(
			'default'     => '#56b9ff',
			'transport'   => 'postMessage',
		));
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'secondary_color', array(
			'label'      => esc_html__('Secondary Color', 'ABdev_dzen'),
			'settings'   => 'secondary_color',
			'section'    => 'section_global_colors',
		)));


	/**
	------------------------------------------------------------
	SECTION: Footer
	------------------------------------------------------------
	**/
	$wp_customize->add_section('section_footer', array(
		'title'		=> esc_html__('Footer', 'ABdev_dzen'),
		'priority'	=> 0,
	));

		/**
		Copyright Notice
		**/
		$wp_customize->add_setting('copyright', array(
			'default'     => '',
			'transport'   => 'postMessage',
		));
		$wp_customize->add_control('copyright', array(
			'label'    => esc_html__('Copyright Notice', 'ABdev_dzen'),
			'description'    => esc_html__('Enter copyright notice to be shown in footer', 'ABdev_dzen'),
			'type'     => 'text',
			'section'  => 'section_footer',
		));

		/**
		Links Target
		**/
		$wp_customize->add_setting('social_target', array(
			'default'     => '',
		));
		$wp_customize->add_control('social_target', array(
			'label'    		=> esc_html__('Links Target', 'ABdev_dzen'),
			'type'    => 'select',
	        'choices'    => array(
	            '_self' => 'Self',
	            '_blank' => 'Blank',
	        ),
			'section'  		=> 'section_footer',
		));

		/**
		Facebook URL
		**/
		$wp_customize->add_setting('facebook_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('facebook_url', array(
			'label'    		=> esc_html__('Facebook URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Twitter URL
		**/
		$wp_customize->add_setting('twitter_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('twitter_url', array(
			'label'    		=> esc_html__('Twitter URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Googleplus URL
		**/
		$wp_customize->add_setting('googleplus_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('googleplus_url', array(
			'label'    		=> esc_html__('Googleplus URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Linkedin URL
		**/
		$wp_customize->add_setting('linkedin_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('linkedin_url', array(
			'label'    		=> esc_html__('Linkedin URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Pinterest URL
		**/
		$wp_customize->add_setting('pinterest_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('pinterest_url', array(
			'label'    		=> esc_html__('Pinterest URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Github URL
		**/
		$wp_customize->add_setting('github_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('github_url', array(
			'label'    		=> esc_html__('Github URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Delicious
		**/
		$wp_customize->add_setting('delicious_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('delicious_url', array(
			'label'    		=> esc_html__('Delicious', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		DesignContest
		**/
		$wp_customize->add_setting('designContest_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('designContest_url', array(
			'label'    		=> esc_html__('DesignContest', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Feed URL
		**/
		$wp_customize->add_setting('feed_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('feed_url', array(
			'label'    		=> esc_html__('Feed URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Behance URL
		**/
		$wp_customize->add_setting('behance_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('behance_url', array(
			'label'    		=> esc_html__('Behance URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Blogger
		**/
		$wp_customize->add_setting('blogger_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('blogger_url', array(
			'label'    		=> esc_html__('Blogger', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Dribbble URL
		**/
		$wp_customize->add_setting('dribbble_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('dribbble_url', array(
			'label'    		=> esc_html__('Dribbble URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		DeviantART
		**/
		$wp_customize->add_setting('deviantART_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('deviantART_url', array(
			'label'    		=> esc_html__('DeviantART', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Digg
		**/
		$wp_customize->add_setting('digg_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('digg_url', array(
			'label'    		=> esc_html__('Digg', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Dropbox URL
		**/
		$wp_customize->add_setting('dropbox_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('dropbox_url', array(
			'label'    		=> esc_html__('Dropbox URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Mail URL
		**/
		$wp_customize->add_setting('email_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('email_url', array(
			'label'    		=> esc_html__('Mail URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Flickr URL
		**/
		$wp_customize->add_setting('flickr_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('flickr_url', array(
			'label'    		=> esc_html__('Flickr URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Instagram URL
		**/
		$wp_customize->add_setting('instagram_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('instagram_url', array(
			'label'    		=> esc_html__('Instagram URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Forrst
		**/
		$wp_customize->add_setting('forrst_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('forrst_url', array(
			'label'    		=> esc_html__('Forrst', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Lastfm URL
		**/
		$wp_customize->add_setting('lastfm_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('lastfm_url', array(
			'label'    		=> esc_html__('Lastfm URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Myspace
		**/
		$wp_customize->add_setting('myspace_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('myspace_url', array(
			'label'    		=> esc_html__('Myspace', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Picasa URL
		**/
		$wp_customize->add_setting('picasa_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('picasa_url', array(
			'label'    		=> esc_html__('Picasa URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Skype URL
		**/
		$wp_customize->add_setting('skype_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('skype_url', array(
			'label'    		=> esc_html__('Skype URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Stumbleupon URL
		**/
		$wp_customize->add_setting('stumbleUpon_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('stumbleUpon_url', array(
			'label'    		=> esc_html__('Stumbleupon URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Vimeo URL
		**/
		$wp_customize->add_setting('vimeo_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('vimeo_url', array(
			'label'    		=> esc_html__('Vimeo URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		YouTube URL
		**/
		$wp_customize->add_setting('youtube_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('youtube_url', array(
			'label'    		=> esc_html__('YouTube URL', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));

		/**
		Zerply
		**/
		$wp_customize->add_setting('zerply_url', array(
			'default'     => '',
		));
		$wp_customize->add_control('zerply_url', array(
			'label'    		=> esc_html__('Zerply', 'ABdev_dzen'),
			'type'     		=> 'url',
			'section'  		=> 'section_footer',
		));


}
add_action('customize_register', 'dzen_customize_register');

function dzen_customizer_live_preview(){
	wp_enqueue_script('dzen-themecustomizer', get_template_directory_uri().'/inc/customizer/js/customizer.js', array('jquery', 'customize-preview'), '', true);
}
add_action( 'customize_preview_init', 'dzen_customizer_live_preview' );