(function($){

	function dynamic_css_targets(){
		var css_styles_targets = '<style id="customizer_dynamic_color_css" type="text/css"></style>'+
			'<style id="customizer_dynamic_secondary_color_css" type="text/css"></style>'+
			'<style id="customizer_bg_color_css" type="text/css"></style>'+
			'<style id="customizer_breadcrumbs_bar_background_color_css" type="text/css"></style>'+
			'<style id="customizer_custom_css" type="text/css"></style>';
		if(!$('#customizer_dynamic_color_css').length){
			$('#main_css-inline-css').after(css_styles_targets);
		}
	}

	wp.customize('custom_css', function(value){
		value.bind(function(newval){
			dynamic_css_targets();
			$('#customizer_custom_css').text(newval);
		});
	});

	wp.customize('header_logo', function(value){
		value.bind(function(newval){
			$('#header_logo').attr('src', newval);
		});
	});

	wp.customize('header_retina_logo', function(value){
		value.bind(function(newval){
			$('#retina_logo').attr('src', newval);
		});
	});

	wp.customize('sidebars', function(value){
		value.bind(function(newval){
		});
	});

	wp.customize('main_color', function(value){
		value.bind(function(newval){
			dynamic_css_targets();
			var patt = /^#([\da-fA-F]{2})([\da-fA-F]{2})([\da-fA-F]{2})$/;
			var matches = patt.exec(newval);
			var rgba = "rgba("+parseInt(matches[1], 16)+","+parseInt(matches[2], 16)+","+parseInt(matches[3], 16)+", 0.75);";
			var new_colors = '.dnd-tabs .ui-tabs-nav li.ui-tabs-active a{color: '+newval+';} .dnd-accordion .ui-accordion-header-active{color:'+newval+';} .dnd-table.dnd-table-alternative th{background: '+newval+';} .dnd_stats_excerpt{color: '+newval+';} .dnd_team_member .dnd_overlayed .dnd_overlay{background:'+newval+';} .dnd_latest_news_time{background: '+newval+';} .dnd_pricing-table-1 .dnd_pricebox_header{background: #cee6e6;color: '+newval+';} .dnd_pricing-table-2 .dnd_popular-plan .dnd_pricebox_header{background: '+newval+';} .dnd_service_box .dnd_icon_boxed i{color: '+newval+';} .dnd_service_box:hover .dnd_icon_boxed{background: '+newval+';} .dnd_service_box.dnd_service_box_round_stroke .dnd_icon_boxed{border: 3px solid '+newval+';} .dnd_service_box.dnd_service_box_round_stroke .dnd_icon_boxed i{color: '+newval+';} .dnd_service_box.dnd_service_box_round_aside .dnd_icon_boxed i{color: '+newval+';} .dnd_service_box.dnd_service_box_round_aside:hover .dnd_icon_boxed{background: '+newval+';} .dnd_service_box .dnd_icon_boxed:hover:after{border-top: 9px solid '+newval+';} .dnd-button_dark:hover{background: '+newval+';border: 1px solid '+newval+';} .process_section .dnd_service_box .dnd_icon_boxed{background: '+newval+';} .tcvpb-tabs .nav-tabs li.active a{color: '+newval+';} .tcvpb-accordion .ui-accordion-header-active{color:'+newval+';} .tcvpb-table.tcvpb-table-alternative th{background: '+newval+';} .tcvpb_stats_excerpt{color: '+newval+';} .tcvpb_team_member .tcvpb_overlayed .tcvpb_overlay{background:'+newval+';} .tcvpb_latest_news_time{background: '+newval+';} .tcvpb_pricing-table-1 .tcvpb_pricebox_header{background: #cee6e6;color: '+newval+';} .tcvpb_pricing-table-2 .tcvpb_popular-plan .tcvpb_pricebox_header{background: '+newval+';} .tcvpb_service_box .tcvpb_icon_boxed i{color: '+newval+';} .tcvpb_service_box:hover .tcvpb_icon_boxed{background: '+newval+';} .tcvpb_service_box.tcvpb_service_box_round_stroke .tcvpb_icon_boxed{border: 3px solid '+newval+';} .tcvpb_service_box.tcvpb_service_box_round_stroke .tcvpb_icon_boxed i{color: '+newval+';} .tcvpb_service_box.tcvpb_service_box_round_aside .tcvpb_icon_boxed i{color: '+newval+';} .tcvpb_service_box.tcvpb_service_box_round_aside:hover .tcvpb_icon_boxed{background: '+newval+';} .tcvpb_service_box .tcvpb_icon_boxed:hover:after{border-top: 9px solid '+newval+';} .tcvpb-button_dark:hover{background: '+newval+';border: 1px solid '+newval+';} .process_section .tcvpb_service_box .tcvpb_icon_boxed{background: '+newval+';} #ABdev_menu_toggle{color: '+newval+';} a:hover{color: '+newval+';} button,input[type="submit"]{border: 1px solid '+newval+';background: '+newval+';} .color_highlight{color: '+newval+';} .dnd_dropcap{background: '+newval+';} .section_color_background{background: '+newval+';} .leading_line:after{background: '+newval+';} .tp-leftarrow.default:hover,.tp-rightarrow.default:hover{background: '+newval+' !important;} .tp-bullets.simplebullets.round .bullet:hover,.tp-bullets.simplebullets.round .bullet.selected{background-color:'+newval+';} .timeline_post_left:after,.timeline_post_right:after{background: '+newval+';} .post_meta_tags a:hover{color: '+newval+';} .more-link{color: '+newval+';} .comment .reply,.comment .edit-link,.comment .reply a,.comment .edit-link a{color: '+newval+';} .comment .reply a:hover,.comment .edit-link a:hover{color: '+newval+';} #respond #comment-submit{background: '+newval+';} .wpcf7-submit{background: '+newval+';} #dz_contact_form_submit{background: '+newval+' !important;} aside .widget a:hover{color: '+newval+';} .tagcloud a:hover{background: '+newval+';} .portfolio_item h4 a:hover{color: '+newval+';} .portfolio_item_view_link a{background: '+newval+';} #page404 .big_404{color: '+newval+';} .tcvpb-accordion .ui-icon-triangle-1-s{background: '+newval+';} .tcvpb_team_member:hover .tcvpb_overlayed .tcvpb_overlay{ background:'+rgba+';}  .portfolio_item:hover .overlayed .overlay{ background: '+rgba+';} .pattern_overlayed:before{ background:'+rgba+';}.tribe-events-calendar thead th{background-color: '+newval+';border-left-color: '+newval+';border-right-color: '+newval+';}#tribe-bar-form .tribe-bar-submit input[type=submit] {background-color: '+newval+';}#tribe-events .tribe-events-button, #tribe-events .tribe-events-button:hover, #tribe_events_filters_wrapper input[type=submit], .tribe-events-button, .tribe-events-button.tribe-active:hover, .tribe-events-button.tribe-inactive, .tribe-events-button:hover, .tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-], .tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-]>a {background-color: '+newval+';}';
			$('#customizer_dynamic_color_css').text(new_colors);
		});
	});

	wp.customize('secondary_color', function(value){
		value.bind(function(newval){
			dynamic_css_targets();
			var new_colors = '.dnd_section_dd header h3:after,.column_title_left:after{background: '+newval+';} .dnd_stats_excerpt .dnd_stats_number:after{background: '+newval+';} .tcvpb_section_tc header h3:after,.column_title_left:after{background: '+newval+';} .tcvpb_stats_excerpt .tcvpb_stats_number:after{background: '+newval+';} .sidebar-widget-heading h3:after,#comments-title:after,#reply-title:after{background: '+newval+';} #related_posts:after{background: '+newval+';}';
			$('#customizer_dynamic_secondary_color_css').text(new_colors);
		});
	});

	wp.customize('bg_color', function(value){
		value.bind(function(newval){
			dynamic_css_targets();
			var new_colors = 'body{ background: '+newval+';} ';
			$('#customizer_bg_color_css').text(new_colors);
		});
	});

	wp.customize('title_breadcrumbs_bar_background_color', function(value){
		value.bind(function(newval){
			dynamic_css_targets();
			var new_colors = '#title_breadcrumbs_bar{background-color: '+newval+' !important; }';
			$('#customizer_breadcrumbs_bar_background_color_css').text(new_colors);
		});
	});

	wp.customize('blogname', function(value){
		value.bind(function(newval){
			$('#main_logo_textual').html(newval);
		});
	});

	wp.customize('blogdescription', function(value){
		value.bind(function(newval){
			$('#main_logo_tagline').html(newval);
		});
	});

	wp.customize('copyright', function(value){
		value.bind(function(newval){
			$('.footer_copyright').html(newval);
		});
	});


})(jQuery);