<?php

if ( ! function_exists( 'ABdev_colors_css_hex2rgb' ) ){
	function ABdev_colors_css_hex2rgb($hex) {
		$hex = str_replace("#", "", $hex);
		if(strlen($hex) == 3) {
			$r = hexdec(substr($hex,0,1).substr($hex,0,1));
			$g = hexdec(substr($hex,1,1).substr($hex,1,1));
			$b = hexdec(substr($hex,2,1).substr($hex,2,1));
		} else {
			$r = hexdec(substr($hex,0,2));
			$g = hexdec(substr($hex,2,2));
			$b = hexdec(substr($hex,4,2));
		}
		$rgb = array($r, $g, $b);
		return implode(",", $rgb);
	}
}

if ( ! function_exists( 'ABdev_colors_css_adjustBrightness' ) ){
	function ABdev_colors_css_adjustBrightness($hex, $steps) {
		// Steps should be between -255 and 255. Negative = darker, positive = lighter
		$steps = max(-255, min(255, $steps));
		$hex = str_replace('#', '', $hex);
		if (strlen($hex) == 3) {
			$hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
		}
		$r = hexdec(substr($hex,0,2));
		$g = hexdec(substr($hex,2,2));
		$b = hexdec(substr($hex,4,2));
		$r = max(0,min(255,$r + $steps));
		$g = max(0,min(255,$g + $steps));
		$b = max(0,min(255,$b + $steps));
		$r_hex = str_pad(dechex($r), 2, '0', STR_PAD_LEFT);
		$g_hex = str_pad(dechex($g), 2, '0', STR_PAD_LEFT);
		$b_hex = str_pad(dechex($b), 2, '0', STR_PAD_LEFT);
		return '#'.$r_hex.$g_hex.$b_hex;
	}
}


$main_color = get_theme_mod('main_color', '#056ab2');
$secondary_color = get_theme_mod('secondary_color', '#56b9ff');

$custom_css.= '
	.dnd-tabs .ui-tabs-nav li.ui-tabs-active a{color: '.$main_color.';}
	.dnd-accordion .ui-accordion-header-active{color:'.$main_color.';}
	.dnd-table.dnd-table-alternative th{background: '.$main_color.';}
	.dnd_stats_excerpt{color: '.$main_color.';}
	.dnd_team_member .dnd_overlayed .dnd_overlay{background:'.$main_color.';}
	.dnd_latest_news_time{background: '.$main_color.';}
	.dnd_pricing-table-1 .dnd_pricebox_header{background: #cee6e6;color: '.$main_color.';}
	.dnd_pricing-table-2 .dnd_popular-plan .dnd_pricebox_header{background: '.$main_color.';}
	.dnd_service_box .dnd_icon_boxed i{color: '.$main_color.';}
	.dnd_service_box:hover .dnd_icon_boxed{background: '.$main_color.';}
	.dnd_service_box.dnd_service_box_round_stroke .dnd_icon_boxed{border: 3px solid '.$main_color.';}
	.dnd_service_box.dnd_service_box_round_stroke .dnd_icon_boxed i{color: '.$main_color.';}
	.dnd_service_box.dnd_service_box_round_aside .dnd_icon_boxed i{color: '.$main_color.';}
	.dnd_service_box.dnd_service_box_round_aside:hover .dnd_icon_boxed{background: '.$main_color.';}
	.dnd_service_box .dnd_icon_boxed:hover:after{border-top: 9px solid '.$main_color.';}
	.dnd-button_dark:hover{background: '.$main_color.';border: 1px solid '.$main_color.';}
	.process_section .dnd_service_box .dnd_icon_boxed{background: '.$main_color.';}
	.tcvpb-tabs .nav-tabs li.active a{color: '.$main_color.';}
	.tcvpb-accordion .ui-accordion-header-active{color:'.$main_color.';}
	.tcvpb-table.tcvpb-table-alternative th{background: '.$main_color.';}
	.tcvpb_stats_excerpt{color: '.$main_color.';}
	.tcvpb_team_member .tcvpb_overlayed .tcvpb_overlay{background:'.$main_color.';}
	.tcvpb_latest_news_time{background: '.$main_color.';}
	.tcvpb_pricing-table-1 .tcvpb_pricebox_header{background: #cee6e6;color: '.$main_color.';}
	.tcvpb_pricing-table-2 .tcvpb_popular-plan .tcvpb_pricebox_header{background: '.$main_color.';}
	.tcvpb_service_box .tcvpb_icon_boxed i{color: '.$main_color.';}
	.tcvpb_service_box:hover .tcvpb_icon_boxed{background: '.$main_color.';}
	.tcvpb_service_box.tcvpb_service_box_round_stroke .tcvpb_icon_boxed{border: 3px solid '.$main_color.';}
	.tcvpb_service_box.tcvpb_service_box_round_stroke .tcvpb_icon_boxed i{color: '.$main_color.';}
	.tcvpb_service_box.tcvpb_service_box_round_aside .tcvpb_icon_boxed i{color: '.$main_color.';}
	.tcvpb_service_box.tcvpb_service_box_round_aside:hover .tcvpb_icon_boxed{background: '.$main_color.';}
	.tcvpb_service_box .tcvpb_icon_boxed:hover:after{border-top: 9px solid '.$main_color.';}
	.tcvpb-button_dark:hover{background: '.$main_color.';border: 1px solid '.$main_color.';}
	.process_section .tcvpb_service_box .tcvpb_icon_boxed{background: '.$main_color.';}
	#ABdev_menu_toggle{color: '.$main_color.';}
	a:hover{color: '.$main_color.';}
	.tcvpb_team_member:hover .tcvpb_overlayed .tcvpb_overlay{ background: rgba('.ABdev_colors_css_hex2rgb($main_color).',0.75)}
	.portfolio_item:hover .overlayed .overlay{ background: rgba('.ABdev_colors_css_hex2rgb($main_color).',0.75)}
	button,input[type="submit"]{border: 1px solid '.$main_color.';background: '.$main_color.';}
	#ABdev_menu_toggle{color: '.$main_color.';}
	.color_highlight{color: '.$main_color.';}
	.dnd_dropcap{background: '.$main_color.';}
	.section_color_background{background: '.$main_color.';}
	.leading_line:after{background: '.$main_color.';}
	.tp-leftarrow.default:hover,.tp-rightarrow.default:hover{background: '.$main_color.' !important;}
	.tp-bullets.simplebullets.round .bullet:hover,.tp-bullets.simplebullets.round .bullet.selected{background-color:'.$main_color.';}
	.timeline_post_left:after,.timeline_post_right:after{background: '.$main_color.';}
	.post_meta_tags a:hover{color: '.$main_color.';}
	.more-link{color: '.$main_color.';}
	.comment .reply,.comment .edit-link,.comment .reply a,.comment .edit-link a{color: '.$main_color.';}
	.comment .reply a:hover,.comment .edit-link a:hover{color: '.$main_color.';}
	#respond #comment-submit{background: '.$main_color.';}
	.wpcf7-submit{background: '.$main_color.';}
	#dz_contact_form_submit{background: '.$main_color.' !important;}
	aside .widget a:hover{color: '.$main_color.';}
	.tagcloud a:hover{background: '.$main_color.';}
	.portfolio_item h4 a:hover{color: '.$main_color.';}
	.portfolio_item_view_link a{background: '.$main_color.';}
	#page404 .big_404{color: '.$main_color.';}
	.tcvpb-accordion .ui-icon-triangle-1-s{background: '.$main_color.';}
	.pattern_overlayed:before{ background: rgba('.ABdev_colors_css_hex2rgb($main_color).',0.9)}
	.tribe-events-calendar thead th{background-color: '.$main_color.';border-left-color: '.$main_color.';border-right-color: '.$main_color.';}
	#tribe-bar-form .tribe-bar-submit input[type=submit] {background-color: '.$main_color.';}
	#tribe-events .tribe-events-button, #tribe-events .tribe-events-button:hover, #tribe_events_filters_wrapper input[type=submit], .tribe-events-button, .tribe-events-button.tribe-active:hover, .tribe-events-button.tribe-inactive, .tribe-events-button:hover, .tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-], .tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-]>a {
	    background-color: '.$main_color.';}
';

$custom_css.= '
	.dnd_section_dd header h3:after,.column_title_left:after{background: '.$secondary_color.';}
	.dnd_stats_excerpt .dnd_stats_number:after{background: '.$secondary_color.';}
	.tcvpb_section_tc header h3:after,.column_title_left:after{background: '.$secondary_color.';}
	.tcvpb_stats_excerpt .tcvpb_stats_number:after{background: '.$secondary_color.';}
	.sidebar-widget-heading h3:after,#comments-title:after,#reply-title:after{background: '.$secondary_color.';}
	#related_posts:after{background: '.$secondary_color.';}

';

if(get_theme_mod('header_retina_logo', '') !='' ){
	$custom_css.= '
	#dz_main_header #main_logo{display:inline;}
	#dz_main_header #retina_logo{display:none;}
	@media only screen and (-webkit-min-device-pixel-ratio: 1.3), 
	only screen and (-o-min-device-pixel-ratio: 13/10), 
	only screen and (min-resolution: 120dpi) {
		#dz_main_header #main_logo{display:none;}
		#dz_main_header #retina_logo{display:inline;}
	}';
}

if (get_theme_mod('boxed_body', false)) {
	$bg_color = get_theme_mod('bg_color', '#ff503f');
	$bg_color = ($bg_color!='') ? ' background-color:'.$bg_color : '';

	$custom_bg_image = get_theme_mod('custom_bg_image', '');
	$custom_bg_image = ($custom_bg_image!='') ? ' background-image:url("'.$custom_bg_image.'")' : '';

	$dzen_background_repeat = get_theme_mod('dzen_background_repeat', 'no-repeat');
	$dzen_background_repeat = ($dzen_background_repeat!='' && get_theme_mod('custom_bg_image', '') != '') ? ' background-repeat:'.$dzen_background_repeat : '';

	$dzen_background_size = get_theme_mod('dzen_background_size', 'cover');
	$dzen_background_size = ($dzen_background_size!='' && get_theme_mod('custom_bg_image', '') != '') ? ' background-size:'.$dzen_background_size : '';

	$dzen_background_position = get_theme_mod('dzen_background_position', 'center center');
	$dzen_background_position = ($dzen_background_position!='' && get_theme_mod('custom_bg_image', '') != '') ? ' background-position:'.$dzen_background_position : '';

	$dzen_background_attachment = get_theme_mod('dzen_background_attachment', 'fixed');
	$dzen_background_attachment = ($dzen_background_attachment!='' && get_theme_mod('custom_bg_image', '') != '') ? ' background-attachment:'.$dzen_background_attachment : '';


	$custom_css.= 'body{'.$bg_color.'; '.$custom_bg_image.'; '.$dzen_background_repeat.'; '.$dzen_background_size.'; '.$dzen_background_position.'; '.$dzen_background_attachment.';}';

}


/* Title Breadcrumbs Bar Background */
	$dzen_title_breadcrumbs_color = get_theme_mod('dzen_title_breadcrumbs_color', '#eee');
	$dzen_title_breadcrumbs_color = ($dzen_title_breadcrumbs_color != '') ? ' background-color:'.$dzen_title_breadcrumbs_color : '';

	$dzen_title_breadcrumbs_image = get_theme_mod('dzen_title_breadcrumbs_image', '');
	$featured_image = wp_get_attachment_url(get_post_thumbnail_id(get_the_ID()));
	
	if($featured_image!='' && is_page()){
		$dzen_title_breadcrumbs_image = ($featured_image != '') ? ' background-image:url("'.$featured_image.'")' : '';
	}
	else{
		$dzen_title_breadcrumbs_image = ($dzen_title_breadcrumbs_image != '') ? ' background-image:url("'.$dzen_title_breadcrumbs_image.'")' : '';
	}


	$dzen_background_repeat_breadcrumbs_image = get_theme_mod('dzen_title_breadcrumbs_bar_background_repeat', 'no-repeat');
	$dzen_background_repeat_breadcrumbs_image = ($dzen_background_repeat_breadcrumbs_image!='' && $dzen_title_breadcrumbs_image!= '') ? ' background-repeat:'.$dzen_background_repeat_breadcrumbs_image : '';
	$dzen_background_size_breadcrumbs_image = get_theme_mod('dzen_title_breadcrumbs_bar_background_size', 'cover');
	$dzen_background_size_breadcrumbs_image = ($dzen_background_size_breadcrumbs_image!='' && $dzen_title_breadcrumbs_image!= '') ? ' background-size:'.$dzen_background_size_breadcrumbs_image : '';

	$dzen_background_position_breadcrumbs_image = get_theme_mod('dzen_title_breadcrumbs_bar_background_position', 'center center');
	$dzen_background_position_breadcrumbs_image = ($dzen_background_position_breadcrumbs_image!='' && $dzen_title_breadcrumbs_image!= '') ? ' background-position:'.$dzen_background_position_breadcrumbs_image : '';

	$custom_css.= '#title_breadcrumbs_bar{'.$dzen_title_breadcrumbs_color.'; '.$dzen_title_breadcrumbs_image.'; '.$dzen_background_repeat_breadcrumbs_image.'; '.$dzen_background_size_breadcrumbs_image.'; '.$dzen_background_position_breadcrumbs_image.';}';