jQuery(document).ready(function($) {
    "use strict";

    //Preloader

    $('body.preloader').jpreLoader({
        showSplash : false,
        loaderVPos : '50%',
    }).css('visibility','visible');

    //Onepager scroll

    $(".scroll").click(function(e){
        e.preventDefault();
        var href = $(this).attr('href');
        var hash = href.split('#');
        var url_hash = '#' + hash[1];
        if ($(url_hash).length > 0) {
            var offset = ($(window).width()<769) ? 20 : 100;
            $('html, body').animate({
                scrollTop: $(url_hash).offset().top-offset
            }, 1000);
        }
        else{
            location.href = href;
        }
    });

    //Header

    var $main_slider = $('#dz_main_slider');
    $main_slider.height('auto');
    var $main_header = $('#dz_main_header');
    var $header_spacer = $('#dz_header_spacer');

    $('#dz_main_slider.dz_parallax_slider').height($(window).height());

    var header_height = $main_header.outerHeight();

    $header_spacer.height(header_height).hide();
    var admin_toolbar_height = parseInt($('html').css('marginTop'), 10);



    // Event Tabs Share Icons
    $('.tcvpb_event_content_meta_share i.ci_icon-share').on('click', function() {
        $(this).parent('.tcvpb_event_content_meta_share').toggleClass('show');
    });

    function sticky_header(){
        if($(window).width()>767){
            $main_header.removeClass('sticky_header').removeClass('sticky_header_low');
            $main_header.css({
                'z-index': '2000',
                'position': 'static'
            });
            $main_header.css('position','fixed').css('top', 0+admin_toolbar_height).addClass('sticky_header');
            $header_spacer.show();
            $(document).scroll(function(){
                var padding_diff = parseInt($(document).scrollTop()/2 ,10);
                padding_diff = (padding_diff > 20) ? 20 : padding_diff;
                if(padding_diff>19){
                    $main_header.addClass('sticky_header_low');
                }
                else{
                    $main_header.removeClass('sticky_header_low');
                }
                $header_spacer.height(header_height - padding_diff*2);
                $main_header.css({'paddingTop':30-padding_diff , 'paddingBottom':30-padding_diff});
            });
        } else{
            $header_spacer.hide();
            $main_header.css({
                'position':'relative',
                'top': 0,
                'padding-top': '30px',
                'padding-bottom': '30px',
                'z-index': '0'
            }).removeClass('sticky_header').removeClass('sticky_header_low');
        }
    }
    sticky_header();

    //Accordions

    $('.accordion-group').on('show', function() {
        $(this).find('i').removeClass('icon-plus').addClass('icon-minus');
    });
    $('.accordion-group').on('hide', function() {
        $(this).find('i').removeClass('icon-minus').addClass('icon-plus');
    });


    $('body.home.page').find('.tcvpb_section_tc').each(function(){
        var $section = $(this);
        var section_id = $(this).attr("id");
        var $menu_item;
        $section.waypoint({
            handler: function(direction){
                if(section_id!==undefined){
                    $('.current-menu-item').removeClass('current-menu-item').removeClass('current-menu-ancestor');
                    if(direction==='down'){
                        $menu_item = $('#main_menu a[href="#'+section_id+'"]').parent();
                        if($menu_item.length>0){
                            $menu_item.addClass('current-menu-item');
                        }
                        else{
                            $('#main_menu .current_page_item').addClass('current-menu-item');
                        }
                    }
                    else if(direction==='up'){
                        var previous_section_id = $section.prevAll('[id]:first').attr('id');
                        $menu_item = $('#main_menu a[href="#'+previous_section_id+'"]').parent();
                        if($menu_item.length>0){
                            $menu_item.addClass('current-menu-item');
                        }
                        else{
                            $('#main_menu .current_page_item').addClass('current-menu-item');
                        }
                    }
                }
            },
            offset: 150
        });
    });


    //Superfish
    var $sf = $('#main_menu');
    if($('#ABdev_menu_toggle').css('display') === 'none') {
        // enable superfish when the page first loads if we're on desktop
        $sf.superfish({
            delay:          300,
            animation:      {opacity:'show',height:'show'},
            animationOut:   {height:'hide'},
            speed:          'fast',
            speedOut:       'fast',
            cssArrows:      false,
            disableHI:      true /* load hoverIntent.js in header to use this option */,
            onBeforeShow:   function(){
                var ww = $(window).width();
                if(this.parent().offset() !== undefined){
                    var locUL = this.parent().offset().left + this.width();
                    var locsubUL = this.parent().offset().left + this.parent().width() + this.width();
                    var par = this.parent();
                    if(par.parent().is('#main_menu') && (locUL > ww)){
                        this.css('marginLeft', "-"+(locUL-ww+20)+"px");
                    }
                    else if (!par.parent().is('#main_menu') && (locsubUL > ww)){
                        this.css('left', "-"+(this.width())+"px");
                    }
                }
            }
        });
    }

    //Menu Toggle

    $('#ABdev_menu_toggle i').click(function(){
        if($sf.css('display') === 'none'){
            $sf.show();
        } else{
            $sf.hide();
        }
    });

    //Submit and placeholder

    $(".submit").click(function () {
        $(this).closest("form").submit();
    });

    $('input, textarea').placeholder();

    //Timeline posts

    var $content = $("#timeline_posts");
    var $loader = $("#timeline_loading");
    var itemSelector = ('.timeline_post');

    function timeline_classes(){
        $("#timeline_posts").find('.timeline_post').each(function(){
           var posLeft = $(this).css("left");
           if(posLeft == "0px"){
               $(this).removeClass('timeline_post_right').addClass('timeline_post_left');
           } else{
               $(this).removeClass('timeline_post_left').addClass('timeline_post_right');
           }
        });
    }

    $content.imagesLoaded( function() {
        $content.masonry({
          columnWidth: ".timeline_post_first",
          gutter: 100,
          itemSelector: itemSelector,
        });

        timeline_classes();

    });

    $(window).on('scroll', function () {
        if ($(window).scrollTop() + $(window).height()  >= $(document).height() - $('#dz_main_footer').height()) {
             if(!( $loader.hasClass('timeline_loading_loader') || $loader.hasClass('timeline_no_more_posts'))){
                load_posts();
            }
        }
    });

    var pageNumber = 1;
    var cat = $loader.data('category');

    function load_posts(){
        if (!($loader.hasClass('timeline_loading_loader') || $loader.hasClass('timeline_no_more_posts'))) {
            pageNumber++;
            var str = '&cat=' + cat + '&pageNumber=' + pageNumber + '&action=abdev_get_timeline_posts';
            $.ajax({
                type: "POST",
                dataType: "html",
                url: abdev_timeline_posts.ajaxurl,
                data: str,
                success: function(data){
                    var $data = $(data);
                    if($data.length){
                        var $newElements = $data.css({ opacity: 0 });
                        $content.append( $newElements );
                        $content.imagesLoaded(function(){
                            $loader.removeClass('timeline_loading_loader');
                            $content.masonry( 'appended', $newElements, false );
                            $newElements.animate({ opacity: 1 });
                            timeline_classes();
                        });
                    } else {
                        $loader.addClass('timeline_no_more_posts').html(abdev_timeline_posts.noposts);
                    }
                },
                beforeSend : function(){
                        $loader.addClass('timeline_loading_loader').html('');
                },
                error : function(jqXHR, textStatus, errorThrown) {
                    $loader.html(jqXHR + " :: " + textStatus + " :: " + errorThrown);
                },
                complete : function(){
                    $loader.removeClass('timeline_loading_loader');
                    timeline_classes();
                }
            });
        }
        return false;
    }

    //Isotope

    var $isotope_container = $('#dz_latest_portfolio');
    $isotope_container.imagesLoaded( function() {
        $isotope_container.isotope({
            itemSelector : '.portfolio_item',
            animationEngine: 'best-available',
        });
        var $optionSets = $('.option-set'),
            $optionLinks = $optionSets.find('a');
        $optionLinks.click(function(){
            var $this = $(this);
            if ( $this.hasClass('selected') ) {
                return false;
            }
            var $optionSet = $this.parents('.option-set');
            $optionSet.find('.selected').removeClass('selected');
            $this.addClass('selected');
            var options = {},
                key = $optionSet.attr('data-option-key'),
                value = $this.attr('data-option-value');
            value = value === 'false' ? false : value;
            options[ key ] = value;
            if ( key === 'layoutMode' && typeof changeLayoutMode === 'function' ) {
                changeLayoutMode( $this, options );
            } else {
                $isotope_container.isotope( options );
            }
            return false;
        });
    });


    //Nivo Slider in Portfolio

    $(window).load(function() {
        $('#portfolio_gallery_slider').nivoSlider({
            effect:'fade', // Specify sets like: 'fold,fade,sliceDown'
            pauseTime:3000, // How long each slide will show
            directionNav:false, // Next & Prev navigation
            controlNavThumbs:true,
            controlNavThumbsFromRel:false,
            manualAdvance: false,
        });
    });

    //Resize functions

    $(window).resize(function() {

        timeline_classes();

        sticky_header();

        $isotope_container.imagesLoaded( function() {
            $isotope_container.isotope('layout');
        });

        if($('#ABdev_menu_toggle').css('display') === 'none' && !$sf.hasClass('sf-js-enabled')) {
            // you only want SuperFish to be re-enabled once (sf.hasClass)
            $sf.show();
            $sf.superfish({
                delay:          300,
                animation:      {opacity:'show',height:'show'},
                animationOut:   {height:'hide'},
                speed:          'fast',
                speedOut:       'fast',
                cssArrows:      false,
                disableHI:      true /* load hoverIntent.js in header to use this option */,
                onBeforeShow:   function(){
                    var ww = $(window).width();
                    var locUL = this.parent().offset().left + this.width();
                    var locsubUL = this.parent().offset().left + this.parent().width() + this.width();
                    var par = this.parent();
                    if(par.hasClass("menu-item-depth-0") && (locUL > ww)){
                        this.css('marginLeft', "-"+(locUL-ww+20)+"px");
                    }
                    else if (!par.hasClass("menu-item-depth-0") && (locsubUL > ww)){
                        this.css('left', "-"+(this.width())+"px");
                    }
                }
            });
        } else if($('#ABdev_menu_toggle').css('display') != 'none' && $sf.hasClass('sf-js-enabled')) {
            // smaller screen, disable SuperFish
            $sf.superfish('destroy');
            $sf.hide();
        }
    });

});


