<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to ABdev_comment().
 *
 */


 function ABdev_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
			?>
			<li class="post pingback">
				<p><?php esc_html_e( 'Pingback:', 'ABdev_dzen' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( esc_html__( 'Edit', 'ABdev_dzen' ), '<span class="edit-link">', '</span>' ); ?></p>
			<?php
			break;
		default :
			?>
			<li <?php comment_class('clearfix'); ?> id="li-comment-<?php comment_ID(); ?>">
				<?php
				$avatar_size = 42;
				if ( '0' != $comment->comment_parent ){
					$avatar_size = 42;
				}

				echo get_avatar( $comment, $avatar_size );

				/* translators: 1: comment author, 2: date and time */
				printf( esc_html__( '%1$s  %2$s', 'ABdev_dzen' ),
					sprintf( '<span class="comment-author">%s</span>', get_comment_author_link() ),
					sprintf( '<time pubdate datetime="%2$s">%3$s</time>',
						esc_url( get_comment_link( $comment->comment_ID ) ),
						get_comment_time( 'c' ),
						/* translators: 1: date, 2: time */
						sprintf( esc_html__( '%1$s %2$s', 'ABdev_dzen' ), get_comment_date(), get_comment_time() )
					)
				);
				?>
				<span class="reply">
					<?php comment_reply_link( array_merge( $args, array( 'reply_text' => esc_html__( 'Reply', 'ABdev_dzen' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
				</span><!-- .reply -->

				<?php edit_comment_link( esc_html__( 'Edit', 'ABdev_dzen' ), '<span class="edit-link">', '</span>' ); ?>
				<div class="comment-text">
				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'ABdev_dzen' ); ?></em>
					<br />
				<?php else: ?>
				<?php comment_text(); ?>
				<?php endif; ?>
				</div>

			<?php
			break;
		endswitch;
}


?>
	<div id="comments">
	<?php if ( post_password_required() ) : ?>
		<p class="nopassword"><?php esc_html_e( 'This post is password protected. Enter the password to view any comments.', 'ABdev_dzen' ); ?></p>
	</div><!-- #comments -->
	<?php
			/* Stop the rest of comments.php from being processed,
			 * but don't kill the script entirely -- we still have
			 * to fully load the template.
			 */
			return;
		endif;
	?>

	<?php // You can start editing here -- including this comment! ?>

	<?php if ( have_comments() ) : ?>
		<h3 id="comments-title"><?php printf( _n( 'One comment', '%1$s comments', get_comments_number(), 'ABdev_dzen' ), number_format_i18n( get_comments_number() ) );?></h3>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-above">
			<h1 class="assistive-text"><?php esc_html_e( 'Comment navigation', 'ABdev_dzen' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'ABdev_dzen' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'ABdev_dzen' ) ); ?></div>
		</nav>
		<?php endif; // check for comment navigation ?>

		<ol class="commentlist">
			<?php
				/* Loop through and list the comments. Tell wp_list_comments()
				 * to use ABdev_comment() to format the comments.
				 * If you want to overload this in a child theme then you can
				 * define ABdev_comment() and that will be used instead.
				 * See ABdev_comment() in twentyeleven/functions.php for more.
				 */

				wp_list_comments( array( 'callback' => 'ABdev_comment' ) );
			?>
		</ol>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-below">
			<h1 class="assistive-text"><?php esc_html_e( 'Comment navigation', 'ABdev_dzen' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'ABdev_dzen' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'ABdev_dzen' ) ); ?></div>
		</nav>
		<?php endif; // check for comment navigation ?>

	<?php
		/* If there are no comments and comments are closed, let's leave a little note, shall we?
		 * But we don't want the note on pages or post types that do not support comments.
		 */
		elseif ( ! comments_open() && ! is_page() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="nocomments"><?php esc_html_e( 'Comments are closed.', 'ABdev_dzen' ); ?></p>
	<?php endif; ?>

	<?php comment_form(array(
		'comment_notes_after' => '',
		'id_submit' => 'comment-submit',
		'title_reply' => esc_html__( 'Leave a comment', 'ABdev_dzen' ),
	)); ?>

</div><!-- #comments -->
