<?php

$total_pages = $posts->max_num_pages;
if ($total_pages > 1){
	$current_page = max(1, get_query_var('paged'));
	$permalink_structure = get_option('permalink_structure');
	$format = empty( $permalink_structure ) ? '&paged=%#%' : 'page/%#%/';

	echo '<div id="blog_pagination" class="pagination pagination-centered clearfix">';
	echo paginate_links(array(
		'base' => get_pagenum_link(1) . '%_%',
		'format' => $format,
		'current' => $current_page,
		'total' => $total_pages,
		'prev_text' => esc_html__('&laquo; Previous', 'ABdev_dzen'),
		'next_text' => esc_html__('Next &raquo;', 'ABdev_dzen'),
		'type' => 'plain',
	));
	echo '</div>';
}
