<?php
get_header();

$portfolio_data = get_post_custom();

get_template_part('partials/header_menu');
get_template_part('partials/title_breadcrumbs_bar');
?>

<?php //check if portfolio plugin is activated
if(current_user_can( 'manage_options' ) && !in_array( 'abdev-portfolio/abdev-portfolio.php', get_option( 'active_plugins') )):?>
	<section>
		<div class="container">
			<p>
				<strong><?php esc_html_e('This page requires Portfolio plugin to be activated','ABdev_dzen');?></strong>
			</p>
		</div>
	</section>
<?php endif; ?>
<?php if(isset($portfolio_data['ABp_portfolio_show_slider'][0]) && $portfolio_data['ABp_portfolio_show_slider'][0]==1): ?>
	<section id="ABdev_main_slider">
		<?php
		if( isset( $portfolio_data['ABp_portfolio_revslider_alias'][0]) && $portfolio_data['ABp_portfolio_revslider_alias'][0] != '' ){
			if(function_exists('putRevSlider')){
				putRevSlider( $portfolio_data['ABp_portfolio_revslider_alias'][0] );
			}
		}
		else{
			wp_kses(_e('You did not select any slider in <i>Portfolio Slider</i> metabox.', 'ABdev_dzen'), ABdev_allowed_tags());
		}
		?>
	</section>
<?php endif; ?>


	<?php if (have_posts()) : while (have_posts()) : the_post();?>
		<section id="simple_item_portfolio">
			<div class="container">
				<div class="row">
					<div class="span8">
						<?php
						if(isset($portfolio_data['ABp_portfolio_selected_media'][0]) && $portfolio_data['ABp_portfolio_selected_media'][0]=='soundcloud' && isset($portfolio_data['ABp_portfolio_soundcloud'][0]) && $portfolio_data['ABp_portfolio_soundcloud'][0]!=''){
							echo '<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=http%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F'.$portfolio_data['ABp_portfolio_soundcloud'][0].'"></iframe>';
						}
						elseif(isset($portfolio_data['ABp_portfolio_selected_media'][0]) && $portfolio_data['ABp_portfolio_selected_media'][0]=='youtube' && isset($portfolio_data['ABp_portfolio_youtube_id'][0]) && $portfolio_data['ABp_portfolio_youtube_id'][0]!=''){
							echo '<div class="videoWrapper-youtube"><iframe src="http://www.youtube.com/embed/'.$portfolio_data['ABp_portfolio_youtube_id'][0].'?showinfo=0&amp;autohide=1&amp;related=0" frameborder="0" allowfullscreen></iframe></div>';
						}
						elseif(isset($portfolio_data['ABp_portfolio_selected_media'][0]) && $portfolio_data['ABp_portfolio_selected_media'][0]=='vimeo' && isset($portfolio_data['ABp_portfolio_vimeo_id'][0]) && $portfolio_data['ABp_portfolio_vimeo_id'][0]!=''){
							echo '<div class="videoWrapper-vimeo"><iframe src="http://player.vimeo.com/video/'.$portfolio_data['ABp_portfolio_vimeo_id'][0].'?title=0&amp;byline=0&amp;portrait=0" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe></div>';
						}
						elseif(isset($portfolio_data['ABp_portfolio_selected_media'][0]) && $portfolio_data['ABp_portfolio_selected_media'][0]=='gallery'){
							echo'<div class="slider-wrapper theme-default">
	    							   <div id="portfolio_gallery_slider" class="nivoSlider">';
	    							   if (isset($portfolio_data['portfolio_gallery'][0]) && $portfolio_data['portfolio_gallery'][0] != '') {
											foreach (explode(',', $portfolio_data['portfolio_gallery'][0]) as $key) {
						 						echo '<img src="'.esc_url(wp_get_attachment_url($key)).'" data-thumb="'.esc_attr(wp_get_attachment_url($key)).'" alt="">';
											}
	    							   }
						 	echo '</div>
	    						</div>';
						}
						else{
							the_post_thumbnail('full', array('class' => 'portfolio_item_image'));
						}
					?>
					</div>
					<div class="span4 portfolio_item_meta">
						<h2 class="column_title_left"><?php esc_html_e('Project Description', 'ABdev_dzen'); ?></h2>
						<?php if(isset($portfolio_data['ABp_portfolio_description'][0])):?>
							<p class="portfolio_single_description">
								<?php echo $portfolio_data['ABp_portfolio_description'][0];?>
							</p>
						<?php endif; ?>
						<h2 class="column_title_left"><?php esc_html_e('Details', 'ABdev_dzen'); ?></h2>
						<p class="portfolio_single_detail">
							<span class="portfolio_item_meta_label"><?php esc_html_e('Date:', 'ABdev_dzen');?></span>
							<span class="portfolio_item_meta_data"><?php the_date();?></span>
						</p>
						<?php if(isset($portfolio_data['ABp_portfolio_client'][0])):?>
							<p class="portfolio_single_detail">
								<span class="portfolio_item_meta_label"><?php esc_html_e('Client:', 'ABdev_dzen');?></span>
								<span class="portfolio_item_meta_data"><?php echo $portfolio_data['ABp_portfolio_client'][0];?></span>
							</p>
						<?php endif; ?>
						<?php if(isset($portfolio_data['ABp_portfolio_skills'][0])):?>
							<p class="portfolio_single_detail">
								<span class="portfolio_item_meta_label"><?php esc_html_e('Skills:', 'ABdev_dzen');?></span>
								<span class="portfolio_item_meta_data"><?php echo $portfolio_data['ABp_portfolio_skills'][0];?></span>
							</p>
						<?php endif; ?>
						<p class="portfolio_single_detail">
							<span class="portfolio_item_meta_label"><?php esc_html_e('Category:', 'ABdev_dzen');?></span>
							<span class="portfolio_item_meta_data">
							<?php
							$terms = get_the_terms( $post->ID , 'portfolio-category' );
							if(is_array($terms)){
								foreach ( $terms as $term ) {
									if(is_object($term)){
										$categories[] = $term->name;
										$related_cat[] = $term->slug;
									}
								}
							}
							$categories = (isset($categories) && is_array($categories)) ? implode(', ', $categories) : '';
							echo $categories;
							?>
							</span>
						</p>
						<?php if(isset($portfolio_data['ABp_portfolio_link'][0])):?>
							<p class="portfolio_item_view_link">
								<a href="<?php echo $portfolio_data['ABp_portfolio_link'][0];?>" target="<?php echo $portfolio_data['ABp_portfolio_link_target'][0];?>"><?php esc_html_e('View work','ABdev_dzen');?></a>
							</p>
						<?php endif; ?>
						<p class="post_meta_share portfolio_share_social">
							<?php esc_html_e('Share','ABdev_dzen');?>
							<a class="post_share_facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>">
								<i class="ci_icon-facebook"></i>
							</a>
							<a class="post_share_twitter" href="https://twitter.com/home?status=<?php echo(urlencode(esc_html__('Check this ', 'ABdev_dzen'))); ?><?php the_permalink(); ?>">
								<i class="ci_icon-twitter"></i>
							</a>
							<a class="post_share_googleplus" href="https://plus.google.com/share?url=<?php the_permalink(); ?>">
								<i class="ci_icon-googleplus"></i>
							</a>
							<a class="post_share_linkedin" href="https://www.linkedin.com/shareArticle?mini=true&amp;title=<?php echo urlencode(the_title('', '' , false)); ?>&amp;url=<?php urlencode(the_permalink()); ?>">
								<i class="ci_icon-linkedin"></i>
							</a>
						</p>
					</div>
				</div>
			</div>
		</section>

		<?php
		$temp_content = get_the_content();
		if (strpos($temp_content, 'section_dd') !== FALSE || strpos($temp_content, 'section_tc') !== FALSE):?>
			<?php the_content();?>
		<?php else:?>
			<section class="no_padding_top">
				<div class="container">
					<?php the_content();?>
				</div>
			</section>
		<?php endif; ?>

		<?php if(isset($portfolio_data['ABp_portfolio_show_related'][0]) && $portfolio_data['ABp_portfolio_show_related'][0]==1): ?>
			<section id="related_portfolio">
				<div class="container">
					<h3 class="column_title_left"><?php esc_html_e('Related Projects', 'ABdev_dzen'); ?></h3>
					<div class="row portfolio_4column">
						<?php
						$args = array(
							'post_type' => 'portfolio',
							'portfolio-category' => $categories,
							'posts_per_page'=>4,
							'post__not_in'=>array($post->ID),
							);
						$related = new WP_Query( $args );
						$out = $error = '';
						if ($related->have_posts()){
							while ($related->have_posts()){
								$related->the_post();
								$slugs=$in_category='';
								$terms = get_the_terms( $post->ID , 'portfolio-category' );
								if(is_array($terms)){
									foreach ( $terms as $term ) {
										if(is_object($term)){
											$slugs.=' '.$term->slug;
											$filter_slugs[$term->slug] = $term->name;
											$in_category[] = $term->name;
										}
									}
								}
								$in_category = (isset($in_category) && is_array($in_category)) ? implode(', ', $in_category) : '';
								$thumbnail_id = get_post_thumbnail_id($post->ID);
								$thumbnail_object = get_post($thumbnail_id);
								$thumbnail_src=$thumbnail_object->guid;
								echo '<div class="span3">
										<div class="portfolio_inner_content">
											<div class="portfolio_item">
												<div class="overlayed">
													'.get_the_post_thumbnail().'
													<a class="overlay" href="'.get_permalink().'">
														<p class="overlay_title">'.get_the_title().'</p>
														<p class="portfolio_item_tags">'.$in_category.'</p>
													</a>
												</div>
											</div>
										</div>
									</div>';
							}
						}
						wp_reset_postdata();
						?>
					</div>
				</div>
			</section>
		<?php endif; ?>

		<section id="porfolio_pagination">
			<div class="container">
				<div class="row">
					<div class="span12">
						<div id="single_portfolio_pagination" class="clearfix">
							<span class="prev"><?php previous_post_link('%link', '&laquo; '.esc_html__('Previous project','ABdev_dzen') ); ?></span>
							<span class="next"><?php next_post_link('%link', esc_html__('Next project','ABdev_dzen').' &raquo;'); ?></span>
						</div>
					</div>
				</div>
			</div>
		</section>
	<?php endwhile;endif;?>


<?php get_footer();