<?php
get_header();

get_template_part('partials/header_menu');
get_template_part('partials/title_breadcrumbs_bar');

?>
	<section>
		<div class="container">

			<div class="row">

				<div class="span8 content_with_right_sidebar">
					<?php if (have_posts()) :  while (have_posts()) : the_post();
						$custom = get_post_custom();
						?>
						<div class="post_content">
							<div <?php post_class('post_main'); ?>>
								<?php
								if(isset($custom['ABdevFW_selected_media'][0]) && $custom['ABdevFW_selected_media'][0]=='soundcloud' && isset($custom['ABdevFW_soundcloud'][0]) && $custom['ABdevFW_soundcloud'][0]!=''){
									echo '<iframe width="100%" height="166" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=http%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F'.$custom['ABdevFW_soundcloud'][0].'"></iframe>';
								}
								elseif(isset($custom['ABdevFW_selected_media'][0]) && $custom['ABdevFW_selected_media'][0]=='youtube' && isset($custom['ABdevFW_youtube_id'][0]) && $custom['ABdevFW_youtube_id'][0]!=''){
									echo '<div class="videoWrapper-youtube"><iframe src="http://www.youtube.com/embed/'.$custom['ABdevFW_youtube_id'][0].'?showinfo=0&amp;autohide=1&amp;related=0" frameborder="0" allowfullscreen></iframe></div>';
								}
								elseif(isset($custom['ABdevFW_selected_media'][0]) && $custom['ABdevFW_selected_media'][0]=='vimeo' && isset($custom['ABdevFW_vimeo_id'][0]) && $custom['ABdevFW_vimeo_id'][0]!=''){
									echo '<div class="videoWrapper-vimeo"><iframe src="http://player.vimeo.com/video/'.$custom['ABdevFW_vimeo_id'][0].'?title=0&amp;byline=0&amp;portrait=0" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe></div>';
								}
								else{
									the_post_thumbnail();
								}
								?>
								<div class="postmeta-above clearfix">
									<p class="post_meta_date"><i class="ci_icon-time"></i><?php the_date('M j, Y'); ?></p>
									<p class="post_meta_author"><i class="ci_icon-user"></i><?php the_author_posts_link(); ?></p>
									<p class="post_meta_category"><i class="ci_icon-pencil"></i><?php the_category(', '); ?></p>
									<p class="post_meta_comments"><i class="ci_icon-comments"></i><?php echo get_comments_number(); ?></p>
								</div>

								<?php echo ($post->post_excerpt!=='') ? '<h2>'.get_the_excerpt().'</h2>' : '' ?>
								<?php the_content();?>

								<?php wp_link_pages('before=<div id="inner_post_pagination" class="clearfix">&after=</div>&link_before=<span>&link_after=</span>'); ?>

								<div class="postmeta-under clearfix">
									<p class="post_meta_share">
										<span><?php esc_html_e('Share','ABdev_dzen'); ?></span>
										<a class="post_share_facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="ci_icon-facebook"></i></a>
										<a class="post_share_twitter" href="https://twitter.com/home?status=<?php echo(urlencode(esc_html__('Check this ', 'ABdev_dzen'))); ?><?php the_permalink(); ?>"><i class="ci_icon-twitter"></i></a>
										<a class="post_share_googleplus" href="https://plus.google.com/share?url=<?php the_permalink(); ?>"><i class="ci_icon-googleplus"></i></a>
										<a class="post_share_linkedin" href="https://www.linkedin.com/shareArticle?mini=true&title=<?php urlencode(the_title()); ?>&url=<?php the_permalink(); ?>"><i class="ci_icon-linkedin"></i></a>
									</p>
									<p class="post_meta_tags"><?php the_tags( '<i class="ci_icon-tags"></i>',', ', ''); ?></p>
								</div>


								<?php if( !get_theme_mod('hide_author_bio', false)):?>
									<div class="post_about_author clearfix">
										<?php echo get_avatar( $post->post_author, 100 ); ?>
										<h5><?php the_author();?></h5>
										<p><?php echo get_the_author_meta('description'); ?></p>
									</div>
								<?php endif; ?>


							</div>
						</div>


					<?php endwhile;
					else: ?>
						<p><?php esc_html_e('No posts were found. Sorry!', 'ABdev_dzen'); ?></p>
					<?php endif; ?>

					<?php
					if( !get_theme_mod('hide_related', false)):?>
						<?php if(has_tag()!=''): ?>
						<section id="related_section" class="section_border_top">
							<div class="related">
								<h3 id="related_posts"><?php esc_html_e('Related posts', 'ABdev_dzen'); ?></h3>
								<?php
									$tags = wp_get_post_tags($post->ID);
									if ($tags) {
										$tax_ids = array();
								 		foreach( $tags as $individual_tax ) $tax_ids[] = $individual_tax->term_id;
										$args=array(
											'tag__in' => $tax_ids,
											'post__not_in' => array($post->ID),
											'posts_per_page'=>4,
											'ignore_sticky_posts'=>1,
										);
										$related = new WP_Query( $args );
									}

									$out = $error = '';
									if (isset($related) && $related->have_posts()){
										while ($related->have_posts() ){
											$related->the_post();
											if(has_post_thumbnail()!=''){
												echo '<div class="related_item">
														<i class="ci_icon-moonfull"></i><a href="'.esc_url(get_the_permalink()).'">'.get_the_title().'</a>
													</div>';
											}
										}
									}
								wp_reset_postdata();
								?>
							</div>
						</section>
						<?php endif; ?>
					<?php endif; ?>

					<?php
					if( !get_theme_mod('hide_comments', false)):?>
						<section id="comments_section" class="section_border_top">
							<?php comments_template('/partials/comments.php'); ?>
						</section>
					<?php endif; ?>

				</div><!-- end span8 main-content -->

				<aside class="span4 sidebar sidebar_right">
					<?php
					if(isset($custom['custom_sidebar'][0]) && $custom['custom_sidebar'][0]!=''){
						$selected_sidebar=$custom['custom_sidebar'][0];
					}
					else{
						$selected_sidebar=esc_html__( 'Primary Sidebar', 'ABdev_dzen');
					}
					dynamic_sidebar($selected_sidebar);
					?>
				</aside><!-- end span4 sidebar -->

			</div><!-- end row -->

		</div>
	</section>


<?php get_footer();